/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import org.apache.lucene.document.ByteDocValuesField;
import org.apache.lucene.document.DerefBytesDocValuesField;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.IntDocValuesField;
import org.apache.lucene.document.LongDocValuesField;
import org.apache.lucene.document.PackedLongDocValuesField;
import org.apache.lucene.document.ShortDocValuesField;
import org.apache.lucene.document.SortedBytesDocValuesField;
import org.apache.lucene.document.StraightBytesDocValuesField;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public abstract class DocValuesConsumer {
    protected final BytesRef spare = new BytesRef();

    protected abstract DocValues.Type getType();

    public abstract void add(int var1, IndexableField var2) throws IOException;

    public abstract void finish(int var1) throws IOException;

    public abstract int getValueSize();

    public void merge(MergeState mergeState, DocValues[] docValues) throws IOException {
        assert (mergeState != null);
        boolean hasMerged = false;
        for (int readerIDX = 0; readerIDX < mergeState.readers.size(); ++readerIDX) {
            MergeState.IndexReaderAndLiveDocs reader = mergeState.readers.get(readerIDX);
            if (docValues[readerIDX] == null) continue;
            hasMerged = true;
            this.merge(docValues[readerIDX], mergeState.docBase[readerIDX], reader.reader.maxDoc(), reader.liveDocs);
            mergeState.checkAbort.work(reader.reader.maxDoc());
        }
        if (hasMerged) {
            this.finish(mergeState.segmentInfo.getDocCount());
        }
    }

    protected void merge(DocValues reader, int docBase, int docCount, Bits liveDocs) throws IOException {
        Field scratchField;
        DocValues.Source source = reader.getDirectSource();
        assert (source != null);
        int docID = docBase;
        DocValues.Type type = this.getType();
        switch (type) {
            case VAR_INTS: {
                scratchField = new PackedLongDocValuesField("", 0L);
                break;
            }
            case FIXED_INTS_8: {
                scratchField = new ByteDocValuesField("", 0);
                break;
            }
            case FIXED_INTS_16: {
                scratchField = new ShortDocValuesField("", 0);
                break;
            }
            case FIXED_INTS_32: {
                scratchField = new IntDocValuesField("", 0);
                break;
            }
            case FIXED_INTS_64: {
                scratchField = new LongDocValuesField("", 0L);
                break;
            }
            case FLOAT_32: {
                scratchField = new FloatDocValuesField("", 0.0f);
                break;
            }
            case FLOAT_64: {
                scratchField = new DoubleDocValuesField("", 0.0);
                break;
            }
            case BYTES_FIXED_STRAIGHT: {
                scratchField = new StraightBytesDocValuesField("", new BytesRef(), true);
                break;
            }
            case BYTES_VAR_STRAIGHT: {
                scratchField = new StraightBytesDocValuesField("", new BytesRef(), false);
                break;
            }
            case BYTES_FIXED_DEREF: {
                scratchField = new DerefBytesDocValuesField("", new BytesRef(), true);
                break;
            }
            case BYTES_VAR_DEREF: {
                scratchField = new DerefBytesDocValuesField("", new BytesRef(), false);
                break;
            }
            case BYTES_FIXED_SORTED: {
                scratchField = new SortedBytesDocValuesField("", new BytesRef(), true);
                break;
            }
            case BYTES_VAR_SORTED: {
                scratchField = new SortedBytesDocValuesField("", new BytesRef(), false);
                break;
            }
            default: {
                throw new IllegalStateException("unknown Type: " + (Object)((Object)type));
            }
        }
        for (int i = 0; i < docCount; ++i) {
            if (liveDocs != null && !liveDocs.get(i)) continue;
            this.mergeDoc(scratchField, source, docID++, i);
        }
    }

    protected void mergeDoc(Field scratchField, DocValues.Source source, int docID, int sourceDoc) throws IOException {
        switch (this.getType()) {
            case BYTES_FIXED_STRAIGHT: 
            case BYTES_VAR_STRAIGHT: 
            case BYTES_FIXED_DEREF: 
            case BYTES_VAR_DEREF: 
            case BYTES_FIXED_SORTED: 
            case BYTES_VAR_SORTED: {
                scratchField.setBytesValue(source.getBytes(sourceDoc, this.spare));
                break;
            }
            case FIXED_INTS_8: {
                scratchField.setByteValue((byte)source.getInt(sourceDoc));
                break;
            }
            case FIXED_INTS_16: {
                scratchField.setShortValue((short)source.getInt(sourceDoc));
                break;
            }
            case FIXED_INTS_32: {
                scratchField.setIntValue((int)source.getInt(sourceDoc));
                break;
            }
            case FIXED_INTS_64: {
                scratchField.setLongValue(source.getInt(sourceDoc));
                break;
            }
            case VAR_INTS: {
                scratchField.setLongValue(source.getInt(sourceDoc));
                break;
            }
            case FLOAT_32: {
                scratchField.setFloatValue((float)source.getFloat(sourceDoc));
                break;
            }
            case FLOAT_64: {
                scratchField.setDoubleValue(source.getFloat(sourceDoc));
            }
        }
        this.add(docID, scratchField);
    }
}

