/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public abstract class AbstractAnalysisFactory {
    protected Map<String, String> args;
    protected Version luceneMatchVersion = null;

    public void init(Map<String, String> args) {
        this.args = args;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    protected final void assureMatchVersion() {
        if (this.luceneMatchVersion == null) {
            throw new InitializationException("Configuration Error: Factory '" + this.getClass().getName() + "' needs a 'luceneMatchVersion' parameter");
        }
    }

    public void setLuceneMatchVersion(Version luceneMatchVersion) {
        this.luceneMatchVersion = luceneMatchVersion;
    }

    public Version getLuceneMatchVersion() {
        return this.luceneMatchVersion;
    }

    protected int getInt(String name) {
        return this.getInt(name, -1, false);
    }

    protected int getInt(String name, int defaultVal) {
        return this.getInt(name, defaultVal, true);
    }

    protected int getInt(String name, int defaultVal, boolean useDefault) {
        String s = this.args.get(name);
        if (s == null) {
            if (useDefault) {
                return defaultVal;
            }
            throw new InitializationException("Configuration Error: missing parameter '" + name + "'");
        }
        return Integer.parseInt(s);
    }

    protected boolean getBoolean(String name, boolean defaultVal) {
        return this.getBoolean(name, defaultVal, true);
    }

    protected boolean getBoolean(String name, boolean defaultVal, boolean useDefault) {
        String s = this.args.get(name);
        if (s == null) {
            if (useDefault) {
                return defaultVal;
            }
            throw new InitializationException("Configuration Error: missing parameter '" + name + "'");
        }
        return Boolean.parseBoolean(s);
    }

    protected Pattern getPattern(String name) {
        try {
            String pat = this.args.get(name);
            if (null == pat) {
                throw new InitializationException("Configuration Error: missing parameter '" + name + "'");
            }
            return Pattern.compile(this.args.get(name));
        }
        catch (PatternSyntaxException e) {
            throw new InitializationException("Configuration Error: '" + name + "' can not be parsed in " + this.getClass().getSimpleName(), e);
        }
    }

    protected CharArraySet getWordSet(ResourceLoader loader, String wordFiles, boolean ignoreCase) throws IOException {
        this.assureMatchVersion();
        List<String> files = this.splitFileNames(wordFiles);
        CharArraySet words = null;
        if (files.size() > 0) {
            words = new CharArraySet(this.luceneMatchVersion, files.size() * 10, ignoreCase);
            for (String file : files) {
                List<String> wlist = loader.getLines(file.trim());
                words.addAll(StopFilter.makeStopSet(this.luceneMatchVersion, wlist, ignoreCase));
            }
        }
        return words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CharArraySet getSnowballWordSet(ResourceLoader loader, String wordFiles, boolean ignoreCase) throws IOException {
        this.assureMatchVersion();
        List<String> files = this.splitFileNames(wordFiles);
        CharArraySet words = null;
        if (files.size() > 0) {
            words = new CharArraySet(this.luceneMatchVersion, files.size() * 10, ignoreCase);
            for (String file : files) {
                InputStream stream = null;
                InputStreamReader reader = null;
                try {
                    stream = loader.openResource(file.trim());
                    CharsetDecoder decoder = IOUtils.CHARSET_UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    reader = new InputStreamReader(stream, decoder);
                    WordlistLoader.getSnowballWordSet((Reader)reader, words);
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException(reader, stream);
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(reader, stream);
            }
        }
        return words;
    }

    protected List<String> splitFileNames(String fileNames) {
        if (fileNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String file : fileNames.split("(?<!\\\\),")) {
            result.add(file.replaceAll("\\\\(?=,)", ""));
        }
        return result;
    }
}

