/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.util.CharArraySet;

public final class KeywordMarkerFilter
extends TokenFilter {
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final CharArraySet keywordSet;

    public KeywordMarkerFilter(TokenStream in, CharArraySet keywordSet) {
        super(in);
        this.keywordSet = keywordSet;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.keywordSet.contains(this.termAtt.buffer(), 0, this.termAtt.length())) {
                this.keywordAttr.setKeyword(true);
            }
            return true;
        }
        return false;
    }
}

