/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;

public class UnixUserGroupInformation
extends UserGroupInformation {
    public static final String DEFAULT_USERNAME = "DrWho";
    public static final String DEFAULT_GROUP = "Tardis";
    public static final String UGI_PROPERTY_NAME = "hadoop.job.ugi";
    private static final HashMap<String, UnixUserGroupInformation> user2UGIMap = new HashMap();
    private String userName;
    private String[] groupNames;
    private static final String UGI_TECHNOLOGY = "STRING_UGI";

    public static UnixUserGroupInformation createImmutable(String[] ugi) {
        return new UnixUserGroupInformation(ugi){

            @Override
            public void readFields(DataInput in) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public UnixUserGroupInformation() {
    }

    public UnixUserGroupInformation(String userName, String[] groupNames) {
        this.setUserGroupNames(userName, groupNames);
    }

    public UnixUserGroupInformation(String[] ugi) {
        if (ugi == null || ugi.length < 2) {
            throw new IllegalArgumentException("Parameter does contain at least one user name and one group name");
        }
        String[] groupNames = new String[ugi.length - 1];
        System.arraycopy(ugi, 1, groupNames, 0, groupNames.length);
        this.setUserGroupNames(ugi[0], groupNames);
    }

    private void setUserGroupNames(String userName, String[] groupNames) {
        if (userName == null || userName.length() == 0 || groupNames == null || groupNames.length == 0) {
            throw new IllegalArgumentException("Parameters should not be null or an empty string/array");
        }
        for (int i = 0; i < groupNames.length; ++i) {
            if (groupNames[i] != null && groupNames[i].length() != 0) continue;
            throw new IllegalArgumentException("A null group name at index " + i);
        }
        this.userName = userName;
        this.groupNames = groupNames;
    }

    @Override
    public String[] getGroupNames() {
        return this.groupNames;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String ugiType = Text.readString(in);
        if (!UGI_TECHNOLOGY.equals(ugiType)) {
            throw new IOException("Expect UGI prefix: STRING_UGI, but receive a prefix: " + ugiType);
        }
        this.userName = Text.readString(in);
        int numOfGroups = WritableUtils.readVInt(in);
        this.groupNames = new String[numOfGroups];
        for (int i = 0; i < numOfGroups; ++i) {
            this.groupNames[i] = Text.readString(in);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, UGI_TECHNOLOGY);
        Text.writeString(out, this.userName);
        WritableUtils.writeVInt(out, this.groupNames.length);
        for (String groupName : this.groupNames) {
            Text.writeString(out, groupName);
        }
    }

    public static void saveToConf(Configuration conf, String attr, UnixUserGroupInformation ugi) {
        conf.set(attr, ugi.toString());
    }

    public static UnixUserGroupInformation readFromConf(Configuration conf, String attr) throws LoginException {
        String[] ugi = conf.getStrings(attr);
        if (ugi == null) {
            return null;
        }
        UnixUserGroupInformation currentUGI = null;
        if (ugi.length > 0) {
            currentUGI = user2UGIMap.get(ugi[0]);
        }
        if (currentUGI == null) {
            try {
                currentUGI = new UnixUserGroupInformation(ugi);
                user2UGIMap.put(currentUGI.getUserName(), currentUGI);
            }
            catch (IllegalArgumentException e) {
                throw new LoginException("Login failed: " + e.getMessage());
            }
        }
        return currentUGI;
    }

    public static UnixUserGroupInformation login() throws LoginException {
        try {
            String[] groupNames;
            String userName;
            try {
                userName = UnixUserGroupInformation.getUnixUserName();
            }
            catch (Exception e) {
                userName = DEFAULT_USERNAME;
            }
            UnixUserGroupInformation ugi = user2UGIMap.get(userName);
            if (ugi != null) {
                return ugi;
            }
            try {
                groupNames = UnixUserGroupInformation.getUnixGroups();
            }
            catch (Exception e) {
                groupNames = new String[]{DEFAULT_GROUP};
            }
            ugi = new UnixUserGroupInformation(userName, groupNames);
            user2UGIMap.put(ugi.getUserName(), ugi);
            return ugi;
        }
        catch (Exception e) {
            throw new LoginException("Login failed: " + e.getMessage());
        }
    }

    public static UnixUserGroupInformation login(Configuration conf) throws LoginException {
        return UnixUserGroupInformation.login(conf, false);
    }

    public static UnixUserGroupInformation login(Configuration conf, boolean save) throws LoginException {
        UnixUserGroupInformation ugi = UnixUserGroupInformation.readFromConf(conf, UGI_PROPERTY_NAME);
        if (ugi == null) {
            ugi = UnixUserGroupInformation.login();
            LOG.debug("Unix Login: " + ugi);
            if (save) {
                UnixUserGroupInformation.saveToConf(conf, UGI_PROPERTY_NAME, ugi);
            }
        }
        return ugi;
    }

    private static String toString(String[] strArray) {
        if (strArray == null || strArray.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(strArray[0]);
        for (int i = 1; i < strArray.length; ++i) {
            buf.append(' ');
            buf.append(strArray[i]);
        }
        return buf.toString();
    }

    static String getUnixUserName() throws IOException {
        String[] result = UnixUserGroupInformation.executeShellCommand(new String[]{"whoami"});
        if (result.length != 1) {
            throw new IOException("Expect one token as the result of whoami: " + UnixUserGroupInformation.toString(result));
        }
        return result[0];
    }

    private static String[] getUnixGroups() throws IOException {
        return UnixUserGroupInformation.executeShellCommand(Shell.getGROUPS_COMMAND());
    }

    private static String[] executeShellCommand(String[] command) throws IOException {
        String groups = Shell.execCommand(command);
        StringTokenizer tokenizer = new StringTokenizer(groups);
        int numOfTokens = tokenizer.countTokens();
        String[] tokens = new String[numOfTokens];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnixUserGroupInformation)) {
            return false;
        }
        UnixUserGroupInformation otherUGI = (UnixUserGroupInformation)other;
        if (this.userName == null ? otherUGI.getUserName() != null : !this.userName.equals(otherUGI.getUserName())) {
            return false;
        }
        if (this.groupNames == otherUGI.groupNames) {
            return true;
        }
        if (this.groupNames.length != otherUGI.groupNames.length) {
            return false;
        }
        if (this.groupNames.length > 0 && !this.groupNames[0].equals(otherUGI.groupNames[0])) {
            return false;
        }
        return new TreeSet<String>(Arrays.asList(this.groupNames)).equals(new TreeSet<String>(Arrays.asList(otherUGI.groupNames)));
    }

    @Override
    public int hashCode() {
        return this.getUserName().hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.userName);
        for (String groupName : this.groupNames) {
            buf.append(',');
            buf.append(groupName);
        }
        return buf.toString();
    }

    @Override
    public String getName() {
        return this.toString();
    }
}

