/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.security.Policy;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Group;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ConfiguredPolicy;
import org.apache.hadoop.security.authorize.PolicyProvider;

public class SecurityUtil {
    private static final Log LOG = LogFactory.getLog(SecurityUtil.class);

    public static void setPolicy(Policy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting Hadoop security policy");
        }
        Policy.setPolicy(policy);
    }

    public static Policy getPolicy() {
        return Policy.getPolicy();
    }

    public static Subject getSubject(UserGroupInformation ugi) {
        if (ugi == null) {
            return null;
        }
        HashSet<Principal> principals = new HashSet<Principal>(ugi.getGroupNames().length + 1);
        User userPrincipal = new User(ugi.getUserName());
        principals.add(userPrincipal);
        for (String group : ugi.getGroupNames()) {
            Group groupPrincipal = new Group(group);
            principals.add(groupPrincipal);
        }
        principals.add(ugi);
        Subject user = new Subject(false, principals, new HashSet(), new HashSet());
        return user;
    }

    static {
        SecurityUtil.setPolicy(new ConfiguredPolicy(new Configuration(), PolicyProvider.DEFAULT_POLICY_PROVIDER));
    }

    public static class AccessControlList {
        public static final String WILDCARD_ACL_VALUE = "*";
        private Set<String> users = new TreeSet<String>();
        private Set<String> groups = new TreeSet<String>();
        private boolean allAllowed;

        public AccessControlList(String aclString) {
            if (aclString.contains(WILDCARD_ACL_VALUE) && aclString.trim().equals(WILDCARD_ACL_VALUE)) {
                this.allAllowed = true;
            } else {
                String[] groupsStr;
                String[] usersStr;
                String[] userGroupStrings = aclString.split(" ", 2);
                if (userGroupStrings.length >= 1 && (usersStr = userGroupStrings[0].split(",")).length >= 1) {
                    AccessControlList.addToSet(this.users, usersStr);
                }
                if (userGroupStrings.length == 2 && (groupsStr = userGroupStrings[1].split(",")).length >= 1) {
                    AccessControlList.addToSet(this.groups, groupsStr);
                }
            }
        }

        public boolean allAllowed() {
            return this.allAllowed;
        }

        public Set<String> getUsers() {
            return this.users;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        private static final void addToSet(Set<String> set, String[] strings) {
            for (String s : strings) {
                if ((s = s.trim()).length() <= 0) continue;
                set.add(s);
            }
        }
    }
}

