/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.TaskCompletionEvent;

class MapTaskCompletionEventsUpdate
implements Writable {
    TaskCompletionEvent[] events;
    boolean reset;

    public MapTaskCompletionEventsUpdate() {
    }

    public MapTaskCompletionEventsUpdate(TaskCompletionEvent[] events, boolean reset) {
        this.events = events;
        this.reset = reset;
    }

    public boolean shouldReset() {
        return this.reset;
    }

    public TaskCompletionEvent[] getMapTaskCompletionEvents() {
        return this.events;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.reset);
        out.writeInt(this.events.length);
        for (TaskCompletionEvent event : this.events) {
            event.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.reset = in.readBoolean();
        this.events = new TaskCompletionEvent[in.readInt()];
        for (int i = 0; i < this.events.length; ++i) {
            this.events[i] = new TaskCompletionEvent();
            this.events[i].readFields(in);
        }
    }
}

