/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.ResourceEstimator;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.StringUtils;

class JobInProgress {
    static final Log LOG = LogFactory.getLog(JobInProgress.class);
    JobProfile profile;
    JobStatus status;
    Path jobFile = null;
    Path localJobFile = null;
    Path localJarFile = null;
    TaskInProgress[] maps = new TaskInProgress[0];
    TaskInProgress[] reduces = new TaskInProgress[0];
    TaskInProgress[] cleanup = new TaskInProgress[0];
    TaskInProgress[] setup = new TaskInProgress[0];
    int numMapTasks = 0;
    int numReduceTasks = 0;
    int runningMapTasks = 0;
    int runningReduceTasks = 0;
    int finishedMapTasks = 0;
    int finishedReduceTasks = 0;
    int failedMapTasks = 0;
    int failedReduceTasks = 0;
    private static float DEFAULT_COMPLETED_MAPS_PERCENT_FOR_REDUCE_SLOWSTART = 0.05f;
    int completedMapsForReduceSlowstart = 0;
    int speculativeMapTasks = 0;
    int speculativeReduceTasks = 0;
    int mapFailuresPercent = 0;
    int reduceFailuresPercent = 0;
    int failedMapTIPs = 0;
    int failedReduceTIPs = 0;
    private volatile boolean launchedCleanup = false;
    private volatile boolean launchedSetup = false;
    private volatile boolean jobKilled = false;
    private volatile boolean jobFailed = false;
    JobPriority priority = JobPriority.NORMAL;
    final JobTracker jobtracker;
    Map<Node, List<TaskInProgress>> nonRunningMapCache;
    Map<Node, Set<TaskInProgress>> runningMapCache;
    List<TaskInProgress> nonLocalMaps;
    Set<TaskInProgress> nonLocalRunningMaps;
    List<TaskInProgress> nonRunningReduces;
    Set<TaskInProgress> runningReduces;
    List<TaskAttemptID> mapCleanupTasks = new LinkedList<TaskAttemptID>();
    List<TaskAttemptID> reduceCleanupTasks = new LinkedList<TaskAttemptID>();
    private final int maxLevel;
    private final int anyCacheLevel;
    private static final int NON_LOCAL_CACHE_LEVEL = -1;
    private int taskCompletionEventTracker = 0;
    List<TaskCompletionEvent> taskCompletionEvents;
    private static final double CLUSTER_BLACKLIST_PERCENT = 0.25;
    private static final double MAX_ALLOWED_FETCH_FAILURES_PERCENT = 0.5;
    private volatile int clusterSize = 0;
    private volatile int flakyTaskTrackers = 0;
    private Map<String, Integer> trackerToFailuresMap = new TreeMap<String, Integer>();
    private ResourceEstimator resourceEstimator;
    long startTime;
    long launchTime;
    long finishTime;
    private final int restartCount;
    private JobConf conf;
    AtomicBoolean tasksInited = new AtomicBoolean(false);
    private JobInitKillStatus jobInitKillStatus = new JobInitKillStatus();
    private LocalFileSystem localFs;
    private JobID jobId;
    private boolean hasSpeculativeMaps;
    private boolean hasSpeculativeReduces;
    private long inputLength = 0L;
    private Counters jobCounters = new Counters();
    private MetricsRecord jobMetrics;
    private static final int MAX_FETCH_FAILURES_NOTIFICATIONS = 3;
    private Map<TaskAttemptID, Integer> mapTaskIdToFetchFailuresMap = new TreeMap<TaskAttemptID, Integer>();
    private Object schedulingInfo;

    protected JobInProgress(JobID jobid, JobConf conf) {
        this.conf = conf;
        this.jobId = jobid;
        this.numMapTasks = conf.getNumMapTasks();
        this.numReduceTasks = conf.getNumReduceTasks();
        this.maxLevel = 2;
        this.anyCacheLevel = this.maxLevel + 1;
        this.jobtracker = null;
        this.restartCount = 0;
    }

    public JobInProgress(JobID jobid, JobTracker jobtracker, JobConf default_conf) throws IOException {
        this(jobid, jobtracker, default_conf, 0);
    }

    public JobInProgress(JobID jobid, JobTracker jobtracker, JobConf default_conf, int rCount) throws IOException {
        this.restartCount = rCount;
        this.jobId = jobid;
        String url = "http://" + jobtracker.getJobTrackerMachine() + ":" + jobtracker.getInfoPort() + "/jobdetails.jsp?jobid=" + jobid;
        this.jobtracker = jobtracker;
        this.status = new JobStatus(jobid, 0.0f, 0.0f, 4);
        this.startTime = System.currentTimeMillis();
        this.status.setStartTime(this.startTime);
        this.localFs = FileSystem.getLocal(default_conf);
        JobConf default_job_conf = new JobConf(default_conf);
        this.localJobFile = default_job_conf.getLocalPath("jobTracker/" + jobid + ".xml");
        this.localJarFile = default_job_conf.getLocalPath("jobTracker/" + jobid + ".jar");
        Path jobDir = jobtracker.getSystemDirectoryForJob(this.jobId);
        FileSystem fs = jobDir.getFileSystem(default_conf);
        this.jobFile = new Path(jobDir, "job.xml");
        fs.copyToLocalFile(this.jobFile, this.localJobFile);
        this.conf = new JobConf(this.localJobFile);
        this.priority = this.conf.getJobPriority();
        this.status.setJobPriority(this.priority);
        this.profile = new JobProfile(this.conf.getUser(), jobid, this.jobFile.toString(), url, this.conf.getJobName(), this.conf.getQueueName());
        String jarFile = this.conf.getJar();
        if (jarFile != null) {
            fs.copyToLocalFile(new Path(jarFile), this.localJarFile);
            this.conf.setJar(this.localJarFile.toString());
        }
        this.numMapTasks = this.conf.getNumMapTasks();
        this.numReduceTasks = this.conf.getNumReduceTasks();
        this.taskCompletionEvents = new ArrayList<TaskCompletionEvent>(this.numMapTasks + this.numReduceTasks + 10);
        this.mapFailuresPercent = this.conf.getMaxMapTaskFailuresPercent();
        this.reduceFailuresPercent = this.conf.getMaxReduceTaskFailuresPercent();
        MetricsContext metricsContext = MetricsUtil.getContext("mapred");
        this.jobMetrics = MetricsUtil.createRecord(metricsContext, "job");
        this.jobMetrics.setTag("user", this.conf.getUser());
        this.jobMetrics.setTag("sessionId", this.conf.getSessionId());
        this.jobMetrics.setTag("jobName", this.conf.getJobName());
        this.jobMetrics.setTag("jobId", jobid.toString());
        this.hasSpeculativeMaps = this.conf.getMapSpeculativeExecution();
        this.hasSpeculativeReduces = this.conf.getReduceSpeculativeExecution();
        this.maxLevel = jobtracker.getNumTaskCacheLevels();
        this.anyCacheLevel = this.maxLevel + 1;
        this.nonLocalMaps = new LinkedList<TaskInProgress>();
        this.nonLocalRunningMaps = new LinkedHashSet<TaskInProgress>();
        this.runningMapCache = new IdentityHashMap<Node, Set<TaskInProgress>>();
        this.nonRunningReduces = new LinkedList<TaskInProgress>();
        this.runningReduces = new LinkedHashSet<TaskInProgress>();
        this.resourceEstimator = new ResourceEstimator(this);
    }

    public void updateMetrics() {
        Counters counters = this.getCounters();
        for (Counters.Group group : counters) {
            this.jobMetrics.setTag("group", group.getDisplayName());
            for (Counters.Counter counter : group) {
                this.jobMetrics.setTag("counter", counter.getDisplayName());
                this.jobMetrics.setMetric("value", (float)counter.getCounter());
                this.jobMetrics.update();
            }
        }
    }

    public void cleanUpMetrics() {
        this.jobMetrics.removeTag("group");
        this.jobMetrics.removeTag("counter");
        this.jobMetrics.remove();
    }

    private void printCache(Map<Node, List<TaskInProgress>> cache) {
        LOG.info("The taskcache info:");
        for (Map.Entry<Node, List<TaskInProgress>> n : cache.entrySet()) {
            List<TaskInProgress> tips = n.getValue();
            LOG.info("Cached TIPs on node: " + n.getKey());
            for (TaskInProgress tip : tips) {
                LOG.info("tip : " + tip.getTIPId());
            }
        }
    }

    private Map<Node, List<TaskInProgress>> createCache(JobClient.RawSplit[] splits, int maxLevel) {
        IdentityHashMap<Node, List<TaskInProgress>> cache = new IdentityHashMap<Node, List<TaskInProgress>>(maxLevel);
        for (int i = 0; i < splits.length; ++i) {
            String[] splitLocations = splits[i].getLocations();
            if (splitLocations.length == 0) {
                this.nonLocalMaps.add(this.maps[i]);
                continue;
            }
            for (String host : splitLocations) {
                Node node = this.jobtracker.resolveAndAddToTopology(host);
                LOG.info("tip:" + this.maps[i].getTIPId() + " has split on node:" + node);
                for (int j = 0; j < maxLevel; ++j) {
                    ArrayList<TaskInProgress> hostMaps = (ArrayList<TaskInProgress>)cache.get(node);
                    if (hostMaps == null) {
                        hostMaps = new ArrayList<TaskInProgress>();
                        cache.put(node, hostMaps);
                        hostMaps.add(this.maps[i]);
                    }
                    if (hostMaps.get(hostMaps.size() - 1) != this.maps[i]) {
                        hostMaps.add(this.maps[i]);
                    }
                    node = node.getParent();
                }
            }
        }
        return cache;
    }

    public boolean inited() {
        return this.tasksInited.get();
    }

    boolean hasRestarted() {
        return this.restartCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initTasks() throws IOException, KillInterruptedException {
        int i;
        JobClient.RawSplit[] splits;
        if (this.tasksInited.get() || this.isComplete()) {
            return;
        }
        JobInitKillStatus jobInitKillStatus = this.jobInitKillStatus;
        synchronized (jobInitKillStatus) {
            if (this.jobInitKillStatus.killed || this.jobInitKillStatus.initStarted) {
                return;
            }
            this.jobInitKillStatus.initStarted = true;
        }
        LOG.info("Initializing " + this.jobId);
        JobHistory.JobInfo.logSubmitted(this.getJobID(), this.conf, this.jobFile.toString(), this.startTime, this.hasRestarted());
        this.setPriority(this.priority);
        String jobFile = this.profile.getJobFile();
        Path sysDir = new Path(this.jobtracker.getSystemDir());
        FileSystem fs = sysDir.getFileSystem(this.conf);
        FSDataInputStream splitFile = fs.open(new Path(this.conf.get("mapred.job.split.file")));
        try {
            splits = JobClient.readSplitFile(splitFile);
        }
        finally {
            splitFile.close();
        }
        this.numMapTasks = splits.length;
        int maxTasks = this.jobtracker.getMaxTasksPerJob();
        if (maxTasks > 0 && this.numMapTasks + this.numReduceTasks > maxTasks) {
            throw new IOException("The number of tasks for this job " + (this.numMapTasks + this.numReduceTasks) + " exceeds the configured limit " + maxTasks);
        }
        this.jobtracker.getInstrumentation().addWaiting(this.getJobID(), this.numMapTasks + this.numReduceTasks);
        this.maps = new TaskInProgress[this.numMapTasks];
        for (i = 0; i < this.numMapTasks; ++i) {
            this.inputLength += splits[i].getDataLength();
            this.maps[i] = new TaskInProgress(this.jobId, jobFile, splits[i], this.jobtracker, this.conf, this, i);
        }
        LOG.info("Input size for job " + this.jobId + " = " + this.inputLength + ". Number of splits = " + splits.length);
        if (this.numMapTasks > 0) {
            this.nonRunningMapCache = this.createCache(splits, this.maxLevel);
        }
        this.launchTime = System.currentTimeMillis();
        this.reduces = new TaskInProgress[this.numReduceTasks];
        for (i = 0; i < this.numReduceTasks; ++i) {
            this.reduces[i] = new TaskInProgress(this.jobId, jobFile, this.numMapTasks, i, this.jobtracker, this.conf, this);
            this.nonRunningReduces.add(this.reduces[i]);
        }
        this.completedMapsForReduceSlowstart = (int)Math.ceil(this.conf.getFloat("mapred.reduce.slowstart.completed.maps", DEFAULT_COMPLETED_MAPS_PERCENT_FOR_REDUCE_SLOWSTART) * (float)this.numMapTasks);
        this.cleanup = new TaskInProgress[2];
        JobClient.RawSplit emptySplit = new JobClient.RawSplit();
        this.cleanup[0] = new TaskInProgress(this.jobId, jobFile, emptySplit, this.jobtracker, this.conf, this, this.numMapTasks);
        this.cleanup[0].setJobCleanupTask();
        this.cleanup[1] = new TaskInProgress(this.jobId, jobFile, this.numMapTasks, this.numReduceTasks, this.jobtracker, this.conf, this);
        this.cleanup[1].setJobCleanupTask();
        this.setup = new TaskInProgress[2];
        this.setup[0] = new TaskInProgress(this.jobId, jobFile, emptySplit, this.jobtracker, this.conf, this, this.numMapTasks + 1);
        this.setup[0].setJobSetupTask();
        this.setup[1] = new TaskInProgress(this.jobId, jobFile, this.numMapTasks, this.numReduceTasks + 1, this.jobtracker, this.conf, this);
        this.setup[1].setJobSetupTask();
        JobInitKillStatus jobInitKillStatus2 = this.jobInitKillStatus;
        synchronized (jobInitKillStatus2) {
            this.jobInitKillStatus.initDone = true;
            if (this.jobInitKillStatus.killed) {
                throw new KillInterruptedException("Job " + this.jobId + " killed in init");
            }
        }
        this.tasksInited.set(true);
        JobHistory.JobInfo.logInited(this.profile.getJobID(), this.launchTime, this.numMapTasks, this.numReduceTasks);
    }

    public JobProfile getProfile() {
        return this.profile;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public synchronized long getLaunchTime() {
        return this.launchTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int desiredMaps() {
        return this.numMapTasks;
    }

    public synchronized int finishedMaps() {
        return this.finishedMapTasks;
    }

    public int desiredReduces() {
        return this.numReduceTasks;
    }

    public synchronized int runningMaps() {
        return this.runningMapTasks;
    }

    public synchronized int runningReduces() {
        return this.runningReduceTasks;
    }

    public synchronized int finishedReduces() {
        return this.finishedReduceTasks;
    }

    public synchronized int pendingMaps() {
        return this.numMapTasks - this.runningMapTasks - this.failedMapTIPs - this.finishedMapTasks + this.speculativeMapTasks;
    }

    public synchronized int pendingReduces() {
        return this.numReduceTasks - this.runningReduceTasks - this.failedReduceTIPs - this.finishedReduceTasks + this.speculativeReduceTasks;
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(JobPriority priority) {
        this.priority = priority == null ? JobPriority.NORMAL : priority;
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            this.status.setJobPriority(priority);
        }
        JobHistory.JobInfo.logJobPriority(this.jobId, priority);
    }

    synchronized void updateJobInfo(long startTime, long launchTime) {
        this.startTime = startTime;
        this.launchTime = launchTime;
        JobHistory.JobInfo.logJobInfo(this.jobId, startTime, launchTime);
    }

    int getNumRestarts() {
        return this.restartCount;
    }

    long getInputLength() {
        return this.inputLength;
    }

    boolean isCleanupLaunched() {
        return this.launchedCleanup;
    }

    boolean isSetupLaunched() {
        return this.launchedSetup;
    }

    TaskInProgress[] getMapTasks() {
        return this.maps;
    }

    TaskInProgress[] getCleanupTasks() {
        return this.cleanup;
    }

    TaskInProgress[] getSetupTasks() {
        return this.setup;
    }

    TaskInProgress[] getReduceTasks() {
        return this.reduces;
    }

    Set<TaskInProgress> getNonLocalRunningMaps() {
        return this.nonLocalRunningMaps;
    }

    Map<Node, Set<TaskInProgress>> getRunningMapCache() {
        return this.runningMapCache;
    }

    Set<TaskInProgress> getRunningReduces() {
        return this.runningReduces;
    }

    JobConf getJobConf() {
        return this.conf;
    }

    public synchronized Vector<TaskInProgress> reportTasksInProgress(boolean shouldBeMap, boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        TaskInProgress[] tips = null;
        tips = shouldBeMap ? this.maps : this.reduces;
        for (int i = 0; i < tips.length; ++i) {
            if (tips[i].isComplete() != shouldBeComplete) continue;
            results.add(tips[i]);
        }
        return results;
    }

    public synchronized Vector<TaskInProgress> reportCleanupTIPs(boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        for (int i = 0; i < this.cleanup.length; ++i) {
            if (this.cleanup[i].isComplete() != shouldBeComplete) continue;
            results.add(this.cleanup[i]);
        }
        return results;
    }

    public synchronized Vector<TaskInProgress> reportSetupTIPs(boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        for (int i = 0; i < this.setup.length; ++i) {
            if (this.setup[i].isComplete() != shouldBeComplete) continue;
            results.add(this.setup[i]);
        }
        return results;
    }

    public synchronized void updateTaskStatus(TaskInProgress tip, TaskStatus status) {
        boolean change;
        double oldProgress = tip.getProgress();
        boolean wasRunning = tip.isRunning();
        boolean wasComplete = tip.isComplete();
        boolean wasPending = tip.isOnlyCommitPending();
        TaskAttemptID taskid = status.getTaskID();
        if ((wasComplete || tip.wasKilled(taskid)) && status.getRunState() == TaskStatus.State.SUCCEEDED) {
            status.setRunState(TaskStatus.State.KILLED);
        }
        if ((this.isComplete() || this.jobFailed || this.jobKilled) && !tip.isCleanupAttempt(taskid)) {
            if (status.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                status.setRunState(TaskStatus.State.FAILED);
            } else if (status.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                status.setRunState(TaskStatus.State.KILLED);
            }
        }
        if (change = tip.updateStatus(status)) {
            TaskStatus.State state = status.getRunState();
            TaskTrackerStatus ttStatus = this.jobtracker.getTaskTracker(tip.machineWhereTaskRan(taskid));
            String httpTaskLogLocation = null;
            if (null != ttStatus) {
                String host = NetUtils.getStaticResolution(ttStatus.getHost()) != null ? NetUtils.getStaticResolution(ttStatus.getHost()) : ttStatus.getHost();
                httpTaskLogLocation = "http://" + host + ":" + ttStatus.getHttpPort();
            }
            TaskCompletionEvent taskEvent = null;
            if (state == TaskStatus.State.SUCCEEDED) {
                taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, taskid, tip.idWithinJob(), status.getIsMap() && !tip.isJobCleanupTask() && !tip.isJobSetupTask(), TaskCompletionEvent.Status.SUCCEEDED, httpTaskLogLocation);
                taskEvent.setTaskRunTime((int)(status.getFinishTime() - status.getStartTime()));
                tip.setSuccessEventNumber(this.taskCompletionEventTracker);
            } else {
                if (state == TaskStatus.State.COMMIT_PENDING) {
                    if (!wasComplete && !wasPending) {
                        tip.doCommit(taskid);
                    }
                    return;
                }
                if (state == TaskStatus.State.FAILED_UNCLEAN || state == TaskStatus.State.KILLED_UNCLEAN) {
                    tip.incompleteSubTask(taskid, this.status);
                    if (tip.isMapTask()) {
                        this.mapCleanupTasks.add(taskid);
                    } else {
                        this.reduceCleanupTasks.add(taskid);
                    }
                    this.jobtracker.removeTaskEntry(taskid);
                } else if (state == TaskStatus.State.FAILED || state == TaskStatus.State.KILLED) {
                    TaskCompletionEvent.Status taskCompletionStatus;
                    TaskCompletionEvent t;
                    int eventNumber = tip.getSuccessEventNumber();
                    if (eventNumber != -1 && (t = this.taskCompletionEvents.get(eventNumber)).getTaskAttemptId().equals(taskid)) {
                        t.setTaskStatus(TaskCompletionEvent.Status.OBSOLETE);
                    }
                    this.failedTask(tip, taskid, status, ttStatus, wasRunning, wasComplete);
                    TaskCompletionEvent.Status status2 = taskCompletionStatus = state == TaskStatus.State.FAILED ? TaskCompletionEvent.Status.FAILED : TaskCompletionEvent.Status.KILLED;
                    if (tip.isFailed()) {
                        taskCompletionStatus = TaskCompletionEvent.Status.TIPFAILED;
                    }
                    taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, taskid, tip.idWithinJob(), status.getIsMap() && !tip.isJobCleanupTask() && !tip.isJobSetupTask(), taskCompletionStatus, httpTaskLogLocation);
                }
            }
            if (taskEvent != null) {
                this.taskCompletionEvents.add(taskEvent);
                ++this.taskCompletionEventTracker;
                if (state == TaskStatus.State.SUCCEEDED) {
                    this.completedTask(tip, status);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Taking progress for " + tip.getTIPId() + " from " + oldProgress + " to " + tip.getProgress());
        }
        if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
            double progressDelta = tip.getProgress() - oldProgress;
            if (tip.isMapTask()) {
                this.status.setMapProgress((float)((double)this.status.mapProgress() + progressDelta / (double)this.maps.length));
            } else {
                this.status.setReduceProgress((float)((double)this.status.reduceProgress() + progressDelta / (double)this.reduces.length));
            }
        }
    }

    public synchronized Counters getJobCounters() {
        return this.jobCounters;
    }

    public synchronized Counters getMapCounters() {
        return this.incrementTaskCounters(new Counters(), this.maps);
    }

    public synchronized Counters getReduceCounters() {
        return this.incrementTaskCounters(new Counters(), this.reduces);
    }

    public synchronized Counters getCounters() {
        Counters result = new Counters();
        result.incrAllCounters(this.getJobCounters());
        this.incrementTaskCounters(result, this.maps);
        return this.incrementTaskCounters(result, this.reduces);
    }

    private Counters incrementTaskCounters(Counters counters, TaskInProgress[] tips) {
        for (TaskInProgress tip : tips) {
            counters.incrAllCounters(tip.getCounters());
        }
        return counters;
    }

    public synchronized Task obtainNewMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (this.status.getRunState() != 1) {
            LOG.info("Cannot create task split for " + this.profile.getJobID());
            return null;
        }
        int target = this.findNewMapTask(tts, clusterSize, numUniqueHosts, this.anyCacheLevel, this.status.mapProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.maps[target], result.getTaskID(), tts, true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task obtainTaskCleanupTask(TaskTrackerStatus tts, boolean isMapSlot) throws IOException {
        if (!this.tasksInited.get()) {
            return null;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            if (this.status.getRunState() != 1 || this.jobFailed || this.jobKilled) {
                return null;
            }
            String taskTracker = tts.getTrackerName();
            if (!this.shouldRunOnTaskTracker(taskTracker)) {
                return null;
            }
            TaskAttemptID taskid = null;
            TaskInProgress tip = null;
            if (isMapSlot) {
                if (!this.mapCleanupTasks.isEmpty()) {
                    taskid = this.mapCleanupTasks.remove(0);
                    tip = this.maps[taskid.getTaskID().getId()];
                }
            } else if (!this.reduceCleanupTasks.isEmpty()) {
                taskid = this.reduceCleanupTasks.remove(0);
                tip = this.reduces[taskid.getTaskID().getId()];
            }
            if (tip != null) {
                return tip.addRunningTask(taskid, taskTracker, true);
            }
            return null;
        }
    }

    public synchronized Task obtainNewLocalMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (!this.tasksInited.get()) {
            LOG.info("Cannot create task split for " + this.profile.getJobID());
            return null;
        }
        int target = this.findNewMapTask(tts, clusterSize, numUniqueHosts, this.maxLevel, this.status.mapProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.maps[target], result.getTaskID(), tts, true);
        }
        return result;
    }

    public synchronized Task obtainNewNonLocalMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (!this.tasksInited.get()) {
            LOG.info("Cannot create task split for " + this.profile.getJobID());
            return null;
        }
        int target = this.findNewMapTask(tts, clusterSize, numUniqueHosts, -1, this.status.mapProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.maps[target], result.getTaskID(), tts, true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task obtainJobCleanupTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, boolean isMapSlot) throws IOException {
        if (!this.tasksInited.get()) {
            return null;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            if (!this.canLaunchJobCleanupTask()) {
                return null;
            }
            String taskTracker = tts.getTrackerName();
            this.clusterSize = clusterSize;
            if (!this.shouldRunOnTaskTracker(taskTracker)) {
                return null;
            }
            ArrayList<TaskInProgress> cleanupTaskList = new ArrayList<TaskInProgress>();
            if (isMapSlot) {
                cleanupTaskList.add(this.cleanup[0]);
            } else {
                cleanupTaskList.add(this.cleanup[1]);
            }
            TaskInProgress tip = this.findTaskFromList(cleanupTaskList, tts, numUniqueHosts, false);
            if (tip == null) {
                return null;
            }
            Task result = tip.getTaskToRun(tts.getTrackerName());
            if (result != null) {
                this.addRunningTaskToTIP(tip, result.getTaskID(), tts, true);
            }
            return result;
        }
    }

    private synchronized boolean canLaunchJobCleanupTask() {
        boolean launchCleanupTask;
        if (this.status.getRunState() != 1 && this.status.getRunState() != 4) {
            return false;
        }
        if (this.launchedCleanup || !this.isSetupFinished()) {
            return false;
        }
        if (this.jobKilled || this.jobFailed) {
            return true;
        }
        boolean bl = launchCleanupTask = this.finishedMapTasks + this.failedMapTIPs == this.numMapTasks;
        if (launchCleanupTask) {
            launchCleanupTask = this.finishedReduceTasks + this.failedReduceTIPs == this.numReduceTasks;
        }
        return launchCleanupTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task obtainJobSetupTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, boolean isMapSlot) throws IOException {
        if (!this.tasksInited.get()) {
            return null;
        }
        JobInProgress jobInProgress = this;
        synchronized (jobInProgress) {
            if (!this.canLaunchSetupTask()) {
                return null;
            }
            String taskTracker = tts.getTrackerName();
            this.clusterSize = clusterSize;
            if (!this.shouldRunOnTaskTracker(taskTracker)) {
                return null;
            }
            ArrayList<TaskInProgress> setupTaskList = new ArrayList<TaskInProgress>();
            if (isMapSlot) {
                setupTaskList.add(this.setup[0]);
            } else {
                setupTaskList.add(this.setup[1]);
            }
            TaskInProgress tip = this.findTaskFromList(setupTaskList, tts, numUniqueHosts, false);
            if (tip == null) {
                return null;
            }
            Task result = tip.getTaskToRun(tts.getTrackerName());
            if (result != null) {
                this.addRunningTaskToTIP(tip, result.getTaskID(), tts, true);
            }
            return result;
        }
    }

    public synchronized boolean scheduleReduces() {
        return this.finishedMapTasks >= this.completedMapsForReduceSlowstart;
    }

    private synchronized boolean canLaunchSetupTask() {
        return this.tasksInited.get() && this.status.getRunState() == 4 && !this.launchedSetup && !this.jobKilled && !this.jobFailed;
    }

    public synchronized Task obtainNewReduceTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts) throws IOException {
        if (this.status.getRunState() != 1) {
            LOG.info("Cannot create task split for " + this.profile.getJobID());
            return null;
        }
        if (!this.scheduleReduces()) {
            return null;
        }
        int target = this.findNewReduceTask(tts, clusterSize, numUniqueHosts, this.status.reduceProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.reduces[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            this.addRunningTaskToTIP(this.reduces[target], result.getTaskID(), tts, true);
        }
        return result;
    }

    private int getMatchingLevelForNodes(Node n1, Node n2) {
        int count = 0;
        do {
            if (n1.equals(n2)) {
                return count;
            }
            ++count;
            n1 = n1.getParent();
            n2 = n2.getParent();
        } while (n1 != null);
        return this.maxLevel;
    }

    synchronized void addRunningTaskToTIP(TaskInProgress tip, TaskAttemptID id, TaskTrackerStatus tts, boolean isScheduled) {
        String name;
        if (!isScheduled) {
            tip.addRunningTask(id, tts.getTrackerName());
        }
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        String splits = "";
        Counter counter = null;
        if (tip.isJobSetupTask()) {
            this.launchedSetup = true;
            name = JobHistory.Values.SETUP.name();
        } else if (tip.isJobCleanupTask()) {
            this.launchedCleanup = true;
            name = JobHistory.Values.CLEANUP.name();
        } else if (tip.isMapTask()) {
            ++this.runningMapTasks;
            name = JobHistory.Values.MAP.name();
            counter = Counter.TOTAL_LAUNCHED_MAPS;
            splits = tip.getSplitNodes();
            if (tip.getActiveTasks().size() > 1) {
                ++this.speculativeMapTasks;
            }
            metrics.launchMap(id);
        } else {
            ++this.runningReduceTasks;
            name = JobHistory.Values.REDUCE.name();
            counter = Counter.TOTAL_LAUNCHED_REDUCES;
            if (tip.getActiveTasks().size() > 1) {
                ++this.speculativeReduceTasks;
            }
            metrics.launchReduce(id);
        }
        if (tip.isFirstAttempt(id)) {
            JobHistory.Task.logStarted(tip.getTIPId(), name, tip.getExecStartTime(), splits);
        }
        if (!tip.isJobSetupTask() && !tip.isJobCleanupTask()) {
            this.jobCounters.incrCounter(counter, 1L);
        }
        if (tip.isMapTask() && !tip.isJobSetupTask() && !tip.isJobCleanupTask()) {
            Node tracker = this.jobtracker.getNode(tts.getHost());
            int level = this.maxLevel;
            for (String local : this.maps[tip.getIdWithinJob()].getSplitLocations()) {
                Node datanode = this.jobtracker.getNode(local);
                int newLevel = this.maxLevel;
                if (tracker != null && datanode != null) {
                    newLevel = this.getMatchingLevelForNodes(tracker, datanode);
                }
                if (newLevel < level && (level = newLevel) == 0) break;
            }
            switch (level) {
                case 0: {
                    LOG.info("Choosing data-local task " + tip.getTIPId());
                    this.jobCounters.incrCounter(Counter.DATA_LOCAL_MAPS, 1L);
                    break;
                }
                case 1: {
                    LOG.info("Choosing rack-local task " + tip.getTIPId());
                    this.jobCounters.incrCounter(Counter.RACK_LOCAL_MAPS, 1L);
                    break;
                }
                default: {
                    if (level == this.maxLevel) break;
                    LOG.info("Choosing cached task at level " + level + tip.getTIPId());
                    this.jobCounters.incrCounter(Counter.OTHER_LOCAL_MAPS, 1L);
                }
            }
        }
    }

    static String convertTrackerNameToHostName(String trackerName) {
        int indexOfColon = trackerName.indexOf(":");
        String trackerHostName = indexOfColon == -1 ? trackerName : trackerName.substring(0, indexOfColon);
        return trackerHostName.substring("tracker_".length());
    }

    void addTrackerTaskFailure(String trackerName) {
        if ((double)this.flakyTaskTrackers < (double)this.clusterSize * 0.25) {
            String trackerHostName = JobInProgress.convertTrackerNameToHostName(trackerName);
            Integer trackerFailures = this.trackerToFailuresMap.get(trackerHostName);
            if (trackerFailures == null) {
                trackerFailures = 0;
            }
            trackerFailures = trackerFailures + 1;
            this.trackerToFailuresMap.put(trackerHostName, trackerFailures);
            if (trackerFailures.intValue() == this.conf.getMaxTaskFailuresPerTracker()) {
                ++this.flakyTaskTrackers;
                LOG.info("TaskTracker at '" + trackerHostName + "' turned 'flaky'");
            }
        }
    }

    private int getTrackerTaskFailures(String trackerName) {
        String trackerHostName = JobInProgress.convertTrackerNameToHostName(trackerName);
        Integer failedTasks = this.trackerToFailuresMap.get(trackerHostName);
        return failedTasks != null ? failedTasks : 0;
    }

    List<String> getBlackListedTrackers() {
        ArrayList<String> blackListedTrackers = new ArrayList<String>();
        for (Map.Entry<String, Integer> e : this.trackerToFailuresMap.entrySet()) {
            if (e.getValue() < this.conf.getMaxTaskFailuresPerTracker()) continue;
            blackListedTrackers.add(e.getKey());
        }
        return blackListedTrackers;
    }

    int getNoOfBlackListedTrackers() {
        return this.flakyTaskTrackers;
    }

    synchronized Map<String, Integer> getTaskTrackerErrors() {
        TreeMap<String, Integer> trackerErrors = new TreeMap<String, Integer>(this.trackerToFailuresMap);
        return trackerErrors;
    }

    private synchronized void retireMap(TaskInProgress tip) {
        if (this.runningMapCache == null) {
            LOG.warn("Running cache for maps missing!! Job details are missing.");
            return;
        }
        String[] splitLocations = tip.getSplitLocations();
        if (splitLocations.length == 0) {
            this.nonLocalRunningMaps.remove(tip);
            return;
        }
        for (String host : splitLocations) {
            Node node = this.jobtracker.getNode(host);
            for (int j = 0; j < this.maxLevel; ++j) {
                Set<TaskInProgress> hostMaps = this.runningMapCache.get(node);
                if (hostMaps != null) {
                    hostMaps.remove(tip);
                    if (hostMaps.size() == 0) {
                        this.runningMapCache.remove(node);
                    }
                }
                node = node.getParent();
            }
        }
    }

    private synchronized void retireReduce(TaskInProgress tip) {
        if (this.runningReduces == null) {
            LOG.warn("Running list for reducers missing!! Job details are missing.");
            return;
        }
        this.runningReduces.remove(tip);
    }

    private synchronized void scheduleMap(TaskInProgress tip) {
        if (this.runningMapCache == null) {
            LOG.warn("Running cache for maps is missing!! Job details are missing.");
            return;
        }
        String[] splitLocations = tip.getSplitLocations();
        if (splitLocations.length == 0) {
            this.nonLocalRunningMaps.add(tip);
            return;
        }
        for (String host : splitLocations) {
            Node node = this.jobtracker.getNode(host);
            for (int j = 0; j < this.maxLevel; ++j) {
                Set<TaskInProgress> hostMaps = this.runningMapCache.get(node);
                if (hostMaps == null) {
                    hostMaps = new LinkedHashSet<TaskInProgress>();
                    this.runningMapCache.put(node, hostMaps);
                }
                hostMaps.add(tip);
                node = node.getParent();
            }
        }
    }

    private synchronized void scheduleReduce(TaskInProgress tip) {
        if (this.runningReduces == null) {
            LOG.warn("Running cache for reducers missing!! Job details are missing.");
            return;
        }
        this.runningReduces.add(tip);
    }

    private synchronized void failMap(TaskInProgress tip) {
        if (this.nonRunningMapCache == null) {
            LOG.warn("Non-running cache for maps missing!! Job details are missing.");
            return;
        }
        String[] splitLocations = tip.getSplitLocations();
        if (splitLocations.length == 0) {
            this.nonLocalMaps.add(0, tip);
            return;
        }
        for (String host : splitLocations) {
            Node node = this.jobtracker.getNode(host);
            for (int j = 0; j < this.maxLevel; ++j) {
                List<TaskInProgress> hostMaps = this.nonRunningMapCache.get(node);
                if (hostMaps == null) {
                    hostMaps = new LinkedList<TaskInProgress>();
                    this.nonRunningMapCache.put(node, hostMaps);
                }
                hostMaps.add(0, tip);
                node = node.getParent();
            }
        }
    }

    private synchronized void failReduce(TaskInProgress tip) {
        if (this.nonRunningReduces == null) {
            LOG.warn("Failed cache for reducers missing!! Job details are missing.");
            return;
        }
        this.nonRunningReduces.add(0, tip);
    }

    private synchronized TaskInProgress findTaskFromList(Collection<TaskInProgress> tips, TaskTrackerStatus ttStatus, int numUniqueHosts, boolean removeFailedTip) {
        Iterator<TaskInProgress> iter = tips.iterator();
        while (iter.hasNext()) {
            TaskInProgress tip = iter.next();
            if (tip.isRunnable() && !tip.isRunning()) {
                if (!tip.hasFailedOnMachine(ttStatus.getHost()) || tip.getNumberOfFailedMachines() >= numUniqueHosts) {
                    iter.remove();
                    return tip;
                }
                if (!removeFailedTip) continue;
                iter.remove();
                continue;
            }
            iter.remove();
        }
        return null;
    }

    private synchronized TaskInProgress findSpeculativeTask(Collection<TaskInProgress> list, TaskTrackerStatus ttStatus, double avgProgress, long currentTime, boolean shouldRemove) {
        Iterator<TaskInProgress> iter = list.iterator();
        while (iter.hasNext()) {
            TaskInProgress tip = iter.next();
            if (!tip.isRunning()) {
                iter.remove();
                continue;
            }
            if (!tip.hasRunOnMachine(ttStatus.getHost(), ttStatus.getTrackerName())) {
                if (!tip.hasSpeculativeTask(currentTime, avgProgress)) continue;
                if (shouldRemove) {
                    iter.remove();
                }
                return tip;
            }
            if (!shouldRemove) continue;
            iter.remove();
        }
        return null;
    }

    private synchronized int findNewMapTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, int maxCacheLevel, double avgProgress) {
        if (this.numMapTasks == 0) {
            LOG.info("No maps to schedule for " + this.profile.getJobID());
            return -1;
        }
        String taskTracker = tts.getTrackerName();
        TaskInProgress tip = null;
        this.clusterSize = clusterSize;
        if (!this.shouldRunOnTaskTracker(taskTracker)) {
            return -1;
        }
        long outSize = this.resourceEstimator.getEstimatedMapOutputSize();
        long availSpace = tts.getResourceStatus().getAvailableSpace();
        if (availSpace < outSize) {
            LOG.warn("No room for map task. Node " + tts.getHost() + " has " + availSpace + " bytes free; but we expect map to take " + outSize);
            return -1;
        }
        Node node = this.jobtracker.getNode(tts.getHost());
        if (node != null) {
            Node key = node;
            int level = 0;
            int maxLevelToSchedule = Math.min(maxCacheLevel, this.maxLevel);
            for (level = 0; level < maxLevelToSchedule; ++level) {
                List<TaskInProgress> cacheForLevel = this.nonRunningMapCache.get(key);
                if (cacheForLevel != null && (tip = this.findTaskFromList(cacheForLevel, tts, numUniqueHosts, level == 0)) != null) {
                    this.scheduleMap(tip);
                    if (cacheForLevel.size() == 0) {
                        this.nonRunningMapCache.remove(key);
                    }
                    return tip.getIdWithinJob();
                }
                key = key.getParent();
            }
            if (level == maxCacheLevel) {
                return -1;
            }
        }
        Collection<Node> nodesAtMaxLevel = this.jobtracker.getNodesAtMaxLevel();
        Node nodeParentAtMaxLevel = node == null ? null : JobTracker.getParentNode(node, this.maxLevel - 1);
        for (Node parent : nodesAtMaxLevel) {
            List<TaskInProgress> cache;
            if (parent == nodeParentAtMaxLevel || (cache = this.nonRunningMapCache.get(parent)) == null || (tip = this.findTaskFromList(cache, tts, numUniqueHosts, false)) == null) continue;
            this.scheduleMap(tip);
            if (cache.size() == 0) {
                this.nonRunningMapCache.remove(parent);
            }
            LOG.info("Choosing a non-local task " + tip.getTIPId());
            return tip.getIdWithinJob();
        }
        tip = this.findTaskFromList(this.nonLocalMaps, tts, numUniqueHosts, false);
        if (tip != null) {
            this.scheduleMap(tip);
            LOG.info("Choosing a non-local task " + tip.getTIPId());
            return tip.getIdWithinJob();
        }
        if (this.hasSpeculativeMaps) {
            long currentTime = System.currentTimeMillis();
            if (node != null) {
                Node key = node;
                for (int level = 0; level < this.maxLevel; ++level) {
                    Set<TaskInProgress> cacheForLevel = this.runningMapCache.get(key);
                    if (cacheForLevel != null && (tip = this.findSpeculativeTask(cacheForLevel, tts, avgProgress, currentTime, level == 0)) != null) {
                        if (cacheForLevel.size() == 0) {
                            this.runningMapCache.remove(key);
                        }
                        return tip.getIdWithinJob();
                    }
                    key = key.getParent();
                }
            }
            for (Node parent : nodesAtMaxLevel) {
                Set<TaskInProgress> cache;
                if (parent == nodeParentAtMaxLevel || (cache = this.runningMapCache.get(parent)) == null || (tip = this.findSpeculativeTask(cache, tts, avgProgress, currentTime, false)) == null) continue;
                if (cache.size() == 0) {
                    this.runningMapCache.remove(parent);
                }
                LOG.info("Choosing a non-local task " + tip.getTIPId() + " for speculation");
                return tip.getIdWithinJob();
            }
            tip = this.findSpeculativeTask(this.nonLocalRunningMaps, tts, avgProgress, currentTime, false);
            if (tip != null) {
                LOG.info("Choosing a non-local task " + tip.getTIPId() + " for speculation");
                return tip.getIdWithinJob();
            }
        }
        return -1;
    }

    private synchronized int findNewReduceTask(TaskTrackerStatus tts, int clusterSize, int numUniqueHosts, double avgProgress) {
        if (this.numReduceTasks == 0) {
            LOG.info("No reduces to schedule for " + this.profile.getJobID());
            return -1;
        }
        String taskTracker = tts.getTrackerName();
        TaskInProgress tip = null;
        this.clusterSize = clusterSize;
        if (!this.shouldRunOnTaskTracker(taskTracker)) {
            return -1;
        }
        long outSize = this.resourceEstimator.getEstimatedReduceInputSize();
        long availSpace = tts.getResourceStatus().getAvailableSpace();
        if (availSpace < outSize) {
            LOG.warn("No room for reduce task. Node " + taskTracker + " has " + availSpace + " bytes free; but we expect reduce input to take " + outSize);
            return -1;
        }
        tip = this.findTaskFromList(this.nonRunningReduces, tts, numUniqueHosts, false);
        if (tip != null) {
            this.scheduleReduce(tip);
            return tip.getIdWithinJob();
        }
        if (this.hasSpeculativeReduces && (tip = this.findSpeculativeTask(this.runningReduces, tts, avgProgress, System.currentTimeMillis(), false)) != null) {
            this.scheduleReduce(tip);
            return tip.getIdWithinJob();
        }
        return -1;
    }

    private boolean shouldRunOnTaskTracker(String taskTracker) {
        int taskTrackerFailedTasks = this.getTrackerTaskFailures(taskTracker);
        if ((double)this.flakyTaskTrackers < (double)this.clusterSize * 0.25 && taskTrackerFailedTasks >= this.conf.getMaxTaskFailuresPerTracker()) {
            if (LOG.isDebugEnabled()) {
                String flakyTracker = JobInProgress.convertTrackerNameToHostName(taskTracker);
                LOG.debug("Ignoring the black-listed tasktracker: '" + flakyTracker + "' for assigning a new task");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean completedTask(TaskInProgress tip, TaskStatus status) {
        TaskAttemptID taskid = status.getTaskID();
        int oldNumAttempts = tip.getActiveTasks().size();
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        if (tip.isComplete()) {
            tip.alreadyCompletedTask(taskid);
            if (this.status.getRunState() != 1) {
                this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
            }
            return false;
        }
        LOG.info("Task '" + taskid + "' has completed " + tip.getTIPId() + " successfully.");
        tip.completed(taskid);
        this.resourceEstimator.updateWithCompletedTask(status, tip);
        TaskTrackerStatus ttStatus = this.jobtracker.getTaskTracker(status.getTaskTracker());
        String trackerHostname = this.jobtracker.getNode(ttStatus.getHost()).toString();
        String taskType = this.getTaskType(tip);
        if (status.getIsMap()) {
            JobHistory.MapAttempt.logStarted(status.getTaskID(), status.getStartTime(), status.getTaskTracker(), ttStatus.getHttpPort(), taskType);
            JobHistory.MapAttempt.logFinished(status.getTaskID(), status.getFinishTime(), trackerHostname, taskType, status.getStateString(), status.getCounters());
        } else {
            JobHistory.ReduceAttempt.logStarted(status.getTaskID(), status.getStartTime(), status.getTaskTracker(), ttStatus.getHttpPort(), taskType);
            JobHistory.ReduceAttempt.logFinished(status.getTaskID(), status.getShuffleFinishTime(), status.getSortFinishTime(), status.getFinishTime(), trackerHostname, taskType, status.getStateString(), status.getCounters());
        }
        JobHistory.Task.logFinished(tip.getTIPId(), taskType, tip.getExecFinishTime(), status.getCounters());
        int newNumAttempts = tip.getActiveTasks().size();
        if (tip.isJobSetupTask()) {
            this.killSetupTip(!tip.isMapTask());
            this.status.setSetupProgress(1.0f);
            if (this.status.getRunState() == 4) {
                this.status.setRunState(1);
                JobHistory.JobInfo.logStarted(this.profile.getJobID());
            }
        } else if (tip.isJobCleanupTask()) {
            if (tip.isMapTask()) {
                this.cleanup[1].kill();
            } else {
                this.cleanup[0].kill();
            }
            if (this.jobFailed) {
                this.terminateJob(3);
            }
            if (this.jobKilled) {
                this.terminateJob(5);
            } else {
                this.jobComplete();
            }
            this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
        } else if (tip.isMapTask()) {
            --this.runningMapTasks;
            if (oldNumAttempts > 1) {
                this.speculativeMapTasks -= oldNumAttempts - newNumAttempts;
            }
            ++this.finishedMapTasks;
            metrics.completeMap(taskid);
            this.retireMap(tip);
            if (this.finishedMapTasks + this.failedMapTIPs == this.numMapTasks) {
                this.status.setMapProgress(1.0f);
            }
        } else {
            --this.runningReduceTasks;
            if (oldNumAttempts > 1) {
                this.speculativeReduceTasks -= oldNumAttempts - newNumAttempts;
            }
            ++this.finishedReduceTasks;
            metrics.completeReduce(taskid);
            this.retireReduce(tip);
            if (this.finishedReduceTasks + this.failedReduceTIPs == this.numReduceTasks) {
                this.status.setReduceProgress(1.0f);
            }
        }
        return true;
    }

    private void jobComplete() {
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        if (this.status.getRunState() == 1) {
            this.status.setRunState(2);
            this.status.setCleanupProgress(1.0f);
            if (this.maps.length == 0) {
                this.status.setMapProgress(1.0f);
            }
            if (this.reduces.length == 0) {
                this.status.setReduceProgress(1.0f);
            }
            this.finishTime = System.currentTimeMillis();
            LOG.info("Job " + this.status.getJobID() + " has completed successfully.");
            JobHistory.JobInfo.logFinished(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks, this.failedMapTasks, this.failedReduceTasks, this.getCounters());
            this.garbageCollect();
            metrics.completeJob(this.conf, this.status.getJobID());
        }
    }

    private synchronized void terminateJob(int jobTerminationState) {
        if (this.status.getRunState() == 1 || this.status.getRunState() == 4) {
            if (jobTerminationState == 3) {
                this.status = new JobStatus(this.status.getJobID(), 1.0f, 1.0f, 1.0f, 3, this.status.getJobPriority());
                this.finishTime = System.currentTimeMillis();
                JobHistory.JobInfo.logFailed(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks);
            } else {
                this.status = new JobStatus(this.status.getJobID(), 1.0f, 1.0f, 1.0f, 5, this.status.getJobPriority());
                this.finishTime = System.currentTimeMillis();
                JobHistory.JobInfo.logKilled(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks);
            }
            this.garbageCollect();
            this.jobtracker.getInstrumentation().terminateJob(this.conf, this.status.getJobID());
        }
    }

    private synchronized void terminate(int jobTerminationState) {
        if (!this.tasksInited.get()) {
            this.terminateJob(jobTerminationState);
            return;
        }
        if (this.status.getRunState() == 1 || this.status.getRunState() == 4) {
            int i;
            LOG.info("Killing job '" + this.status.getJobID() + "'");
            if (jobTerminationState == 3) {
                if (this.jobFailed) {
                    return;
                }
                this.jobFailed = true;
            } else if (jobTerminationState == 5) {
                if (this.jobKilled) {
                    return;
                }
                this.jobKilled = true;
            }
            this.clearUncleanTasks();
            for (i = 0; i < this.setup.length; ++i) {
                this.setup[i].kill();
            }
            for (i = 0; i < this.maps.length; ++i) {
                this.maps[i].kill();
            }
            for (i = 0; i < this.reduces.length; ++i) {
                this.reduces[i].kill();
            }
        }
    }

    private void clearUncleanTasks() {
        TaskAttemptID taskid = null;
        TaskInProgress tip = null;
        while (!this.mapCleanupTasks.isEmpty()) {
            taskid = this.mapCleanupTasks.remove(0);
            tip = this.maps[taskid.getTaskID().getId()];
            this.updateTaskStatus(tip, tip.getTaskStatus(taskid));
        }
        while (!this.reduceCleanupTasks.isEmpty()) {
            taskid = this.reduceCleanupTasks.remove(0);
            tip = this.reduces[taskid.getTaskID().getId()];
            this.updateTaskStatus(tip, tip.getTaskStatus(taskid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        boolean killNow = false;
        JobInitKillStatus jobInitKillStatus = this.jobInitKillStatus;
        synchronized (jobInitKillStatus) {
            this.jobInitKillStatus.killed = true;
            if (!this.jobInitKillStatus.initStarted || this.jobInitKillStatus.initDone) {
                killNow = true;
            }
        }
        if (killNow) {
            this.terminate(5);
        }
    }

    synchronized void fail() {
        this.terminate(3);
    }

    private void failedTask(TaskInProgress tip, TaskAttemptID taskid, TaskStatus status, TaskTrackerStatus taskTrackerStatus, boolean wasRunning, boolean wasComplete) {
        JobTrackerInstrumentation metrics = this.jobtracker.getInstrumentation();
        boolean wasFailed = tip.isFailed();
        tip.incompleteSubTask(taskid, this.status);
        boolean isRunning = tip.isRunning();
        boolean isComplete = tip.isComplete();
        if (wasRunning && !isRunning) {
            if (tip.isJobCleanupTask()) {
                this.launchedCleanup = false;
            } else if (tip.isJobSetupTask()) {
                this.launchedSetup = false;
            } else if (tip.isMapTask()) {
                --this.runningMapTasks;
                metrics.failedMap(taskid);
                if (!isComplete) {
                    this.retireMap(tip);
                    this.failMap(tip);
                }
            } else {
                --this.runningReduceTasks;
                metrics.failedReduce(taskid);
                if (!isComplete) {
                    this.retireReduce(tip);
                    this.failReduce(tip);
                }
            }
        }
        if (wasComplete && !isComplete && tip.isMapTask()) {
            this.failMap(tip);
            --this.finishedMapTasks;
        }
        TaskStatus taskStatus = tip.getTaskStatus(taskid);
        String taskTrackerName = taskStatus.getTaskTracker();
        String taskTrackerHostName = JobInProgress.convertTrackerNameToHostName(taskTrackerName);
        int taskTrackerPort = -1;
        if (taskTrackerStatus != null) {
            taskTrackerPort = taskTrackerStatus.getHttpPort();
        }
        long startTime = taskStatus.getStartTime();
        long finishTime = taskStatus.getFinishTime();
        List<String> taskDiagnosticInfo = tip.getDiagnosticInfo(taskid);
        String diagInfo = taskDiagnosticInfo == null ? "" : StringUtils.arrayToString(taskDiagnosticInfo.toArray(new String[0]));
        String taskType = this.getTaskType(tip);
        if (taskStatus.getIsMap()) {
            JobHistory.MapAttempt.logStarted(taskid, startTime, taskTrackerName, taskTrackerPort, taskType);
            if (taskStatus.getRunState() == TaskStatus.State.FAILED) {
                JobHistory.MapAttempt.logFailed(taskid, finishTime, taskTrackerHostName, diagInfo, taskType);
            } else {
                JobHistory.MapAttempt.logKilled(taskid, finishTime, taskTrackerHostName, diagInfo, taskType);
            }
        } else {
            JobHistory.ReduceAttempt.logStarted(taskid, startTime, taskTrackerName, taskTrackerPort, taskType);
            if (taskStatus.getRunState() == TaskStatus.State.FAILED) {
                JobHistory.ReduceAttempt.logFailed(taskid, finishTime, taskTrackerHostName, diagInfo, taskType);
            } else {
                JobHistory.ReduceAttempt.logKilled(taskid, finishTime, taskTrackerHostName, diagInfo, taskType);
            }
        }
        if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
            if (tip.isMapTask()) {
                ++this.failedMapTasks;
            } else {
                ++this.failedReduceTasks;
            }
        }
        if (status.getRunState() == TaskStatus.State.FAILED) {
            this.addTrackerTaskFailure(taskTrackerName);
        }
        this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
        if (!wasFailed && tip.isFailed()) {
            boolean killJob;
            boolean bl = tip.isJobCleanupTask() || tip.isJobSetupTask() ? true : (tip.isMapTask() ? ++this.failedMapTIPs * 100 > this.mapFailuresPercent * this.numMapTasks : (killJob = ++this.failedReduceTIPs * 100 > this.reduceFailuresPercent * this.numReduceTasks));
            if (killJob) {
                LOG.info("Aborting job " + this.profile.getJobID());
                JobHistory.Task.logFailed(tip.getTIPId(), taskType, finishTime, diagInfo);
                if (tip.isJobCleanupTask()) {
                    if (tip.isMapTask()) {
                        this.cleanup[1].kill();
                    } else {
                        this.cleanup[0].kill();
                    }
                    this.terminateJob(3);
                } else {
                    if (tip.isJobSetupTask()) {
                        this.killSetupTip(!tip.isMapTask());
                    }
                    this.fail();
                }
            }
            if (!tip.isJobCleanupTask() && !tip.isJobSetupTask()) {
                if (tip.isMapTask()) {
                    this.jobCounters.incrCounter(Counter.NUM_FAILED_MAPS, 1L);
                } else {
                    this.jobCounters.incrCounter(Counter.NUM_FAILED_REDUCES, 1L);
                }
            }
        }
    }

    void killSetupTip(boolean isMap) {
        if (isMap) {
            this.setup[0].kill();
        } else {
            this.setup[1].kill();
        }
    }

    boolean isSetupFinished() {
        return this.setup[0].isComplete() || this.setup[0].isFailed() || this.setup[1].isComplete() || this.setup[1].isFailed();
    }

    public void failedTask(TaskInProgress tip, TaskAttemptID taskid, String reason, TaskStatus.Phase phase, TaskStatus.State state, String trackerName) {
        TaskStatus status = TaskStatus.createTaskStatus(tip.isMapTask(), taskid, 0.0f, state, reason, reason, trackerName, phase, new Counters());
        TaskStatus oldStatus = tip.getTaskStatus(taskid);
        long startTime = oldStatus == null ? System.currentTimeMillis() : oldStatus.getStartTime();
        status.setStartTime(startTime);
        status.setFinishTime(System.currentTimeMillis());
        boolean wasComplete = tip.isComplete();
        this.updateTaskStatus(tip, status);
        boolean isComplete = tip.isComplete();
        if (wasComplete && !isComplete) {
            String taskType = this.getTaskType(tip);
            JobHistory.Task.logFailed(tip.getTIPId(), taskType, tip.getExecFinishTime(), reason, taskid);
        }
    }

    synchronized void garbageCollect() {
        this.jobtracker.getInstrumentation().decWaiting(this.getJobID(), this.pendingMaps() + this.pendingReduces());
        this.jobtracker.storeCompletedJob(this);
        this.jobtracker.finalizeJob(this);
        try {
            if (this.localJobFile != null) {
                this.localFs.delete(this.localJobFile, true);
                this.localJobFile = null;
            }
            if (this.localJarFile != null) {
                this.localFs.delete(this.localJarFile, true);
                this.localJarFile = null;
            }
            for (int i = 0; i < this.maps.length; ++i) {
                this.maps[i].clearSplit();
            }
            Path tempDir = this.jobtracker.getSystemDirectoryForJob(this.getJobID());
            new CleanupQueue().addToQueue(this.conf, tempDir);
        }
        catch (IOException e) {
            LOG.warn("Error cleaning up " + this.profile.getJobID() + ": " + e);
        }
        this.cleanUpMetrics();
        this.nonRunningMapCache = null;
        this.runningMapCache = null;
        this.nonRunningReduces = null;
        this.runningReduces = null;
    }

    public synchronized TaskInProgress getTaskInProgress(TaskID tipid) {
        if (tipid.isMap()) {
            if (tipid.equals(this.cleanup[0].getTIPId())) {
                return this.cleanup[0];
            }
            if (tipid.equals(this.setup[0].getTIPId())) {
                return this.setup[0];
            }
            for (int i = 0; i < this.maps.length; ++i) {
                if (!tipid.equals(this.maps[i].getTIPId())) continue;
                return this.maps[i];
            }
        } else {
            if (tipid.equals(this.cleanup[1].getTIPId())) {
                return this.cleanup[1];
            }
            if (tipid.equals(this.setup[1].getTIPId())) {
                return this.setup[1];
            }
            for (int i = 0; i < this.reduces.length; ++i) {
                if (!tipid.equals(this.reduces[i].getTIPId())) continue;
                return this.reduces[i];
            }
        }
        return null;
    }

    public synchronized TaskStatus findFinishedMap(int mapId) {
        TaskInProgress tip = this.maps[mapId];
        if (tip.isComplete()) {
            TaskStatus[] statuses = tip.getTaskStatuses();
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i].getRunState() != TaskStatus.State.SUCCEEDED) continue;
                return statuses[i];
            }
        }
        return null;
    }

    synchronized int getNumTaskCompletionEvents() {
        return this.taskCompletionEvents.size();
    }

    public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int fromEventId, int maxEvents) {
        TaskCompletionEvent[] events = TaskCompletionEvent.EMPTY_ARRAY;
        if (this.taskCompletionEvents.size() > fromEventId) {
            int actualMax = Math.min(maxEvents, this.taskCompletionEvents.size() - fromEventId);
            events = this.taskCompletionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
        }
        return events;
    }

    synchronized void fetchFailureNotification(TaskInProgress tip, TaskAttemptID mapTaskId, String trackerName) {
        boolean isMapFaulty;
        Integer fetchFailures = this.mapTaskIdToFetchFailuresMap.get(mapTaskId);
        fetchFailures = fetchFailures == null ? 1 : fetchFailures + 1;
        this.mapTaskIdToFetchFailuresMap.put(mapTaskId, fetchFailures);
        LOG.info("Failed fetch notification #" + fetchFailures + " for task " + mapTaskId);
        float failureRate = (float)fetchFailures.intValue() / (float)this.runningReduceTasks;
        boolean bl = isMapFaulty = (double)failureRate >= 0.5;
        if (fetchFailures >= 3 && isMapFaulty) {
            LOG.info("Too many fetch-failures for output of task: " + mapTaskId + " ... killing it");
            this.failedTask(tip, mapTaskId, "Too many fetch-failures", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, TaskStatus.State.FAILED, trackerName);
            this.mapTaskIdToFetchFailuresMap.remove(mapTaskId);
        }
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public synchronized Object getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public synchronized void setSchedulingInfo(Object schedulingInfo) {
        this.schedulingInfo = schedulingInfo;
        this.status.setSchedulingInfo(schedulingInfo.toString());
    }

    boolean isComplete() {
        return this.status.isJobComplete();
    }

    private String getTaskType(TaskInProgress tip) {
        if (tip.isJobCleanupTask()) {
            return JobHistory.Values.CLEANUP.name();
        }
        if (tip.isJobSetupTask()) {
            return JobHistory.Values.SETUP.name();
        }
        if (tip.isMapTask()) {
            return JobHistory.Values.MAP.name();
        }
        return JobHistory.Values.REDUCE.name();
    }

    private static class JobInitKillStatus {
        boolean killed;
        boolean initStarted;
        boolean initDone;

        private JobInitKillStatus() {
        }
    }

    public static enum Counter {
        NUM_FAILED_MAPS,
        NUM_FAILED_REDUCES,
        TOTAL_LAUNCHED_MAPS,
        TOTAL_LAUNCHED_REDUCES,
        OTHER_LOCAL_MAPS,
        DATA_LOCAL_MAPS,
        RACK_LOCAL_MAPS;

    }

    static class KillInterruptedException
    extends InterruptedException {
        private static final long serialVersionUID = 1L;

        public KillInterruptedException(String msg) {
            super(msg);
        }
    }
}

