/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class FSNamesystemMetrics
implements Updater {
    private static Log log = LogFactory.getLog(FSNamesystemMetrics.class);
    final MetricsRecord metricsRecord;
    public MetricsRegistry registry = new MetricsRegistry();
    final MetricsIntValue filesTotal = new MetricsIntValue("FilesTotal", this.registry);
    final MetricsLongValue blocksTotal = new MetricsLongValue("BlocksTotal", this.registry);
    final MetricsIntValue capacityTotalGB = new MetricsIntValue("CapacityTotalGB", this.registry);
    final MetricsIntValue capacityUsedGB = new MetricsIntValue("CapacityUsedGB", this.registry);
    final MetricsIntValue capacityRemainingGB = new MetricsIntValue("CapacityRemainingGB", this.registry);
    final MetricsIntValue totalLoad = new MetricsIntValue("TotalLoad", this.registry);
    final MetricsIntValue pendingDeletionBlocks = new MetricsIntValue("PendingDeletionBlocks", this.registry);
    final MetricsIntValue corruptBlocks = new MetricsIntValue("CorruptBlocks", this.registry);
    final MetricsIntValue excessBlocks = new MetricsIntValue("ExcessBlocks", this.registry);
    final MetricsIntValue pendingReplicationBlocks = new MetricsIntValue("PendingReplicationBlocks", this.registry);
    final MetricsIntValue underReplicatedBlocks = new MetricsIntValue("UnderReplicatedBlocks", this.registry);
    final MetricsIntValue scheduledReplicationBlocks = new MetricsIntValue("ScheduledReplicationBlocks", this.registry);
    final MetricsIntValue missingBlocks = new MetricsIntValue("MissingBlocks", this.registry);
    final MetricsIntValue blockCapacity = new MetricsIntValue("BlockCapacity", this.registry);

    public FSNamesystemMetrics(Configuration conf) {
        String sessionId = conf.get("session.id");
        MetricsContext metricsContext = MetricsUtil.getContext("dfs");
        this.metricsRecord = MetricsUtil.createRecord(metricsContext, "FSNamesystem");
        this.metricsRecord.setTag("sessionId", sessionId);
        metricsContext.registerUpdater(this);
        log.info("Initializing FSNamesystemMetrics using context object:" + metricsContext.getClass().getName());
    }

    private int roundBytesToGBytes(long bytes) {
        return Math.round((float)bytes / 1.0737418E9f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext unused) {
        FSNamesystemMetrics fSNamesystemMetrics = this;
        synchronized (fSNamesystemMetrics) {
            FSNamesystem fsNameSystem = FSNamesystem.getFSNamesystem();
            this.filesTotal.set((int)fsNameSystem.getFilesTotal());
            this.blocksTotal.set((int)fsNameSystem.getBlocksTotal());
            this.capacityTotalGB.set(this.roundBytesToGBytes(fsNameSystem.getCapacityTotal()));
            this.capacityUsedGB.set(this.roundBytesToGBytes(fsNameSystem.getCapacityUsed()));
            this.capacityRemainingGB.set(this.roundBytesToGBytes(fsNameSystem.getCapacityRemaining()));
            this.totalLoad.set(fsNameSystem.getTotalLoad());
            this.corruptBlocks.set((int)fsNameSystem.getCorruptReplicaBlocks());
            this.excessBlocks.set((int)fsNameSystem.getExcessBlocks());
            this.pendingDeletionBlocks.set((int)fsNameSystem.getPendingDeletionBlocks());
            this.pendingReplicationBlocks.set((int)fsNameSystem.getPendingReplicationBlocks());
            this.underReplicatedBlocks.set((int)fsNameSystem.getUnderReplicatedBlocks());
            this.scheduledReplicationBlocks.set((int)fsNameSystem.getScheduledReplicationBlocks());
            this.missingBlocks.set((int)fsNameSystem.getMissingBlocksCount());
            this.blockCapacity.set(fsNameSystem.getBlockCapacity());
            for (MetricsBase m : this.registry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }
}

