/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.permission.FsPermission;

class FsShellPermissions {
    private static Pattern chmodNormalPattern = Pattern.compile("\\G\\s*([ugoa]*)([+=-]+)([rwxX]+)([,\\s]*)\\s*");
    private static Pattern chmodOctalPattern = Pattern.compile("^\\s*[+]?([0-7]{3})\\s*$");
    static String CHMOD_USAGE = "-chmod [-R] <MODE[,MODE]... | OCTALMODE> PATH...";
    private static String allowedChars = "[-_./@a-zA-Z0-9]";
    private static Pattern chownPattern = Pattern.compile("^\\s*(" + allowedChars + "+)?" + "([:](" + allowedChars + "*))?\\s*$");
    private static Pattern chgrpPattern = Pattern.compile("^\\s*(" + allowedChars + "+)\\s*$");
    static String CHOWN_USAGE = "-chown [-R] [OWNER][:[GROUP]] PATH...";
    static String CHGRP_USAGE = "-chgrp [-R] GROUP PATH...";

    FsShellPermissions() {
    }

    static void changePermissions(FileSystem fs, String cmd, String[] argv, int startIndex, FsShell shell) throws IOException {
        FsShell.CmdHandler handler = null;
        boolean recursive = false;
        while (startIndex < argv.length && argv[startIndex].equals("-R")) {
            recursive = true;
            ++startIndex;
        }
        if (startIndex >= argv.length) {
            throw new IOException("Not enough arguments for the command");
        }
        if (cmd.equals("-chmod")) {
            handler = new ChmodHandler(fs, argv[startIndex++]);
        } else if (cmd.equals("-chown")) {
            handler = new ChownHandler(fs, argv[startIndex++]);
        } else if (cmd.equals("-chgrp")) {
            handler = new ChgrpHandler(fs, argv[startIndex++]);
        }
        shell.runCmdHandler(handler, argv, startIndex, recursive);
    }

    private static class ChgrpHandler
    extends ChownHandler {
        ChgrpHandler(FileSystem fs, String groupStr) throws IOException {
            super("chgrp", fs);
            Matcher matcher = chgrpPattern.matcher(groupStr);
            if (!matcher.matches()) {
                throw new IOException("'" + groupStr + "' does not match " + "expected pattern for group");
            }
            this.group = matcher.group(1);
        }
    }

    private static class ChownHandler
    extends FsShell.CmdHandler {
        protected String owner = null;
        protected String group = null;

        protected ChownHandler(String cmd, FileSystem fs) {
            super(cmd, fs);
        }

        ChownHandler(FileSystem fs, String ownerStr) throws IOException {
            super("chown", fs);
            Matcher matcher = chownPattern.matcher(ownerStr);
            if (!matcher.matches()) {
                throw new IOException("'" + ownerStr + "' does not match " + "expected pattern for [owner][:group].");
            }
            this.owner = matcher.group(1);
            this.group = matcher.group(3);
            if (this.group != null && this.group.length() == 0) {
                this.group = null;
            }
            if (this.owner == null && this.group == null) {
                throw new IOException("'" + ownerStr + "' does not specify " + " owner or group.");
            }
        }

        @Override
        public void run(FileStatus file, FileSystem srcFs) throws IOException {
            String newGroup;
            String newOwner = this.owner == null || this.owner.equals(file.getOwner()) ? null : this.owner;
            String string = newGroup = this.group == null || this.group.equals(file.getGroup()) ? null : this.group;
            if (newOwner != null || newGroup != null) {
                try {
                    srcFs.setOwner(file.getPath(), newOwner, newGroup);
                }
                catch (IOException e) {
                    System.err.println(this.getName() + ": changing ownership of '" + file.getPath() + "':" + e.getMessage().split("\n")[0]);
                }
            }
        }
    }

    private static class ChmodHandler
    extends FsShell.CmdHandler {
        private short userMode;
        private short groupMode;
        private short othersMode;
        private char userType = (char)43;
        private char groupType = (char)43;
        private char othersType = (char)43;

        private void applyNormalPattern(String modeStr, Matcher matcher) throws IOException {
            boolean commaSeperated = false;
            for (int i = 0; i < 1 || matcher.end() < modeStr.length(); ++i) {
                if (!(i <= 0 || commaSeperated && matcher.find())) {
                    this.patternError(modeStr);
                }
                String str = matcher.group(2);
                char type = str.charAt(str.length() - 1);
                boolean others = false;
                boolean group = false;
                boolean user = false;
                block13: for (char c : matcher.group(1).toCharArray()) {
                    switch (c) {
                        case 'u': {
                            user = true;
                            continue block13;
                        }
                        case 'g': {
                            group = true;
                            continue block13;
                        }
                        case 'o': {
                            others = true;
                            continue block13;
                        }
                        case 'a': {
                            continue block13;
                        }
                        default: {
                            throw new RuntimeException("Unexpected");
                        }
                    }
                }
                if (!(user || group || others)) {
                    others = true;
                    group = true;
                    user = true;
                }
                short mode = 0;
                block14: for (char c : matcher.group(3).toCharArray()) {
                    switch (c) {
                        case 'r': {
                            mode = (short)(mode | 4);
                            continue block14;
                        }
                        case 'w': {
                            mode = (short)(mode | 2);
                            continue block14;
                        }
                        case 'x': {
                            mode = (short)(mode | 1);
                            continue block14;
                        }
                        case 'X': {
                            mode = (short)(mode | 8);
                            continue block14;
                        }
                        default: {
                            throw new RuntimeException("Unexpected");
                        }
                    }
                }
                if (user) {
                    this.userMode = mode;
                    this.userType = type;
                }
                if (group) {
                    this.groupMode = mode;
                    this.groupType = type;
                }
                if (others) {
                    this.othersMode = mode;
                    this.othersType = type;
                }
                commaSeperated = matcher.group(4).contains(",");
            }
        }

        private void applyOctalPattern(String modeStr, Matcher matcher) {
            this.othersType = (char)61;
            this.groupType = (char)61;
            this.userType = (char)61;
            String str = matcher.group(1);
            this.userMode = Short.valueOf(str.substring(0, 1));
            this.groupMode = Short.valueOf(str.substring(1, 2));
            this.othersMode = Short.valueOf(str.substring(2, 3));
        }

        private void patternError(String mode) throws IOException {
            throw new IOException("chmod : mode '" + mode + "' does not match the expected pattern.");
        }

        ChmodHandler(FileSystem fs, String modeStr) throws IOException {
            super("chmod", fs);
            Matcher matcher = null;
            matcher = chmodNormalPattern.matcher(modeStr);
            if (matcher.find()) {
                this.applyNormalPattern(modeStr, matcher);
            } else {
                matcher = chmodOctalPattern.matcher(modeStr);
                if (matcher.matches()) {
                    this.applyOctalPattern(modeStr, matcher);
                } else {
                    this.patternError(modeStr);
                }
            }
        }

        private int applyChmod(char type, int mode, int existing, boolean exeOk) {
            boolean capX = false;
            if ((mode & 8) != 0) {
                capX = true;
                mode &= 0xFFFFFFF7;
                mode |= 1;
            }
            switch (type) {
                case '+': {
                    mode |= existing;
                    break;
                }
                case '-': {
                    mode = ~mode & existing;
                    break;
                }
                case '=': {
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected");
                }
            }
            if (capX && !exeOk && (mode & 1) != 0 && (existing & 1) == 0) {
                mode &= 0xFFFFFFFE;
            }
            return mode;
        }

        @Override
        public void run(FileStatus file, FileSystem srcFs) throws IOException {
            boolean exeOk;
            int newperms;
            FsPermission perms = file.getPermission();
            short existing = perms.toShort();
            if (existing != (newperms = this.applyChmod(this.userType, this.userMode, existing >>> 6 & 7, exeOk = file.isDir() || (existing & 0x49) != 0) << 6 | this.applyChmod(this.groupType, this.groupMode, existing >>> 3 & 7, exeOk) << 3 | this.applyChmod(this.othersType, this.othersMode, existing & 7, exeOk))) {
                try {
                    srcFs.setPermission(file.getPath(), new FsPermission((short)newperms));
                }
                catch (IOException e) {
                    System.err.println(this.getName() + ": changing permissions of '" + file.getPath() + "':" + e.getMessage().split("\n")[0]);
                }
            }
        }
    }
}

