/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TagTable
extends JTable {
    private static final long serialVersionUID = 1L;
    LogFilterMain m_LogFilterMain;

    public TagTable(TagFilterTableModel tablemodel, LogFilterMain filterMain) {
        super(tablemodel);
        this.m_LogFilterMain = filterMain;
        this.init();
        this.setColumnWidth();
    }

    private void init() {
        this.setOpaque(false);
        this.setAutoscrolls(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        int iIndex = 0;
        while (iIndex < this.getColumnCount()) {
            this.getColumnModel().getColumn(iIndex).setCellRenderer(new TagCellRenderer());
            ++iIndex;
        }
        this.getTableHeader().addMouseListener(new ColumnHeaderListener());
    }

    public void showColumn(int nColumn, boolean bShow) {
        if (bShow) {
            this.getColumnModel().getColumn(nColumn).setResizable(true);
            this.getColumnModel().getColumn(nColumn).setMaxWidth(TagFilterTableModel.ColWidth[nColumn] * 1000);
            this.getColumnModel().getColumn(nColumn).setMinWidth(1);
            this.getColumnModel().getColumn(nColumn).setWidth(TagFilterTableModel.ColWidth[nColumn]);
            this.getColumnModel().getColumn(nColumn).setPreferredWidth(TagFilterTableModel.ColWidth[nColumn]);
        } else {
            this.hideColumn(nColumn);
        }
    }

    public void hideColumn(int nColumn) {
        this.getColumnModel().getColumn(nColumn).setWidth(0);
        this.getColumnModel().getColumn(nColumn).setMinWidth(0);
        this.getColumnModel().getColumn(nColumn).setMaxWidth(0);
        this.getColumnModel().getColumn(nColumn).setPreferredWidth(0);
        this.getColumnModel().getColumn(nColumn).setResizable(false);
    }

    private void setColumnWidth() {
        int iIndex = 0;
        while (iIndex < this.getColumnCount()) {
            this.showColumn(iIndex, true);
            ++iIndex;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 7;
    }

    boolean isInnerRect(Rectangle parent, Rectangle child) {
        return parent.y <= child.y && parent.y + parent.height >= child.y + child.height;
    }

    int getVisibleRowCount() {
        return this.getVisibleRect().height / this.getRowHeight();
    }

    public void packColumn(int vColIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.getTableHeader().getDefaultRenderer();
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    public class ColumnHeaderListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent evt) {
            if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
                JTable table = ((JTableHeader)evt.getSource()).getTable();
                TableColumnModel colModel = table.getColumnModel();
                int vColIndex = colModel.getColumnIndexAtX(evt.getX());
                if (vColIndex == -1) {
                    T.d("vColIndex == -1");
                    return;
                }
                TagTable.this.packColumn(vColIndex, 1);
            }
        }
    }

    public class TagCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        boolean m_bChanged;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                return c;
            }
            return new JCheckBox();
        }
    }
}

