/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class RecentFileMenu
extends JMenu {
    private String pathToSavedFile;
    private int itemCount;
    private String[] recentEntries;
    private static final String defaultText = "__R_e_C_e_N_t__:_?";

    public RecentFileMenu(String name, int count) {
        this.setText("Recent");
        this.setMnemonic('R');
        this.itemCount = count;
        this.recentEntries = new String[count];
        int index = 0;
        while (index < this.itemCount) {
            this.recentEntries[index] = defaultText;
            ++index;
        }
        this.pathToSavedFile = System.getProperty("user.dir");
        this.pathToSavedFile = this.pathToSavedFile == null || this.pathToSavedFile.length() <= 0 ? new String(String.valueOf(name) + ".ini") : (this.pathToSavedFile.endsWith(File.separator) ? String.valueOf(this.pathToSavedFile) + name + ".ini" : String.valueOf(this.pathToSavedFile) + File.separator + name + ".ini");
        File recentFile = new File(this.pathToSavedFile);
        if (recentFile.exists()) {
            try {
                LineNumberReader reader = new LineNumberReader(new FileReader(this.pathToSavedFile));
                while (reader.ready()) {
                    this.addEntry(reader.readLine(), false);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } else {
            this.setEnabled(false);
        }
    }

    public void addEntry(String filePath) {
        this.addEntry(filePath, true);
    }

    private void addEntry(String filePath, boolean updateFile) {
        int count;
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
        this.removeAll();
        int index = count = this.itemCount - 1;
        while (index > 0) {
            if (!this.recentEntries[index - 1].equalsIgnoreCase(filePath)) {
                this.recentEntries[index] = new String(this.recentEntries[index - 1]);
            }
            --index;
        }
        if (!this.recentEntries[0].equalsIgnoreCase(filePath)) {
            this.recentEntries[0] = new String(filePath);
        }
        index = 0;
        while (index < this.itemCount) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(this.recentEntries[index]);
            if (this.recentEntries[index].equals(defaultText)) {
                menuItem.setVisible(false);
            } else {
                menuItem.setVisible(true);
                menuItem.setToolTipText(this.recentEntries[index]);
                menuItem.setActionCommand(this.recentEntries[index]);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RecentFileMenu.this.onSelectFile(actionEvent.getActionCommand());
                    }
                });
            }
            this.add(menuItem);
            ++index;
        }
        if (updateFile) {
            try {
                int topIndex;
                FileWriter writer = new FileWriter(new File(this.pathToSavedFile));
                int index2 = topIndex = this.itemCount - 1;
                while (index2 >= 0) {
                    if (!this.recentEntries[index2].equals(defaultText)) {
                        writer.write(this.recentEntries[index2]);
                        writer.write("\n");
                    }
                    --index2;
                }
                writer.flush();
                writer.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public abstract void onSelectFile(String var1);
}

