/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LogTable
extends JTable
implements FocusListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    LogFilterMain m_LogFilterMain;
    ILogParser m_iLogParser;
    String m_strHighlight;
    String m_strPidShow;
    String m_strTidShow;
    String m_strTagShow;
    String m_strTagRemove;
    String m_strFilterRemove;
    String m_strFilterFind;
    float m_fFontSize;
    boolean m_bAltPressed;
    int m_nTagLength;
    boolean[] m_arbShow;

    public LogTable(LogFilterTableModel tablemodel, LogFilterMain filterMain) {
        super(tablemodel);
        this.m_LogFilterMain = filterMain;
        this.m_strHighlight = "";
        this.m_strPidShow = "";
        this.m_strTidShow = "";
        this.m_strTagShow = "";
        this.m_strTagRemove = "";
        this.m_strFilterRemove = "";
        this.m_strFilterFind = "";
        this.m_nTagLength = 0;
        this.m_arbShow = new boolean[9];
        this.init();
        this.setColumnWidth();
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        if (rowIndex > this.getRowCount() - 1) {
            rowIndex = this.getRowCount() - 1;
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        this.showRow(rowIndex);
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend, boolean bMove) {
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        if (rowIndex > this.getRowCount() - 1) {
            rowIndex = this.getRowCount() - 1;
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (bMove) {
            this.showRow(rowIndex);
        }
    }

    private void init() {
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        this.registerKeyboardAction(this, "Copy", copy, 0);
        this.addFocusListener(this);
        this.setAutoResizeMode(0);
        this.m_fFontSize = 12.0f;
        this.setOpaque(false);
        this.setAutoscrolls(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        int iIndex = 0;
        while (iIndex < this.getColumnCount()) {
            this.getColumnModel().getColumn(iIndex).setCellRenderer(new LogCellRenderer());
            ++iIndex;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                int row = LogTable.this.rowAtPoint(p);
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int colum;
                    if (e.getClickCount() == 2) {
                        LogInfo logInfo = ((LogFilterTableModel)LogTable.this.getModel()).getRow(row);
                        logInfo.m_bMarked = !logInfo.m_bMarked;
                        LogTable.this.m_LogFilterMain.bookmarkItem(row, Integer.parseInt(logInfo.m_strLine) - 1, logInfo.m_bMarked);
                    } else if (LogTable.this.m_bAltPressed && (colum = LogTable.this.columnAtPoint(p)) == 6) {
                        LogInfo logInfo = ((LogFilterTableModel)LogTable.this.getModel()).getRow(row);
                        LogTable.this.m_strTagShow = LogTable.this.m_strTagShow.contains("|" + (String)logInfo.getData(colum)) ? LogTable.this.m_strTagShow.replace("|" + (String)logInfo.getData(colum), "") : (LogTable.this.m_strTagShow.contains((String)logInfo.getData(colum)) ? LogTable.this.m_strTagShow.replace((String)logInfo.getData(colum), "") : String.valueOf(LogTable.this.m_strTagShow) + "|" + (String)logInfo.getData(colum));
                        LogTable.this.m_LogFilterMain.notiEvent(new INotiEvent.EventParam(2));
                    }
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    int colum = LogTable.this.columnAtPoint(p);
                    T.d("m_bAltPressed = " + LogTable.this.m_bAltPressed);
                    if (LogTable.this.m_bAltPressed) {
                        if (colum == 6) {
                            T.d();
                            LogInfo logInfo = ((LogFilterTableModel)LogTable.this.getModel()).getRow(row);
                            LogTable.this.m_strTagRemove = String.valueOf(LogTable.this.m_strTagRemove) + "|" + (String)logInfo.getData(colum);
                            LogTable.this.m_LogFilterMain.notiEvent(new INotiEvent.EventParam(3));
                        }
                    } else {
                        T.d();
                        LogInfo logInfo = ((LogFilterTableModel)LogTable.this.getModel()).getRow(row);
                        StringSelection data = new StringSelection((String)logInfo.getData(colum));
                        LogTable.this.getToolkit();
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clipboard.setContents(data, data);
                    }
                }
            }
        });
        this.getTableHeader().addMouseListener(new ColumnHeaderListener());
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 7;
    }

    boolean isInnerRect(Rectangle parent, Rectangle child) {
        return parent.y <= child.y && parent.y + parent.height >= child.y + child.height;
    }

    String GetFilterFind() {
        return this.m_strFilterFind;
    }

    String GetFilterRemove() {
        return this.m_strFilterRemove;
    }

    String GetFilterShowPid() {
        return this.m_strPidShow;
    }

    String GetFilterShowTid() {
        return this.m_strTidShow;
    }

    String GetFilterShowTag() {
        return this.m_strTagShow;
    }

    String GetHighlight() {
        return this.m_strHighlight;
    }

    String GetFilterRemoveTag() {
        return this.m_strTagRemove;
    }

    void gotoNextBookmark() {
        LogInfo logInfo;
        int nSeletectRow = this.getSelectedRow();
        Rectangle parent = this.getVisibleRect();
        int nIndex = nSeletectRow + 1;
        while (nIndex < this.getRowCount()) {
            logInfo = ((LogFilterTableModel)this.getModel()).getRow(nIndex);
            if (logInfo.m_bMarked) {
                this.changeSelection(nIndex, 0, false, false);
                int nVisible = nIndex;
                if (!this.isInnerRect(parent, this.getCellRect(nIndex, 0, true))) {
                    nVisible = nIndex + this.getVisibleRowCount() / 2;
                }
                this.showRow(nVisible);
                return;
            }
            ++nIndex;
        }
        nIndex = 0;
        while (nIndex < nSeletectRow) {
            logInfo = ((LogFilterTableModel)this.getModel()).getRow(nIndex);
            if (logInfo.m_bMarked) {
                this.changeSelection(nIndex, 0, false, false);
                int nVisible = nIndex;
                if (!this.isInnerRect(parent, this.getCellRect(nIndex, 0, true))) {
                    nVisible = nIndex - this.getVisibleRowCount() / 2;
                }
                this.showRow(nVisible);
                return;
            }
            ++nIndex;
        }
    }

    int getVisibleRowCount() {
        return this.getVisibleRect().height / this.getRowHeight();
    }

    void gotoPreBookmark() {
        LogInfo logInfo;
        int nSeletectRow = this.getSelectedRow();
        Rectangle parent = this.getVisibleRect();
        int nIndex = nSeletectRow - 1;
        while (nIndex >= 0) {
            logInfo = ((LogFilterTableModel)this.getModel()).getRow(nIndex);
            if (logInfo.m_bMarked) {
                this.changeSelection(nIndex, 0, false, false);
                int nVisible = nIndex;
                if (!this.isInnerRect(parent, this.getCellRect(nIndex, 0, true))) {
                    nVisible = nIndex - this.getVisibleRowCount() / 2;
                }
                this.showRow(nVisible);
                return;
            }
            --nIndex;
        }
        nIndex = this.getRowCount() - 1;
        while (nIndex > nSeletectRow) {
            logInfo = ((LogFilterTableModel)this.getModel()).getRow(nIndex);
            if (logInfo.m_bMarked) {
                this.changeSelection(nIndex, 0, false, false);
                int nVisible = nIndex;
                if (!this.isInnerRect(parent, this.getCellRect(nIndex, 0, true))) {
                    nVisible = nIndex + this.getVisibleRowCount() / 2;
                }
                this.showRow(nVisible);
                return;
            }
            --nIndex;
        }
    }

    public void hideColumn(int nColumn) {
        this.getColumnModel().getColumn(nColumn).setWidth(0);
        this.getColumnModel().getColumn(nColumn).setMinWidth(0);
        this.getColumnModel().getColumn(nColumn).setMaxWidth(0);
        this.getColumnModel().getColumn(nColumn).setPreferredWidth(0);
        this.getColumnModel().getColumn(nColumn).setResizable(false);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        this.m_bAltPressed = e.isAltDown();
        switch (e.getKeyCode()) {
            case 35: {
                this.changeSelection(this.getRowCount() - 1, 0, false, false);
                return true;
            }
            case 36: {
                this.changeSelection(0, 0, false, false);
                return true;
            }
            case 113: {
                if (e.isControlDown() && e.getID() == 401) {
                    int[] arSelectedRow;
                    int[] nArray = arSelectedRow = this.getSelectedRows();
                    int n = arSelectedRow.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int nIndex = nArray[n2];
                        LogInfo logInfo = ((LogFilterTableModel)this.getModel()).getRow(nIndex);
                        logInfo.m_bMarked = !logInfo.m_bMarked;
                        this.m_LogFilterMain.bookmarkItem(nIndex, Integer.parseInt(logInfo.m_strLine) - 1, logInfo.m_bMarked);
                        ++n2;
                    }
                    this.repaint();
                } else if (!e.isControlDown() && e.getID() == 401) {
                    this.gotoPreBookmark();
                }
                return true;
            }
            case 114: {
                if (e.getID() == 401) {
                    this.gotoNextBookmark();
                }
                return true;
            }
            case 70: {
                if (e.getID() != 401 || (e.getModifiers() & 2) != 2) break;
                this.m_LogFilterMain.setFindFocus();
                return true;
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void packColumn(int vColIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.getTableHeader().getDefaultRenderer();
        }
        JViewport viewport = this.m_LogFilterMain.m_scrollVBar.getViewport();
        Rectangle viewRect = viewport.getViewRect();
        int nFirst = this.m_LogFilterMain.m_tbLogTable.rowAtPoint(new Point(0, viewRect.y));
        int nLast = this.m_LogFilterMain.m_tbLogTable.rowAtPoint(new Point(0, viewRect.height - 1));
        if (nLast < 0) {
            nLast = this.m_LogFilterMain.m_tbLogTable.getRowCount();
        }
        int r = nFirst;
        while (r < nFirst + nLast) {
            renderer = this.getCellRenderer(r, vColIndex);
            Component comp = renderer.getTableCellRendererComponent(this, this.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
            ++r;
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    public float getFontSize() {
        return this.m_fFontSize;
    }

    public int getColumnWidth(int nColumn) {
        return this.getColumnModel().getColumn(nColumn).getWidth();
    }

    public void showColumn(int nColumn, boolean bShow) {
        this.m_arbShow[nColumn] = bShow;
        if (bShow) {
            this.getColumnModel().getColumn(nColumn).setResizable(true);
            this.getColumnModel().getColumn(nColumn).setMaxWidth(LogFilterTableModel.ColWidth[nColumn] * 1000);
            this.getColumnModel().getColumn(nColumn).setMinWidth(1);
            this.getColumnModel().getColumn(nColumn).setWidth(LogFilterTableModel.ColWidth[nColumn]);
            this.getColumnModel().getColumn(nColumn).setPreferredWidth(LogFilterTableModel.ColWidth[nColumn]);
        } else {
            this.hideColumn(nColumn);
        }
    }

    public void setColumnWidth() {
        int iIndex = 0;
        while (iIndex < this.getColumnCount()) {
            this.showColumn(iIndex, true);
            ++iIndex;
        }
        this.showColumn(7, false);
    }

    void setFilterFind(String strFind) {
        this.m_strFilterFind = strFind;
    }

    void SetFilterRemove(String strRemove) {
        this.m_strFilterRemove = strRemove;
    }

    void SetFilterShowTag(String strShowTag) {
        this.m_strTagShow = strShowTag;
    }

    void SetFilterShowPid(String strShowPid) {
        this.m_strPidShow = strShowPid;
    }

    void SetFilterShowTid(String strShowTid) {
        this.m_strTidShow = strShowTid;
    }

    void SetHighlight(String strHighlight) {
        this.m_strHighlight = strHighlight;
    }

    void SetFilterRemoveTag(String strRemoveTag) {
        this.m_strTagRemove = strRemoveTag;
    }

    public void setFontSize(int nFontSize) {
        this.m_fFontSize = nFontSize;
        this.setRowHeight(nFontSize + 4);
    }

    public void setLogParser(ILogParser iLogParser) {
        this.m_iLogParser = iLogParser;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        LogInfo logInfo = ((LogFilterTableModel)this.getModel()).getRow(row);
        if (column == 7) {
            logInfo.m_strBookmark = (String)aValue;
            this.m_LogFilterMain.setBookmark(Integer.parseInt(logInfo.m_strLine) - 1, (String)aValue);
        }
    }

    public void showRow(int row) {
        if (row < 0) {
            row = 0;
        }
        if (row > this.getRowCount() - 1) {
            row = this.getRowCount() - 1;
        }
        Rectangle rList = this.getVisibleRect();
        Rectangle rCell = this.getCellRect(row, 0, true);
        if (rList != null && rCell != null) {
            Rectangle scrollToRect = new Rectangle((int)rList.getX(), (int)rCell.getY(), (int)rList.getWidth(), (int)rCell.getHeight());
            this.scrollRectToVisible(scrollToRect);
        }
    }

    public void showRow(int row, boolean bCenter) {
        int nLastSelectedIndex = this.getSelectedRow();
        this.changeSelection(row, 0, false, false);
        int nVisible = row;
        nVisible = nLastSelectedIndex <= row || nLastSelectedIndex == -1 ? row + this.getVisibleRowCount() / 2 : row - this.getVisibleRowCount() / 2;
        if (nVisible < 0) {
            nVisible = 0;
        } else if (nVisible > this.getRowCount() - 1) {
            nVisible = this.getRowCount() - 1;
        }
        this.showRow(nVisible);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.m_bAltPressed = false;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringBuffer sbf = new StringBuffer();
        int numrows = this.getSelectedRowCount();
        int[] rowsselected = this.getSelectedRows();
        int i = 0;
        while (i < numrows) {
            int j = 0;
            while (j < this.m_arbShow.length) {
                if (j != 0 && this.m_arbShow[j]) {
                    int k;
                    String strTag;
                    StringBuffer strTemp = new StringBuffer((String)this.getValueAt(rowsselected[i], j));
                    if (j == 6) {
                        strTag = strTemp.toString();
                        k = 0;
                        while (k < this.m_nTagLength - strTag.length()) {
                            strTemp.append(" ");
                            ++k;
                        }
                    } else if (j == 5 || j == 4) {
                        strTag = strTemp.toString();
                        k = 0;
                        while (k < 8 - strTag.length()) {
                            strTemp.append(" ");
                            ++k;
                        }
                    }
                    strTemp.append(" ");
                    sbf.append(strTemp);
                }
                ++j;
            }
            sbf.append("\n");
            ++i;
        }
        StringSelection stsel = new StringSelection(sbf.toString());
        system = Toolkit.getDefaultToolkit().getSystemClipboard();
        system.setContents(stsel, stsel);
    }

    public void setTagLength(int nLength) {
        if (this.m_nTagLength < nLength) {
            this.m_nTagLength = nLength;
            T.d("m_nTagLength = " + this.m_nTagLength);
        }
    }

    public class ColumnHeaderListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent evt) {
            if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
                JTable table = ((JTableHeader)evt.getSource()).getTable();
                TableColumnModel colModel = table.getColumnModel();
                int vColIndex = colModel.getColumnIndexAtX(evt.getX());
                if (vColIndex == -1) {
                    T.d("vColIndex == -1");
                    return;
                }
                LogTable.this.packColumn(vColIndex, 1);
            }
        }
    }

    public class LogCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        boolean m_bChanged;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                value = this.remakeData(column, (String)value);
            }
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            LogInfo logInfo = ((LogFilterTableModel)LogTable.this.getModel()).getRow(row);
            c.setFont(this.getFont().deriveFont(LogTable.this.m_fFontSize));
            c.setForeground(logInfo.m_TextColor);
            if (isSelected) {
                if (logInfo.m_bMarked) {
                    c.setBackground(new Color(LogColor.COLOR_BOOKMARK2));
                }
            } else if (logInfo.m_bMarked) {
                c.setBackground(new Color(LogColor.COLOR_BOOKMARK));
            } else {
                c.setBackground(Color.WHITE);
            }
            return c;
        }

        String remakeData(int nIndex, String strText) {
            if (nIndex != 8 && nIndex != 6) {
                return strText;
            }
            String strFind = nIndex == 8 ? LogTable.this.GetFilterFind() : LogTable.this.GetFilterShowTag();
            this.m_bChanged = false;
            strText = strText.replace(" ", "\u00a0");
            strText = LogColor.COLOR_HIGHLIGHT != null && LogColor.COLOR_HIGHLIGHT.length > 0 ? this.remakeFind(strText, LogTable.this.GetHighlight(), LogColor.COLOR_HIGHLIGHT, true) : this.remakeFind(strText, LogTable.this.GetHighlight(), "#00FF00", true);
            strText = this.remakeFind(strText, strFind, "#FF0000", false);
            if (this.m_bChanged) {
                strText = "<html><nobr>" + strText + "</nobr></html>";
            }
            return strText.replace("\t", "    ");
        }

        String remakeFind(String strText, String strFind, String[] arColor, boolean bUseSpan) {
            if (strFind == null || strFind.length() <= 0) {
                return strText;
            }
            strFind = strFind.replace(" ", "\u00a0");
            StringTokenizer stk = new StringTokenizer(strFind, "|");
            int nIndex = 0;
            while (stk.hasMoreElements()) {
                if (nIndex >= arColor.length) {
                    nIndex = 0;
                }
                String strToken = stk.nextToken();
                if (!strText.toLowerCase().contains(strToken.toLowerCase())) continue;
                String newText = bUseSpan ? "<span style=\"background-color:#" + arColor[nIndex] + "\"><b>" : "<font color=#" + arColor[nIndex] + "><b>";
                newText = String.valueOf(newText) + strToken;
                newText = bUseSpan ? String.valueOf(newText) + "</b></span>" : String.valueOf(newText) + "</b></font>";
                strText = strText.replace(strToken, newText);
                this.m_bChanged = true;
                ++nIndex;
            }
            return strText;
        }

        String remakeFind(String strText, String strFind, String strColor, boolean bUseSpan) {
            if (strFind == null || strFind.length() <= 0) {
                return strText;
            }
            strFind = strFind.replace(" ", "\u00a0");
            StringTokenizer stk = new StringTokenizer(strFind, "|");
            while (stk.hasMoreElements()) {
                String strToken = stk.nextToken();
                if (!strText.toLowerCase().contains(strToken.toLowerCase())) continue;
                String newText = bUseSpan ? "<span style=\"background-color:" + strColor + "\"><b>" : "<font color=" + strColor + "><b>";
                newText = String.valueOf(newText) + strToken;
                newText = bUseSpan ? String.valueOf(newText) + "</b></span>" : String.valueOf(newText) + "</b></font>";
                strText = strText.replace(strToken, newText);
                this.m_bChanged = true;
            }
            return strText;
        }
    }
}

