/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LogFilterMain
extends JFrame
implements INotiEvent {
    private static final long serialVersionUID = 1L;
    static final String LOGFILTER = "LogFilter";
    static final String VERSION = "Version 1.8";
    final String COMBO_ANDROID = "Android          ";
    final String COMBO_IOS = "ios";
    final String COMBO_CUSTOM_COMMAND = "custom command";
    final String IOS_DEFAULT_CMD = "adb logcat -v time ";
    final String IOS_SELECTED_CMD_FIRST = "adb -s ";
    final String IOS_SELECTED_CMD_LAST = " logcat -v time ";
    final String ANDROID_DEFAULT_CMD_FIRST = "adb ";
    final String ANDROID_SELECTED_CMD_FIRST = "adb -s ";
    final String[] DEVICES_CMD = new String[]{"adb devices", "", ""};
    static final int DEFAULT_WIDTH = 1200;
    static final int DEFAULT_HEIGHT = 720;
    static final int MIN_WIDTH = 1100;
    static final int MIN_HEIGHT = 500;
    static final int DEVICES_ANDROID = 0;
    static final int DEVICES_IOS = 1;
    static final int DEVICES_CUSTOM = 2;
    static final int STATUS_CHANGE = 1;
    static final int STATUS_PARSING = 2;
    static final int STATUS_READY = 4;
    final int L = 2;
    final int C = 0;
    final int R = 4;
    JTabbedPane m_tpTab;
    JTextField m_tfStatus;
    IndicatorPanel m_ipIndicator;
    ArrayList<TagInfo> m_arTagInfo;
    ArrayList<LogInfo> m_arLogInfoAll;
    ArrayList<LogInfo> m_arLogInfoFiltered;
    HashMap<Integer, Integer> m_hmBookmarkAll;
    HashMap<Integer, Integer> m_hmBookmarkFiltered;
    HashMap<Integer, Integer> m_hmErrorAll;
    HashMap<Integer, Integer> m_hmErrorFiltered;
    ILogParser m_iLogParser;
    LogTable m_tbLogTable;
    JScrollPane m_scrollVBar;
    LogFilterTableModel m_tmLogTableModel;
    boolean m_bUserFilter;
    JTextField m_tfHighlight;
    JTextField m_tfFindWord;
    JTextField m_tfRemoveWord;
    JTextField m_tfShowTag;
    JTextField m_tfRemoveTag;
    JTextField m_tfShowPid;
    JTextField m_tfShowTid;
    JButton m_btnDevice;
    JList m_lDeviceList;
    JComboBox m_comboDeviceCmd;
    JComboBox m_comboCmd;
    JButton m_btnSetFont;
    JCheckBox m_chkEnableFind;
    JCheckBox m_chkEnableRemove;
    JCheckBox m_chkEnableShowTag;
    JCheckBox m_chkEnableRemoveTag;
    JCheckBox m_chkEnableShowPid;
    JCheckBox m_chkEnableShowTid;
    JCheckBox m_chkEnableHighlight;
    JCheckBox m_chkVerbose;
    JCheckBox m_chkDebug;
    JCheckBox m_chkInfo;
    JCheckBox m_chkWarn;
    JCheckBox m_chkError;
    JCheckBox m_chkFatal;
    JCheckBox m_chkClmBookmark;
    JCheckBox m_chkClmLine;
    JCheckBox m_chkClmDate;
    JCheckBox m_chkClmTime;
    JCheckBox m_chkClmLogLV;
    JCheckBox m_chkClmPid;
    JCheckBox m_chkClmThread;
    JCheckBox m_chkClmTag;
    JCheckBox m_chkClmMessage;
    JTextField m_tfFontSize;
    JComboBox m_comboEncode;
    JComboBox m_jcFontType;
    JButton m_btnRun;
    JButton m_btnClear;
    JToggleButton m_tbtnPause;
    JButton m_btnStop;
    String m_strLogFileName;
    String m_strSelectedDevice;
    Process m_Process;
    Thread m_thProcess;
    Thread m_thWatchFile;
    Thread m_thFilterParse;
    boolean m_bPauseADB;
    Object FILE_LOCK;
    Object FILTER_LOCK;
    volatile int m_nChangedFilter;
    int m_nFilterLogLV;
    int m_nWinWidth = 1200;
    int m_nWinHeight = 720;
    int m_nLastWidth;
    int m_nLastHeight;
    int m_nWindState;
    static RecentFileMenu m_recentMenu;
    final String INI_FILE = "LogFilter.ini";
    final String INI_FILE_CMD = "LogFilterCmd.ini";
    final String INI_FILE_COLOR = "LogFilterColor.ini";
    final String INI_LAST_DIR = "LAST_DIR";
    final String INI_CMD_COUNT = "CMD_COUNT";
    final String INI_CMD = "CMD_";
    final String INI_FONT_TYPE = "FONT_TYPE";
    final String INI_WORD_FIND = "WORD_FIND";
    final String INI_WORD_REMOVE = "WORD_REMOVE";
    final String INI_TAG_SHOW = "TAG_SHOW";
    final String INI_TAG_REMOVE = "TAG_REMOVE";
    final String INI_HIGHLIGHT = "HIGHLIGHT";
    final String INI_PID_SHOW = "PID_SHOW";
    final String INI_TID_SHOW = "TID_SHOW";
    final String INI_COLOR_0 = "INI_COLOR_0";
    final String INI_COLOR_1 = "INI_COLOR_1";
    final String INI_COLOR_2 = "INI_COLOR_2";
    final String INI_COLOR_3 = "INI_COLOR_3(E)";
    final String INI_COLOR_4 = "INI_COLOR_4(W)";
    final String INI_COLOR_5 = "INI_COLOR_5";
    final String INI_COLOR_6 = "INI_COLOR_6(I)";
    final String INI_COLOR_7 = "INI_COLOR_7(D)";
    final String INI_COLOR_8 = "INI_COLOR_8(F)";
    final String INI_HIGILIGHT_COUNT = "INI_HIGILIGHT_COUNT";
    final String INI_HIGILIGHT_ = "INI_HIGILIGHT_";
    final String INI_WIDTH = "INI_WIDTH";
    final String INI_HEIGHT = "INI_HEIGHT";
    final String INI_WINDOW_STATE = "INI_WINDOW_STATE";
    final String INI_COMUMN = "INI_COMUMN_";
    ActionListener m_alButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(LogFilterMain.this.m_btnDevice)) {
                LogFilterMain.this.setDeviceList();
            } else if (e.getSource().equals(LogFilterMain.this.m_btnSetFont)) {
                LogFilterMain.this.m_tbLogTable.setFontSize(Integer.parseInt(LogFilterMain.this.m_tfFontSize.getText()));
                LogFilterMain.this.updateTable(-1, false);
            } else if (e.getSource().equals(LogFilterMain.this.m_btnRun)) {
                LogFilterMain.this.startProcess();
            } else if (e.getSource().equals(LogFilterMain.this.m_btnStop)) {
                LogFilterMain.this.stopProcess();
            } else if (e.getSource().equals(LogFilterMain.this.m_btnClear)) {
                boolean bBackup = LogFilterMain.this.m_bPauseADB;
                LogFilterMain.this.m_bPauseADB = true;
                LogFilterMain.this.clearData();
                LogFilterMain.this.updateTable(-1, false);
                LogFilterMain.this.m_bPauseADB = bBackup;
            } else if (e.getSource().equals(LogFilterMain.this.m_tbtnPause)) {
                LogFilterMain.this.pauseProcess();
            } else if (e.getSource().equals(LogFilterMain.this.m_jcFontType)) {
                T.d("font = " + LogFilterMain.this.m_tbLogTable.getFont());
                LogFilterMain.this.m_tbLogTable.setFont(new Font((String)LogFilterMain.this.m_jcFontType.getSelectedItem(), 0, 12));
                LogFilterMain.this.m_tbLogTable.setFontSize(Integer.parseInt(LogFilterMain.this.m_tfFontSize.getText()));
            }
        }
    };
    DocumentListener m_dlFilterListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            try {
                if (arg0.getDocument().equals(LogFilterMain.this.m_tfFindWord.getDocument()) && LogFilterMain.this.m_chkEnableFind.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.setFilterFind(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfRemoveWord.getDocument()) && LogFilterMain.this.m_chkEnableRemove.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterRemove(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfShowPid.getDocument()) && LogFilterMain.this.m_chkEnableShowPid.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterShowPid(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfShowTid.getDocument()) && LogFilterMain.this.m_chkEnableShowTid.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterShowTid(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfShowTag.getDocument()) && LogFilterMain.this.m_chkEnableShowTag.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterShowTag(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfRemoveTag.getDocument()) && LogFilterMain.this.m_chkEnableRemoveTag.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterRemoveTag(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfHighlight.getDocument()) && LogFilterMain.this.m_chkEnableHighlight.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetHighlight(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                }
                LogFilterMain.this.m_nChangedFilter = 1;
                LogFilterMain.this.runFilter();
            }
            catch (Exception e) {
                T.e(e);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            try {
                if (arg0.getDocument().equals(LogFilterMain.this.m_tfFindWord.getDocument()) && LogFilterMain.this.m_chkEnableFind.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.setFilterFind(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfRemoveWord.getDocument()) && LogFilterMain.this.m_chkEnableRemove.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterRemove(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfShowPid.getDocument()) && LogFilterMain.this.m_chkEnableShowPid.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterShowPid(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfShowTid.getDocument()) && LogFilterMain.this.m_chkEnableShowTid.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterShowTid(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfShowTag.getDocument()) && LogFilterMain.this.m_chkEnableShowTag.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterShowTag(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfRemoveTag.getDocument()) && LogFilterMain.this.m_chkEnableRemoveTag.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterRemoveTag(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfHighlight.getDocument()) && LogFilterMain.this.m_chkEnableHighlight.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetHighlight(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                }
                LogFilterMain.this.m_nChangedFilter = 1;
                LogFilterMain.this.runFilter();
            }
            catch (Exception e) {
                T.e(e);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            try {
                if (arg0.getDocument().equals(LogFilterMain.this.m_tfFindWord.getDocument()) && LogFilterMain.this.m_chkEnableFind.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.setFilterFind(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfRemoveWord.getDocument()) && LogFilterMain.this.m_chkEnableRemove.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterRemove(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfShowPid.getDocument()) && LogFilterMain.this.m_chkEnableShowPid.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterShowPid(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfShowTid.getDocument()) && LogFilterMain.this.m_chkEnableShowTid.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterShowTid(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfShowTag.getDocument()) && LogFilterMain.this.m_chkEnableShowTag.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterShowTag(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfRemoveTag.getDocument()) && LogFilterMain.this.m_chkEnableRemoveTag.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetFilterRemoveTag(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                } else if (arg0.getDocument().equals(LogFilterMain.this.m_tfHighlight.getDocument()) && LogFilterMain.this.m_chkEnableHighlight.isSelected()) {
                    LogFilterMain.this.m_tbLogTable.SetHighlight(arg0.getDocument().getText(0, arg0.getDocument().getLength()));
                }
                LogFilterMain.this.m_nChangedFilter = 1;
                LogFilterMain.this.runFilter();
            }
            catch (Exception e) {
                T.e(e);
            }
        }
    };
    ItemListener m_itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JCheckBox check = (JCheckBox)itemEvent.getSource();
            if (check.equals(LogFilterMain.this.m_chkVerbose)) {
                LogFilterMain.this.setLogLV(1, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkDebug)) {
                LogFilterMain.this.setLogLV(2, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkInfo)) {
                LogFilterMain.this.setLogLV(4, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkWarn)) {
                LogFilterMain.this.setLogLV(8, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkError)) {
                LogFilterMain.this.setLogLV(16, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkFatal)) {
                LogFilterMain.this.setLogLV(32, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkClmBookmark)) {
                LogFilterMain.this.m_tbLogTable.showColumn(7, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkClmLine)) {
                LogFilterMain.this.m_tbLogTable.showColumn(0, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkClmDate)) {
                LogFilterMain.this.m_tbLogTable.showColumn(1, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkClmTime)) {
                LogFilterMain.this.m_tbLogTable.showColumn(2, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkClmLogLV)) {
                LogFilterMain.this.m_tbLogTable.showColumn(3, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkClmPid)) {
                LogFilterMain.this.m_tbLogTable.showColumn(4, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkClmThread)) {
                LogFilterMain.this.m_tbLogTable.showColumn(5, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkClmTag)) {
                LogFilterMain.this.m_tbLogTable.showColumn(6, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkClmMessage)) {
                LogFilterMain.this.m_tbLogTable.showColumn(8, check.isSelected());
            } else if (check.equals(LogFilterMain.this.m_chkEnableFind) || check.equals(LogFilterMain.this.m_chkEnableRemove) || check.equals(LogFilterMain.this.m_chkEnableShowPid) || check.equals(LogFilterMain.this.m_chkEnableShowTid) || check.equals(LogFilterMain.this.m_chkEnableShowTag) || check.equals(LogFilterMain.this.m_chkEnableRemoveTag) || check.equals(LogFilterMain.this.m_chkEnableHighlight)) {
                LogFilterMain.this.useFilter(check);
            }
        }
    };

    public static void main(final String[] args) {
        final LogFilterMain mainFrame = new LogFilterMain();
        mainFrame.setTitle("LogFilter Version 1.8");
        JMenuBar menubar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        JMenuItem fileOpen = new JMenuItem("Open");
        fileOpen.setMnemonic(79);
        fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        fileOpen.setToolTipText("Open log file");
        fileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LogFilterMain.this.openFileBrowser();
            }
        });
        m_recentMenu = new RecentFileMenu("RecentFile", 10){

            @Override
            public void onSelectFile(String filePath) {
                mainFrame.parseFile(new File(filePath));
            }
        };
        file.add(fileOpen);
        file.add(m_recentMenu);
        menubar.add(file);
        mainFrame.setJMenuBar(menubar);
        if (args != null && args.length > 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogFilterMain.this.parseFile(new File(args[0]));
                }
            });
        }
    }

    String makeFilename() {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
        return "LogFilter_" + format.format(now) + ".txt";
    }

    void exit() {
        if (this.m_Process != null) {
            this.m_Process.destroy();
        }
        if (this.m_thProcess != null) {
            this.m_thProcess.interrupt();
        }
        if (this.m_thWatchFile != null) {
            this.m_thWatchFile.interrupt();
        }
        if (this.m_thFilterParse != null) {
            this.m_thFilterParse.interrupt();
        }
        this.saveFilter();
        this.saveColor();
        System.exit(0);
    }

    public LogFilterMain() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LogFilterMain.this.exit();
            }
        });
        this.initValue();
        this.createComponent();
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add(this.getOptionPanel(), "North");
        pane.add(this.getBookmarkPanel(), "West");
        pane.add(this.getStatusPanel(), "South");
        pane.add(this.getTabPanel(), "Center");
        this.setDnDListener();
        this.addChangeListener();
        this.startFilterParse();
        this.setVisible(true);
        this.addDesc();
        this.loadFilter();
        this.loadColor();
        this.loadCmd();
        this.m_tbLogTable.setColumnWidth();
        this.setSize(this.m_nWinWidth, this.m_nWinHeight);
        this.setExtendedState(this.m_nWindState);
        this.setMinimumSize(new Dimension(1100, 500));
    }

    void loadCmd() {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream("LogFilterCmd.ini"));
            T.d("p.getProperty(INI_CMD_COUNT) = " + p.getProperty("CMD_COUNT"));
            int nCount = Integer.parseInt(p.getProperty("CMD_COUNT"));
            T.d("nCount = " + nCount);
            int nIndex = 0;
            while (nIndex < nCount) {
                T.d("CMD = CMD_" + nIndex);
                this.m_comboCmd.addItem(p.getProperty("CMD_" + nIndex));
                ++nIndex;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void loadColor() {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream("LogFilterColor.ini"));
            LogColor.COLOR_0 = Integer.parseInt(p.getProperty("INI_COLOR_0").replace("0x", ""), 16);
            LogColor.COLOR_1 = Integer.parseInt(p.getProperty("INI_COLOR_1").replace("0x", ""), 16);
            LogColor.COLOR_2 = Integer.parseInt(p.getProperty("INI_COLOR_2").replace("0x", ""), 16);
            LogColor.COLOR_ERROR = LogColor.COLOR_3 = Integer.parseInt(p.getProperty("INI_COLOR_3(E)").replace("0x", ""), 16);
            LogColor.COLOR_WARN = LogColor.COLOR_4 = Integer.parseInt(p.getProperty("INI_COLOR_4(W)").replace("0x", ""), 16);
            LogColor.COLOR_5 = Integer.parseInt(p.getProperty("INI_COLOR_5").replace("0x", ""), 16);
            LogColor.COLOR_INFO = LogColor.COLOR_6 = Integer.parseInt(p.getProperty("INI_COLOR_6(I)").replace("0x", ""), 16);
            LogColor.COLOR_DEBUG = LogColor.COLOR_7 = Integer.parseInt(p.getProperty("INI_COLOR_7(D)").replace("0x", ""), 16);
            LogColor.COLOR_FATAL = LogColor.COLOR_8 = Integer.parseInt(p.getProperty("INI_COLOR_8(F)").replace("0x", ""), 16);
            int nCount = Integer.parseInt(p.getProperty("INI_HIGILIGHT_COUNT", "0"));
            if (nCount > 0) {
                LogColor.COLOR_HIGHLIGHT = new String[nCount];
                int nIndex = 0;
                while (nIndex < nCount) {
                    LogColor.COLOR_HIGHLIGHT[nIndex] = p.getProperty("INI_HIGILIGHT_" + nIndex).replace("0x", "");
                    ++nIndex;
                }
            } else {
                LogColor.COLOR_HIGHLIGHT = new String[1];
                LogColor.COLOR_HIGHLIGHT[0] = "ffff";
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void saveColor() {
        try {
            Properties p = new Properties();
            p.setProperty("INI_COLOR_0", "0x" + Integer.toHexString(LogColor.COLOR_0).toUpperCase());
            p.setProperty("INI_COLOR_1", "0x" + Integer.toHexString(LogColor.COLOR_1).toUpperCase());
            p.setProperty("INI_COLOR_2", "0x" + Integer.toHexString(LogColor.COLOR_2).toUpperCase());
            p.setProperty("INI_COLOR_3(E)", "0x" + Integer.toHexString(LogColor.COLOR_3).toUpperCase());
            p.setProperty("INI_COLOR_4(W)", "0x" + Integer.toHexString(LogColor.COLOR_4).toUpperCase());
            p.setProperty("INI_COLOR_5", "0x" + Integer.toHexString(LogColor.COLOR_5).toUpperCase());
            p.setProperty("INI_COLOR_6(I)", "0x" + Integer.toHexString(LogColor.COLOR_6).toUpperCase());
            p.setProperty("INI_COLOR_7(D)", "0x" + Integer.toHexString(LogColor.COLOR_7).toUpperCase());
            p.setProperty("INI_COLOR_8(F)", "0x" + Integer.toHexString(LogColor.COLOR_8).toUpperCase());
            if (LogColor.COLOR_HIGHLIGHT != null) {
                p.setProperty("INI_HIGILIGHT_COUNT", "" + LogColor.COLOR_HIGHLIGHT.length);
                int nIndex = 0;
                while (nIndex < LogColor.COLOR_HIGHLIGHT.length) {
                    p.setProperty("INI_HIGILIGHT_" + nIndex, "0x" + LogColor.COLOR_HIGHLIGHT[nIndex].toUpperCase());
                    ++nIndex;
                }
            }
            p.store(new FileOutputStream("LogFilterColor.ini"), "done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadFilter() {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream("LogFilter.ini"));
            String strFontType = p.getProperty("FONT_TYPE");
            if (strFontType != null && strFontType.length() > 0) {
                this.m_jcFontType.setSelectedItem(p.getProperty("FONT_TYPE"));
            }
            this.m_tfFindWord.setText(p.getProperty("WORD_FIND"));
            this.m_tfRemoveWord.setText(p.getProperty("WORD_REMOVE"));
            this.m_tfShowTag.setText(p.getProperty("TAG_SHOW"));
            this.m_tfRemoveTag.setText(p.getProperty("TAG_REMOVE"));
            this.m_tfShowPid.setText(p.getProperty("PID_SHOW"));
            this.m_tfShowTid.setText(p.getProperty("TID_SHOW"));
            this.m_tfHighlight.setText(p.getProperty("HIGHLIGHT"));
            this.m_nWinWidth = Integer.parseInt(p.getProperty("INI_WIDTH"));
            this.m_nWinHeight = Integer.parseInt(p.getProperty("INI_HEIGHT"));
            this.m_nWindState = Integer.parseInt(p.getProperty("INI_WINDOW_STATE"));
            int nIndex = 0;
            while (nIndex < 9) {
                LogFilterTableModel.setColumnWidth(nIndex, Integer.parseInt(p.getProperty("INI_COMUMN_" + nIndex)));
                ++nIndex;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void saveFilter() {
        try {
            this.m_nWinWidth = this.m_nLastWidth;
            this.m_nWinHeight = this.m_nLastHeight;
            this.m_nWindState = this.getExtendedState();
            T.d("m_nWindState = " + this.m_nWindState);
            Properties p = new Properties();
            p.setProperty("FONT_TYPE", (String)this.m_jcFontType.getSelectedItem());
            p.setProperty("WORD_FIND", this.m_tfFindWord.getText());
            p.setProperty("WORD_REMOVE", this.m_tfRemoveWord.getText());
            p.setProperty("TAG_SHOW", this.m_tfShowTag.getText());
            p.setProperty("TAG_REMOVE", this.m_tfRemoveTag.getText());
            p.setProperty("PID_SHOW", this.m_tfShowPid.getText());
            p.setProperty("TID_SHOW", this.m_tfShowTid.getText());
            p.setProperty("HIGHLIGHT", this.m_tfHighlight.getText());
            p.setProperty("INI_WIDTH", "" + this.m_nWinWidth);
            p.setProperty("INI_HEIGHT", "" + this.m_nWinHeight);
            p.setProperty("INI_WINDOW_STATE", "" + this.m_nWindState);
            int nIndex = 0;
            while (nIndex < 9) {
                p.setProperty("INI_COMUMN_" + nIndex, "" + this.m_tbLogTable.getColumnWidth(nIndex));
                ++nIndex;
            }
            p.store(new FileOutputStream("LogFilter.ini"), "done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void addDesc(String strMessage) {
        LogInfo logInfo = new LogInfo();
        logInfo.m_strLine = "" + (this.m_arLogInfoAll.size() + 1);
        logInfo.m_strMessage = strMessage;
        this.m_arLogInfoAll.add(logInfo);
    }

    void addDesc() {
        this.addDesc(VERSION);
        this.addDesc("");
        this.addDesc("Version 1.8 : java -jar LogFilter_xx.jar [filename] \ucd94\uac00");
        this.addDesc("Version 1.7 : copy\uc2dc \ubcf4\uc774\ub294 column\ub9cc clipboard\uc5d0 \ubcf5\uc0ac(Line \uc81c\uc678)");
        this.addDesc("Version 1.6 : cmd\ucf64\ubcf4\ubc15\uc2a4 \uae38\uc774 \uace0\uc815");
        this.addDesc("Version 1.5 : Highlight color list\ucd94\uac00()");
        this.addDesc("   - LogFilterColor.ini \uc5d0 \uce74\uc6b4\ud2b8\uc640 \uac12 \ub123\uc5b4 \uc8fc\uc2dc\uba74 \ub429\ub2c8\ub2e4.");
        this.addDesc("   - ex)INI_HIGILIGHT_COUNT=2");
        this.addDesc("   -    INI_COLOR_HIGILIGHT_0=0xFFFF");
        this.addDesc("   -    INI_COLOR_HIGILIGHT_1=0x00FF");
        this.addDesc("Version 1.4 : \ucc3d\ud06c\uae30 \uc800\uc7a5");
        this.addDesc("Version 1.3 : recent file \ubc0f open\uba54\ub274\ucd94\uac00");
        this.addDesc("Version 1.2 : Tid \ud544\ud130 \ucd94\uac00");
        this.addDesc("Version 1.1 : Level F \ucd94\uac00");
        this.addDesc("Version 1.0 : Pid filter \ucd94\uac00");
        this.addDesc("Version 0.9 : Font type \ucd94\uac00");
        this.addDesc("Version 0.8 : \ud544\ud130\uccb4\ud06c \ubc15\uc2a4 \ucd94\uac00");
        this.addDesc("Version 0.7 : \ucee4\ub110\ub85c\uadf8 \ud30c\uc2f1/LogFilter.ini\uc5d0 \uceec\ub7ec\uc815\uc758(0~7)");
        this.addDesc("Version 0.6 : \ud544\ud130 \ub300\uc18c\ubb38 \ubb34\uc2dc");
        this.addDesc("Version 0.5 : \uba85\ub839\uc5b4 ini\ud30c\uc77c\ub85c \uc800\uc7a5");
        this.addDesc("Version 0.4 : add thread option, filter \uc800\uc7a5");
        this.addDesc("Version 0.3 : \ub2e8\ub9d0 \uc120\ud0dd \uc548\ub418\ub294 \ubb38\uc81c \uc218\uc815");
        this.addDesc("");
        this.addDesc("[Tag]");
        this.addDesc("Alt+L/R Click : Show/Remove tag");
        this.addDesc("");
        this.addDesc("[Bookmark]");
        this.addDesc("Ctrl+F2/double click: bookmark toggle");
        this.addDesc("F2 : pre bookmark");
        this.addDesc("F3 : next bookmark");
        this.addDesc("");
        this.addDesc("[Copy]");
        this.addDesc("Ctrl+c : row copy");
        this.addDesc("right click : cloumn copy");
        this.addDesc("");
        this.addDesc("[New version]");
        this.addDesc("http://blog.naver.com/iookill/140135139931");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bookmarkItem(int nIndex, int nLine, boolean bBookmark) {
        Object object = this.FILTER_LOCK;
        synchronized (object) {
            LogInfo logInfo = this.m_arLogInfoAll.get(nLine);
            logInfo.m_bMarked = bBookmark;
            this.m_arLogInfoAll.set(nLine, logInfo);
            if (logInfo.m_bMarked) {
                this.m_hmBookmarkAll.put(nLine, nLine);
                if (this.m_bUserFilter) {
                    this.m_hmBookmarkFiltered.put(nLine, nIndex);
                }
            } else {
                this.m_hmBookmarkAll.remove(nLine);
                if (this.m_bUserFilter) {
                    this.m_hmBookmarkFiltered.remove(nLine);
                }
            }
        }
        this.m_ipIndicator.repaint();
    }

    void clearData() {
        this.m_arTagInfo.clear();
        this.m_arLogInfoAll.clear();
        this.m_arLogInfoFiltered.clear();
        this.m_hmBookmarkAll.clear();
        this.m_hmBookmarkFiltered.clear();
        this.m_hmErrorAll.clear();
        this.m_hmErrorFiltered.clear();
    }

    void createComponent() {
    }

    Component getBookmarkPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        this.m_ipIndicator = new IndicatorPanel(this);
        this.m_ipIndicator.setData(this.m_arLogInfoAll, this.m_hmBookmarkAll, this.m_hmErrorAll);
        jp.add((Component)this.m_ipIndicator, "Center");
        return jp;
    }

    Component getCmdPanel() {
        JPanel jpOptionDevice = new JPanel();
        jpOptionDevice.setBorder(BorderFactory.createTitledBorder("Device select"));
        jpOptionDevice.setLayout(new BorderLayout());
        JPanel jpCmd = new JPanel();
        this.m_comboDeviceCmd = new JComboBox();
        this.m_comboDeviceCmd.addItem("Android          ");
        this.m_comboDeviceCmd.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                DefaultListModel listModel = (DefaultListModel)LogFilterMain.this.m_lDeviceList.getModel();
                listModel.clear();
                if (e.getItem().equals("custom command")) {
                    LogFilterMain.this.m_comboDeviceCmd.setEditable(true);
                } else {
                    LogFilterMain.this.m_comboDeviceCmd.setEditable(false);
                }
                LogFilterMain.this.setProcessCmd(LogFilterMain.this.m_comboDeviceCmd.getSelectedIndex(), LogFilterMain.this.m_strSelectedDevice);
            }
        });
        DefaultListModel listModel = new DefaultListModel();
        this.m_btnDevice = new JButton("OK");
        this.m_btnDevice.setMargin(new Insets(0, 0, 0, 0));
        this.m_btnDevice.addActionListener(this.m_alButtonListener);
        jpCmd.add(this.m_comboDeviceCmd);
        jpCmd.add(this.m_btnDevice);
        jpOptionDevice.add((Component)jpCmd, "North");
        this.m_lDeviceList = new JList(listModel);
        JScrollPane vbar = new JScrollPane(this.m_lDeviceList);
        vbar.setPreferredSize(new Dimension(100, 50));
        this.m_lDeviceList.setSelectionMode(0);
        this.m_lDeviceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList deviceList = (JList)e.getSource();
                Object selectedItem = deviceList.getSelectedValue();
                LogFilterMain.this.m_strSelectedDevice = "";
                if (selectedItem != null) {
                    LogFilterMain.this.m_strSelectedDevice = selectedItem.toString();
                    LogFilterMain.this.m_strSelectedDevice = LogFilterMain.this.m_strSelectedDevice.replace("\t", " ").replace("device", "").replace("offline", "");
                    LogFilterMain.this.setProcessCmd(LogFilterMain.this.m_comboDeviceCmd.getSelectedIndex(), LogFilterMain.this.m_strSelectedDevice);
                }
            }
        });
        jpOptionDevice.add(vbar);
        return jpOptionDevice;
    }

    void addTagList(String strTag) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLogInfo(LogInfo logInfo) {
        Object object = this.FILTER_LOCK;
        synchronized (object) {
            this.m_tbLogTable.setTagLength(logInfo.m_strTag.length());
            this.m_arLogInfoAll.add(logInfo);
            if (logInfo.m_strLogLV.equals("E") || logInfo.m_strLogLV.equals("ERROR")) {
                this.m_hmErrorAll.put(Integer.parseInt(logInfo.m_strLine) - 1, Integer.parseInt(logInfo.m_strLine) - 1);
            }
            if (this.m_bUserFilter) {
                if (this.m_ipIndicator.m_chBookmark.isSelected() || this.m_ipIndicator.m_chError.isSelected()) {
                    boolean bAddFilteredArray = false;
                    if (logInfo.m_bMarked && this.m_ipIndicator.m_chBookmark.isSelected()) {
                        bAddFilteredArray = true;
                        this.m_hmBookmarkFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, this.m_arLogInfoFiltered.size());
                        if (logInfo.m_strLogLV.equals("E") || logInfo.m_strLogLV.equals("ERROR")) {
                            this.m_hmErrorFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, this.m_arLogInfoFiltered.size());
                        }
                    }
                    if ((logInfo.m_strLogLV.equals("E") || logInfo.m_strLogLV.equals("ERROR")) && this.m_ipIndicator.m_chError.isSelected()) {
                        bAddFilteredArray = true;
                        this.m_hmErrorFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, this.m_arLogInfoFiltered.size());
                        if (logInfo.m_bMarked) {
                            this.m_hmBookmarkFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, this.m_arLogInfoFiltered.size());
                        }
                    }
                    if (bAddFilteredArray) {
                        this.m_arLogInfoFiltered.add(logInfo);
                    }
                } else if (this.checkLogLVFilter(logInfo) && this.checkPidFilter(logInfo) && this.checkTidFilter(logInfo) && this.checkShowTagFilter(logInfo) && this.checkRemoveTagFilter(logInfo) && this.checkFindFilter(logInfo) && this.checkRemoveFilter(logInfo)) {
                    this.m_arLogInfoFiltered.add(logInfo);
                    if (logInfo.m_bMarked) {
                        this.m_hmBookmarkFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, this.m_arLogInfoFiltered.size());
                    }
                    if ((logInfo.m_strLogLV == "E" || logInfo.m_strLogLV == "ERROR") && (logInfo.m_strLogLV.equals("E") || logInfo.m_strLogLV.equals("ERROR"))) {
                        this.m_hmErrorFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, this.m_arLogInfoFiltered.size());
                    }
                }
            }
        }
    }

    void addChangeListener() {
        this.m_tfHighlight.getDocument().addDocumentListener(this.m_dlFilterListener);
        this.m_tfFindWord.getDocument().addDocumentListener(this.m_dlFilterListener);
        this.m_tfRemoveWord.getDocument().addDocumentListener(this.m_dlFilterListener);
        this.m_tfShowTag.getDocument().addDocumentListener(this.m_dlFilterListener);
        this.m_tfRemoveTag.getDocument().addDocumentListener(this.m_dlFilterListener);
        this.m_tfShowPid.getDocument().addDocumentListener(this.m_dlFilterListener);
        this.m_tfShowTid.getDocument().addDocumentListener(this.m_dlFilterListener);
        this.m_chkEnableFind.addItemListener(this.m_itemListener);
        this.m_chkEnableRemove.addItemListener(this.m_itemListener);
        this.m_chkEnableShowPid.addItemListener(this.m_itemListener);
        this.m_chkEnableShowTid.addItemListener(this.m_itemListener);
        this.m_chkEnableShowTag.addItemListener(this.m_itemListener);
        this.m_chkEnableRemoveTag.addItemListener(this.m_itemListener);
        this.m_chkEnableHighlight.addItemListener(this.m_itemListener);
        this.m_chkVerbose.addItemListener(this.m_itemListener);
        this.m_chkDebug.addItemListener(this.m_itemListener);
        this.m_chkInfo.addItemListener(this.m_itemListener);
        this.m_chkWarn.addItemListener(this.m_itemListener);
        this.m_chkError.addItemListener(this.m_itemListener);
        this.m_chkFatal.addItemListener(this.m_itemListener);
        this.m_chkClmBookmark.addItemListener(this.m_itemListener);
        this.m_chkClmLine.addItemListener(this.m_itemListener);
        this.m_chkClmDate.addItemListener(this.m_itemListener);
        this.m_chkClmTime.addItemListener(this.m_itemListener);
        this.m_chkClmLogLV.addItemListener(this.m_itemListener);
        this.m_chkClmPid.addItemListener(this.m_itemListener);
        this.m_chkClmThread.addItemListener(this.m_itemListener);
        this.m_chkClmTag.addItemListener(this.m_itemListener);
        this.m_chkClmMessage.addItemListener(this.m_itemListener);
        this.m_scrollVBar.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LogFilterMain.this.getExtendedState() != 6) {
                    LogFilterMain.this.m_nLastWidth = LogFilterMain.this.getWidth();
                    LogFilterMain.this.m_nLastHeight = LogFilterMain.this.getHeight();
                }
                LogFilterMain.this.m_ipIndicator.repaint();
            }
        });
    }

    Component getFilterPanel() {
        this.m_chkEnableFind = new JCheckBox();
        this.m_chkEnableRemove = new JCheckBox();
        this.m_chkEnableShowTag = new JCheckBox();
        this.m_chkEnableRemoveTag = new JCheckBox();
        this.m_chkEnableShowPid = new JCheckBox();
        this.m_chkEnableShowTid = new JCheckBox();
        this.m_chkEnableFind.setSelected(true);
        this.m_chkEnableRemove.setSelected(true);
        this.m_chkEnableShowTag.setSelected(true);
        this.m_chkEnableRemoveTag.setSelected(true);
        this.m_chkEnableShowPid.setSelected(true);
        this.m_chkEnableShowTid.setSelected(true);
        this.m_tfFindWord = new JTextField();
        this.m_tfRemoveWord = new JTextField();
        this.m_tfShowTag = new JTextField();
        this.m_tfRemoveTag = new JTextField();
        this.m_tfShowPid = new JTextField();
        this.m_tfShowTid = new JTextField();
        JPanel jpMain = new JPanel(new BorderLayout());
        JPanel jpWordFilter = new JPanel(new BorderLayout());
        jpWordFilter.setBorder(BorderFactory.createTitledBorder("Word filter"));
        JPanel jpFind = new JPanel(new BorderLayout());
        JLabel find = new JLabel();
        find.setText("        Find : ");
        jpFind.add((Component)find, "West");
        jpFind.add((Component)this.m_tfFindWord, "Center");
        jpFind.add((Component)this.m_chkEnableFind, "East");
        JPanel jpRemove = new JPanel(new BorderLayout());
        JLabel remove = new JLabel();
        remove.setText("Remove : ");
        jpRemove.add((Component)remove, "West");
        jpRemove.add((Component)this.m_tfRemoveWord, "Center");
        jpRemove.add((Component)this.m_chkEnableRemove, "East");
        jpWordFilter.add((Component)jpFind, "North");
        jpWordFilter.add(jpRemove);
        jpMain.add((Component)jpWordFilter, "North");
        JPanel jpTagFilter = new JPanel(new GridLayout(4, 1));
        jpTagFilter.setBorder(BorderFactory.createTitledBorder("Tag filter"));
        JPanel jpPid = new JPanel(new BorderLayout());
        JLabel pid = new JLabel();
        pid.setText("         Pid : ");
        jpPid.add((Component)pid, "West");
        jpPid.add((Component)this.m_tfShowPid, "Center");
        jpPid.add((Component)this.m_chkEnableShowPid, "East");
        JPanel jpTid = new JPanel(new BorderLayout());
        JLabel tid = new JLabel();
        tid.setText("         Tid : ");
        jpTid.add((Component)tid, "West");
        jpTid.add((Component)this.m_tfShowTid, "Center");
        jpTid.add((Component)this.m_chkEnableShowTid, "East");
        JPanel jpShow = new JPanel(new BorderLayout());
        JLabel show = new JLabel();
        show.setText("     Show : ");
        jpShow.add((Component)show, "West");
        jpShow.add((Component)this.m_tfShowTag, "Center");
        jpShow.add((Component)this.m_chkEnableShowTag, "East");
        JPanel jpRemoveTag = new JPanel(new BorderLayout());
        JLabel removeTag = new JLabel();
        removeTag.setText("Remove : ");
        jpRemoveTag.add((Component)removeTag, "West");
        jpRemoveTag.add((Component)this.m_tfRemoveTag, "Center");
        jpRemoveTag.add((Component)this.m_chkEnableRemoveTag, "East");
        jpTagFilter.add(jpPid);
        jpTagFilter.add(jpTid);
        jpTagFilter.add(jpShow);
        jpTagFilter.add(jpRemoveTag);
        jpMain.add((Component)jpTagFilter, "Center");
        return jpMain;
    }

    Component getHighlightPanel() {
        this.m_chkEnableHighlight = new JCheckBox();
        this.m_chkEnableHighlight.setSelected(true);
        this.m_tfHighlight = new JTextField();
        JPanel jpMain = new JPanel(new BorderLayout());
        jpMain.setBorder(BorderFactory.createTitledBorder("Highlight"));
        JLabel jlHighlight = new JLabel();
        jlHighlight.setText("Highlight : ");
        jpMain.add((Component)jlHighlight, "West");
        jpMain.add(this.m_tfHighlight);
        jpMain.add((Component)this.m_chkEnableHighlight, "East");
        return jpMain;
    }

    Component getCheckPanel() {
        this.m_chkVerbose = new JCheckBox();
        this.m_chkDebug = new JCheckBox();
        this.m_chkInfo = new JCheckBox();
        this.m_chkWarn = new JCheckBox();
        this.m_chkError = new JCheckBox();
        this.m_chkFatal = new JCheckBox();
        this.m_chkClmBookmark = new JCheckBox();
        this.m_chkClmLine = new JCheckBox();
        this.m_chkClmDate = new JCheckBox();
        this.m_chkClmTime = new JCheckBox();
        this.m_chkClmLogLV = new JCheckBox();
        this.m_chkClmPid = new JCheckBox();
        this.m_chkClmThread = new JCheckBox();
        this.m_chkClmTag = new JCheckBox();
        this.m_chkClmMessage = new JCheckBox();
        JPanel jpMain = new JPanel(new BorderLayout());
        JPanel jpLogFilter = new JPanel();
        jpLogFilter.setLayout(new FlowLayout(1, 0, 0));
        jpLogFilter.setBorder(BorderFactory.createTitledBorder("Log filter"));
        this.m_chkVerbose.setText("Verbose");
        this.m_chkVerbose.setSelected(true);
        this.m_chkDebug.setText("Debug");
        this.m_chkDebug.setSelected(true);
        this.m_chkInfo.setText("Info");
        this.m_chkInfo.setSelected(true);
        this.m_chkWarn.setText("Warn");
        this.m_chkWarn.setSelected(true);
        this.m_chkError.setText("Error");
        this.m_chkError.setSelected(true);
        this.m_chkFatal.setText("Fatal");
        this.m_chkFatal.setSelected(true);
        jpLogFilter.add(this.m_chkVerbose);
        jpLogFilter.add(this.m_chkDebug);
        jpLogFilter.add(this.m_chkInfo);
        jpLogFilter.add(this.m_chkWarn);
        jpLogFilter.add(this.m_chkError);
        jpLogFilter.add(this.m_chkFatal);
        jpMain.add((Component)jpLogFilter, "North");
        JPanel jpShowColumn = new JPanel();
        jpShowColumn.setLayout(new FlowLayout(1, 0, 0));
        jpShowColumn.setBorder(BorderFactory.createTitledBorder("Show column"));
        this.m_chkClmBookmark.setText("Mark");
        this.m_chkClmBookmark.setToolTipText("Bookmark");
        this.m_chkClmLine.setText("Line");
        this.m_chkClmLine.setSelected(true);
        this.m_chkClmDate.setText("Date");
        this.m_chkClmDate.setSelected(true);
        this.m_chkClmTime.setText("Time");
        this.m_chkClmTime.setSelected(true);
        this.m_chkClmLogLV.setText("LogLV");
        this.m_chkClmLogLV.setSelected(true);
        this.m_chkClmPid.setText("Pid");
        this.m_chkClmPid.setSelected(true);
        this.m_chkClmThread.setText("Thread");
        this.m_chkClmThread.setSelected(true);
        this.m_chkClmTag.setText("Tag");
        this.m_chkClmTag.setSelected(true);
        this.m_chkClmMessage.setText("Msg");
        this.m_chkClmMessage.setSelected(true);
        jpShowColumn.add(this.m_chkClmBookmark);
        jpShowColumn.add(this.m_chkClmLine);
        jpShowColumn.add(this.m_chkClmDate);
        jpShowColumn.add(this.m_chkClmTime);
        jpShowColumn.add(this.m_chkClmLogLV);
        jpShowColumn.add(this.m_chkClmPid);
        jpShowColumn.add(this.m_chkClmThread);
        jpShowColumn.add(this.m_chkClmTag);
        jpShowColumn.add(this.m_chkClmMessage);
        jpMain.add((Component)jpShowColumn, "Center");
        jpMain.add(this.getHighlightPanel(), "South");
        return jpMain;
    }

    Component getOptionFilter() {
        JPanel optionFilter = new JPanel(new BorderLayout());
        optionFilter.add(this.getCmdPanel(), "West");
        optionFilter.add(this.getCheckPanel(), "East");
        optionFilter.add(this.getFilterPanel(), "Center");
        return optionFilter;
    }

    Component getOptionMenu() {
        JPanel optionMenu = new JPanel(new BorderLayout());
        JPanel optionWest = new JPanel();
        JLabel jlFontType = new JLabel("Font Type : ");
        this.m_jcFontType = new JComboBox();
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.m_jcFontType.addItem("Dialog");
        int i = 0;
        while (i < fonts.length) {
            this.m_jcFontType.addItem(fonts[i]);
            ++i;
        }
        this.m_jcFontType.addActionListener(this.m_alButtonListener);
        JLabel jlFont = new JLabel("Font Size : ");
        this.m_tfFontSize = new JTextField(2);
        this.m_tfFontSize.setHorizontalAlignment(4);
        this.m_tfFontSize.setText("12");
        this.m_btnSetFont = new JButton("OK");
        this.m_btnSetFont.setMargin(new Insets(0, 0, 0, 0));
        this.m_btnSetFont.addActionListener(this.m_alButtonListener);
        JLabel jlEncode = new JLabel("Text Encode : ");
        this.m_comboEncode = new JComboBox();
        this.m_comboEncode.addItem("UTF-8");
        this.m_comboEncode.addItem("Local");
        JLabel jlGoto = new JLabel("Goto : ");
        final JTextField tfGoto = new JTextField(6);
        tfGoto.setHorizontalAlignment(4);
        tfGoto.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                try {
                    int nIndex = Integer.parseInt(tfGoto.getText()) - 1;
                    LogFilterMain.this.m_tbLogTable.showRow(nIndex, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JLabel jlProcessCmd = new JLabel("Cmd : ");
        this.m_comboCmd = new JComboBox();
        this.m_comboCmd.setPreferredSize(new Dimension(180, 25));
        this.m_btnClear = new JButton("Clear");
        this.m_btnClear.setMargin(new Insets(0, 0, 0, 0));
        this.m_btnClear.setEnabled(false);
        this.m_btnRun = new JButton("Run");
        this.m_btnRun.setMargin(new Insets(0, 0, 0, 0));
        this.m_tbtnPause = new JToggleButton("Pause");
        this.m_tbtnPause.setMargin(new Insets(0, 0, 0, 0));
        this.m_tbtnPause.setEnabled(false);
        this.m_btnStop = new JButton("Stop");
        this.m_btnStop.setMargin(new Insets(0, 0, 0, 0));
        this.m_btnStop.setEnabled(false);
        this.m_btnRun.addActionListener(this.m_alButtonListener);
        this.m_btnStop.addActionListener(this.m_alButtonListener);
        this.m_btnClear.addActionListener(this.m_alButtonListener);
        this.m_tbtnPause.addActionListener(this.m_alButtonListener);
        optionWest.add(jlFontType);
        optionWest.add(this.m_jcFontType);
        optionWest.add(jlFont);
        optionWest.add(this.m_tfFontSize);
        optionWest.add(this.m_btnSetFont);
        optionWest.add(jlEncode);
        optionWest.add(this.m_comboEncode);
        optionWest.add(jlGoto);
        optionWest.add(tfGoto);
        optionWest.add(jlProcessCmd);
        optionWest.add(this.m_comboCmd);
        optionWest.add(this.m_btnClear);
        optionWest.add(this.m_btnRun);
        optionWest.add(this.m_tbtnPause);
        optionWest.add(this.m_btnStop);
        optionMenu.add((Component)optionWest, "West");
        return optionMenu;
    }

    Component getOptionPanel() {
        JPanel optionMain = new JPanel(new BorderLayout());
        optionMain.add(this.getOptionFilter(), "Center");
        optionMain.add(this.getOptionMenu(), "South");
        return optionMain;
    }

    Component getStatusPanel() {
        this.m_tfStatus = new JTextField("ready");
        this.m_tfStatus.setEditable(false);
        return this.m_tfStatus;
    }

    Component getTabPanel() {
        this.m_tpTab = new JTabbedPane();
        this.m_tmLogTableModel = new LogFilterTableModel();
        this.m_tmLogTableModel.setData(this.m_arLogInfoAll);
        this.m_tbLogTable = new LogTable(this.m_tmLogTableModel, this);
        this.m_iLogParser = new LogCatParser();
        this.m_tbLogTable.setLogParser(this.m_iLogParser);
        this.m_scrollVBar = new JScrollPane(this.m_tbLogTable);
        this.m_tpTab.addTab("Log", this.m_scrollVBar);
        return this.m_scrollVBar;
    }

    void initValue() {
        this.m_bPauseADB = false;
        this.FILE_LOCK = new Object();
        this.FILTER_LOCK = new Object();
        this.m_nChangedFilter = 4;
        this.m_nFilterLogLV = 63;
        this.m_arTagInfo = new ArrayList();
        this.m_arLogInfoAll = new ArrayList();
        this.m_arLogInfoFiltered = new ArrayList();
        this.m_hmBookmarkAll = new HashMap();
        this.m_hmBookmarkFiltered = new HashMap();
        this.m_hmErrorAll = new HashMap();
        this.m_hmErrorFiltered = new HashMap();
        this.m_strLogFileName = this.makeFilename();
    }

    void parseFile(final File file) {
        if (file == null) {
            T.e("file == null");
            return;
        }
        this.setTitle(file.getPath());
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileInputStream fstream = null;
                DataInputStream in = null;
                BufferedReader br = null;
                int nIndex = 1;
                try {
                    String strLine;
                    fstream = new FileInputStream(file);
                    in = new DataInputStream(fstream);
                    br = LogFilterMain.this.m_comboEncode.getSelectedItem().equals("UTF-8") ? new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8")) : new BufferedReader(new InputStreamReader(in));
                    LogFilterMain.this.setStatus("Parsing");
                    LogFilterMain.this.clearData();
                    LogFilterMain.this.m_tbLogTable.clearSelection();
                    while ((strLine = br.readLine()) != null) {
                        if (strLine == null || "".equals(strLine.trim())) continue;
                        LogInfo logInfo = LogFilterMain.this.m_iLogParser.parseLog(strLine);
                        logInfo.m_strLine = "" + nIndex++;
                        LogFilterMain.this.addLogInfo(logInfo);
                    }
                    LogFilterMain.this.runFilter();
                    LogFilterMain.this.setStatus("Parse complete");
                }
                catch (Exception ioe) {
                    T.e(ioe);
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (fstream != null) {
                        fstream.close();
                    }
                }
                catch (Exception e) {
                    T.e(e);
                }
            }
        }).start();
    }

    void pauseProcess() {
        if (this.m_tbtnPause.isSelected()) {
            this.m_bPauseADB = true;
            this.m_tbtnPause.setText("Resume");
        } else {
            this.m_bPauseADB = false;
            this.m_tbtnPause.setText("Pause");
        }
    }

    void setBookmark(int nLine, String strBookmark) {
        LogInfo logInfo = this.m_arLogInfoAll.get(nLine);
        logInfo.m_strBookmark = strBookmark;
        this.m_arLogInfoAll.set(nLine, logInfo);
    }

    void setDeviceList() {
        this.m_strSelectedDevice = "";
        DefaultListModel listModel = (DefaultListModel)this.m_lDeviceList.getModel();
        try {
            String s;
            listModel.clear();
            String strCommand = this.DEVICES_CMD[this.m_comboDeviceCmd.getSelectedIndex()];
            if (this.m_comboDeviceCmd.getSelectedIndex() == 2) {
                strCommand = (String)this.m_comboDeviceCmd.getSelectedItem();
            }
            Process oProcess = Runtime.getRuntime().exec(strCommand);
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(oProcess.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(oProcess.getErrorStream()));
            while ((s = stdOut.readLine()) != null) {
                if (s.equals("List of devices attached ")) continue;
                s = s.replace("\t", " ");
                s = s.replace("device", "");
                listModel.addElement(s);
            }
            while ((s = stdError.readLine()) != null) {
                listModel.addElement(s);
            }
            System.out.println("Exit Code: " + oProcess.exitValue());
        }
        catch (Exception e) {
            T.e("e = " + e);
            listModel.addElement(e);
        }
    }

    public void setFindFocus() {
        this.m_tfFindWord.requestFocus();
    }

    void setDnDListener() {
        new DropTarget(this, 3, new DropTargetListener(){

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void dragEnter(DropTargetDragEvent event) {
            }

            @Override
            public void drop(DropTargetDropEvent event) {
                try {
                    event.acceptDrop(1);
                    Transferable t = event.getTransferable();
                    List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator i = list.iterator();
                    if (i.hasNext()) {
                        File file = (File)i.next();
                        LogFilterMain.this.setTitle(file.getPath());
                        LogFilterMain.this.stopProcess();
                        LogFilterMain.this.parseFile(file);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    void setLogLV(int nLogLV, boolean bChecked) {
        this.m_nFilterLogLV = bChecked ? (this.m_nFilterLogLV |= nLogLV) : (this.m_nFilterLogLV &= ~nLogLV);
        this.m_nChangedFilter = 1;
        this.runFilter();
    }

    void useFilter(JCheckBox checkBox) {
        if (checkBox.equals(this.m_chkEnableFind)) {
            this.m_tbLogTable.setFilterFind(checkBox.isSelected() ? this.m_tfFindWord.getText() : "");
        }
        if (checkBox.equals(this.m_chkEnableRemove)) {
            this.m_tbLogTable.SetFilterRemove(checkBox.isSelected() ? this.m_tfRemoveWord.getText() : "");
        }
        if (checkBox.equals(this.m_chkEnableShowPid)) {
            this.m_tbLogTable.SetFilterShowPid(checkBox.isSelected() ? this.m_tfShowPid.getText() : "");
        }
        if (checkBox.equals(this.m_chkEnableShowTid)) {
            this.m_tbLogTable.SetFilterShowTid(checkBox.isSelected() ? this.m_tfShowTid.getText() : "");
        }
        if (checkBox.equals(this.m_chkEnableShowTag)) {
            this.m_tbLogTable.SetFilterShowTag(checkBox.isSelected() ? this.m_tfShowTag.getText() : "");
        }
        if (checkBox.equals(this.m_chkEnableRemoveTag)) {
            this.m_tbLogTable.SetFilterRemoveTag(checkBox.isSelected() ? this.m_tfRemoveTag.getText() : "");
        }
        if (checkBox.equals(this.m_chkEnableHighlight)) {
            this.m_tbLogTable.SetHighlight(checkBox.isSelected() ? this.m_tfHighlight.getText() : "");
        }
        this.m_nChangedFilter = 1;
        this.runFilter();
    }

    void setProcessBtn(boolean bStart) {
        if (bStart) {
            this.m_btnRun.setEnabled(false);
            this.m_btnStop.setEnabled(true);
            this.m_btnClear.setEnabled(true);
            this.m_tbtnPause.setEnabled(true);
        } else {
            this.m_btnRun.setEnabled(true);
            this.m_btnStop.setEnabled(false);
            this.m_btnClear.setEnabled(false);
            this.m_tbtnPause.setEnabled(false);
            this.m_tbtnPause.setSelected(false);
            this.m_tbtnPause.setText("Pause");
        }
    }

    String getProcessCmd() {
        if (this.m_lDeviceList.getSelectedIndex() < 0) {
            return "adb " + this.m_comboCmd.getSelectedItem();
        }
        return "adb -s " + this.m_strSelectedDevice + this.m_comboCmd.getSelectedItem();
    }

    void setProcessCmd(int nType, String strSelectedDevice) {
        this.m_strLogFileName = this.makeFilename();
        if (nType == 0) {
            if (strSelectedDevice != null) {
                strSelectedDevice.length();
            }
        } else if (nType == 1 && strSelectedDevice != null) {
            strSelectedDevice.length();
        }
    }

    void setStatus(String strText) {
        this.m_tfStatus.setText(strText);
    }

    @Override
    public void setTitle(String strTitle) {
        super.setTitle(strTitle);
    }

    void stopProcess() {
        this.setProcessBtn(false);
        if (this.m_Process != null) {
            this.m_Process.destroy();
        }
        if (this.m_thProcess != null) {
            this.m_thProcess.interrupt();
        }
        if (this.m_thWatchFile != null) {
            this.m_thWatchFile.interrupt();
        }
        this.m_Process = null;
        this.m_thProcess = null;
        this.m_thWatchFile = null;
        this.m_bPauseADB = false;
    }

    void startFileParse() {
        this.m_thWatchFile = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                fstream = null;
                in = null;
                br = null;
                try {
                    fstream = new FileInputStream(LogFilterMain.this.m_strLogFileName);
                    in = new DataInputStream(fstream);
                    br = LogFilterMain.this.m_comboEncode.getSelectedItem().equals("UTF-8") != false ? new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8")) : new BufferedReader(new InputStreamReader(in));
                    LogFilterMain.this.setTitle(LogFilterMain.this.m_strLogFileName);
                    LogFilterMain.this.m_arLogInfoAll.clear();
                    LogFilterMain.this.m_arTagInfo.clear();
                    nPreRowCount = 0;
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        Thread.sleep(50L);
                        if (LogFilterMain.this.m_nChangedFilter == 1 || LogFilterMain.this.m_nChangedFilter == 2 || LogFilterMain.this.m_bPauseADB) continue;
                        bEndLine = false;
                        nSelectedIndex = LogFilterMain.this.m_tbLogTable.getSelectedRow();
                        nPreRowCount = LogFilterMain.this.m_tbLogTable.getRowCount();
                        nAddCount = 0;
                        if (nSelectedIndex == -1 || nSelectedIndex == LogFilterMain.this.m_tbLogTable.getRowCount() - 1) {
                            bEndLine = true;
                        }
                        var10_12 = LogFilterMain.this.FILE_LOCK;
                        synchronized (var10_12) {
                            nLine = LogFilterMain.this.m_arLogInfoAll.size() + 1;
                            while (!LogFilterMain.this.m_bPauseADB && (strLine = br.readLine()) != null) {
                                if (strLine == null || "".equals(strLine.trim())) continue;
                                logInfo = LogFilterMain.this.m_iLogParser.parseLog(strLine);
                                logInfo.m_strLine = "" + nLine++;
                                LogFilterMain.this.addLogInfo(logInfo);
                                ++nAddCount;
                            }
                        }
                        if (nAddCount == 0) continue;
                        var10_12 = LogFilterMain.this.FILTER_LOCK;
                        synchronized (var10_12) {
                            if (!LogFilterMain.this.m_bUserFilter) {
                                LogFilterMain.this.m_tmLogTableModel.setData(LogFilterMain.this.m_arLogInfoAll);
                                LogFilterMain.this.m_ipIndicator.setData(LogFilterMain.this.m_arLogInfoAll, LogFilterMain.this.m_hmBookmarkAll, LogFilterMain.this.m_hmErrorAll);
                            } else {
                                LogFilterMain.this.m_tmLogTableModel.setData(LogFilterMain.this.m_arLogInfoFiltered);
                                LogFilterMain.this.m_ipIndicator.setData(LogFilterMain.this.m_arLogInfoFiltered, LogFilterMain.this.m_hmBookmarkFiltered, LogFilterMain.this.m_hmErrorFiltered);
                            }
                            nEndLine = LogFilterMain.this.m_tmLogTableModel.getRowCount();
                            if (nPreRowCount != nEndLine) {
                                if (bEndLine) {
                                    LogFilterMain.this.updateTable(nEndLine - 1, true);
                                } else {
                                    LogFilterMain.this.updateTable(nSelectedIndex, false);
                                }
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    T.e(e);
                    e.printStackTrace();
                    try {
                        if (br != null) {
                            br.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        if (fstream != null) {
                            fstream.close();
                        }
                    }
                    catch (Exception e) {
                        T.e(e);
                    }
                    System.out.println("End m_thWatchFile thread");
                    return;
                }
                {
                    ** while (true)
                }
            }
        });
        this.m_thWatchFile.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runFilter() {
        this.checkUseFilter();
        while (this.m_nChangedFilter == 2) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Object object = this.FILTER_LOCK;
        synchronized (object) {
            this.FILTER_LOCK.notify();
        }
    }

    void startFilterParse() {
        this.m_thFilterParse = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        var1_1 = LogFilterMain.this.FILTER_LOCK;
                        synchronized (var1_1) {
                            LogFilterMain.this.m_nChangedFilter = 4;
                            LogFilterMain.this.FILTER_LOCK.wait();
                            LogFilterMain.this.m_nChangedFilter = 2;
                            LogFilterMain.this.m_arLogInfoFiltered.clear();
                            LogFilterMain.this.m_hmBookmarkFiltered.clear();
                            LogFilterMain.this.m_hmErrorFiltered.clear();
                            LogFilterMain.this.m_tbLogTable.clearSelection();
                            if (!LogFilterMain.this.m_bUserFilter) {
                                LogFilterMain.this.m_tmLogTableModel.setData(LogFilterMain.this.m_arLogInfoAll);
                                LogFilterMain.this.m_ipIndicator.setData(LogFilterMain.this.m_arLogInfoAll, LogFilterMain.this.m_hmBookmarkAll, LogFilterMain.this.m_hmErrorAll);
                                LogFilterMain.this.updateTable(LogFilterMain.this.m_arLogInfoAll.size() - 1, true);
                                LogFilterMain.this.m_nChangedFilter = 4;
                                continue;
                            }
                            LogFilterMain.this.m_tmLogTableModel.setData(LogFilterMain.this.m_arLogInfoFiltered);
                            LogFilterMain.this.m_ipIndicator.setData(LogFilterMain.this.m_arLogInfoFiltered, LogFilterMain.this.m_hmBookmarkFiltered, LogFilterMain.this.m_hmErrorFiltered);
                            LogFilterMain.this.setStatus("Parsing");
                            nRowCount = LogFilterMain.this.m_arLogInfoAll.size();
                            nIndex = 0;
                            while (nIndex < nRowCount) {
                                if (nIndex % 10000 == 0) {
                                    Thread.sleep(1L);
                                }
                                if (LogFilterMain.this.m_nChangedFilter == 1) break;
                                logInfo = LogFilterMain.this.m_arLogInfoAll.get(nIndex);
                                if (LogFilterMain.this.m_ipIndicator.m_chBookmark.isSelected() || LogFilterMain.this.m_ipIndicator.m_chError.isSelected()) {
                                    bAddFilteredArray = false;
                                    if (logInfo.m_bMarked && LogFilterMain.this.m_ipIndicator.m_chBookmark.isSelected()) {
                                        bAddFilteredArray = true;
                                        LogFilterMain.this.m_hmBookmarkFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, LogFilterMain.this.m_arLogInfoFiltered.size());
                                        if (logInfo.m_strLogLV.equals("E") || logInfo.m_strLogLV.equals("ERROR")) {
                                            LogFilterMain.this.m_hmErrorFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, LogFilterMain.this.m_arLogInfoFiltered.size());
                                        }
                                    }
                                    if ((logInfo.m_strLogLV.equals("E") || logInfo.m_strLogLV.equals("ERROR")) && LogFilterMain.this.m_ipIndicator.m_chError.isSelected()) {
                                        bAddFilteredArray = true;
                                        LogFilterMain.this.m_hmErrorFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, LogFilterMain.this.m_arLogInfoFiltered.size());
                                        if (logInfo.m_bMarked) {
                                            LogFilterMain.this.m_hmBookmarkFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, LogFilterMain.this.m_arLogInfoFiltered.size());
                                        }
                                    }
                                    if (bAddFilteredArray) {
                                        LogFilterMain.this.m_arLogInfoFiltered.add(logInfo);
                                    }
                                } else if (LogFilterMain.this.checkLogLVFilter(logInfo) && LogFilterMain.this.checkPidFilter(logInfo) && LogFilterMain.this.checkTidFilter(logInfo) && LogFilterMain.this.checkShowTagFilter(logInfo) && LogFilterMain.this.checkRemoveTagFilter(logInfo) && LogFilterMain.this.checkFindFilter(logInfo) && LogFilterMain.this.checkRemoveFilter(logInfo)) {
                                    LogFilterMain.this.m_arLogInfoFiltered.add(logInfo);
                                    if (logInfo.m_bMarked) {
                                        LogFilterMain.this.m_hmBookmarkFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, LogFilterMain.this.m_arLogInfoFiltered.size());
                                    }
                                    if (logInfo.m_strLogLV.equals("E") || logInfo.m_strLogLV.equals("ERROR")) {
                                        LogFilterMain.this.m_hmErrorFiltered.put(Integer.parseInt(logInfo.m_strLine) - 1, LogFilterMain.this.m_arLogInfoFiltered.size());
                                    }
                                }
                                ++nIndex;
                            }
                            if (LogFilterMain.this.m_nChangedFilter == 2) {
                                LogFilterMain.this.m_nChangedFilter = 4;
                                LogFilterMain.this.m_tmLogTableModel.setData(LogFilterMain.this.m_arLogInfoFiltered);
                                LogFilterMain.this.m_ipIndicator.setData(LogFilterMain.this.m_arLogInfoFiltered, LogFilterMain.this.m_hmBookmarkFiltered, LogFilterMain.this.m_hmErrorFiltered);
                                LogFilterMain.this.updateTable(LogFilterMain.this.m_arLogInfoFiltered.size() - 1, true);
                                LogFilterMain.this.setStatus("Complete");
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    T.e(e);
                    e.printStackTrace();
                    System.out.println("End m_thFilterParse thread");
                    return;
                }
                {
                    ** while (true)
                }
            }
        });
        this.m_thFilterParse.start();
    }

    void startProcess() {
        this.clearData();
        this.m_tbLogTable.clearSelection();
        this.m_thProcess = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String s;
                    LogFilterMain.this.m_Process = null;
                    LogFilterMain.this.setProcessCmd(LogFilterMain.this.m_comboDeviceCmd.getSelectedIndex(), LogFilterMain.this.m_strSelectedDevice);
                    T.d("getProcessCmd() = " + LogFilterMain.this.getProcessCmd());
                    LogFilterMain.this.m_Process = Runtime.getRuntime().exec(LogFilterMain.this.getProcessCmd());
                    BufferedReader stdOut = new BufferedReader(new InputStreamReader(LogFilterMain.this.m_Process.getInputStream(), "UTF-8"));
                    BufferedWriter fileOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(LogFilterMain.this.m_strLogFileName), "UTF-8"));
                    LogFilterMain.this.startFileParse();
                    while ((s = stdOut.readLine()) != null) {
                        if (s == null || "".equals(s.trim())) continue;
                        Object object = LogFilterMain.this.FILE_LOCK;
                        synchronized (object) {
                            fileOut.write(s);
                            fileOut.write("\r\n");
                            ((Writer)fileOut).flush();
                        }
                    }
                    ((Writer)fileOut).close();
                }
                catch (Exception e) {
                    T.e("e = " + e);
                }
                LogFilterMain.this.stopProcess();
            }
        });
        this.m_thProcess.start();
        this.setProcessBtn(true);
    }

    boolean checkLogLVFilter(LogInfo logInfo) {
        if (this.m_nFilterLogLV == 63) {
            return true;
        }
        if ((this.m_nFilterLogLV & 1) != 0 && (logInfo.m_strLogLV.equals("V") || logInfo.m_strLogLV.equals("VERBOSE"))) {
            return true;
        }
        if ((this.m_nFilterLogLV & 2) != 0 && (logInfo.m_strLogLV.equals("D") || logInfo.m_strLogLV.equals("DEBUG"))) {
            return true;
        }
        if ((this.m_nFilterLogLV & 4) != 0 && (logInfo.m_strLogLV.equals("I") || logInfo.m_strLogLV.equals("INFO"))) {
            return true;
        }
        if ((this.m_nFilterLogLV & 8) != 0 && (logInfo.m_strLogLV.equals("W") || logInfo.m_strLogLV.equals("WARN"))) {
            return true;
        }
        if ((this.m_nFilterLogLV & 0x10) != 0 && (logInfo.m_strLogLV.equals("E") || logInfo.m_strLogLV.equals("ERROR"))) {
            return true;
        }
        return (this.m_nFilterLogLV & 0x20) != 0 && (logInfo.m_strLogLV.equals("F") || logInfo.m_strLogLV.equals("FATAL"));
    }

    boolean checkPidFilter(LogInfo logInfo) {
        if (this.m_tbLogTable.GetFilterShowPid().length() <= 0) {
            return true;
        }
        StringTokenizer stk = new StringTokenizer(this.m_tbLogTable.GetFilterShowPid(), "|", false);
        while (stk.hasMoreElements()) {
            if (!logInfo.m_strPid.toLowerCase().contains(stk.nextToken().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    boolean checkTidFilter(LogInfo logInfo) {
        if (this.m_tbLogTable.GetFilterShowTid().length() <= 0) {
            return true;
        }
        StringTokenizer stk = new StringTokenizer(this.m_tbLogTable.GetFilterShowTid(), "|", false);
        while (stk.hasMoreElements()) {
            if (!logInfo.m_strThread.toLowerCase().contains(stk.nextToken().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    boolean checkFindFilter(LogInfo logInfo) {
        if (this.m_tbLogTable.GetFilterFind().length() <= 0) {
            return true;
        }
        StringTokenizer stk = new StringTokenizer(this.m_tbLogTable.GetFilterFind(), "|", false);
        while (stk.hasMoreElements()) {
            if (!logInfo.m_strMessage.toLowerCase().contains(stk.nextToken().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    boolean checkRemoveFilter(LogInfo logInfo) {
        if (this.m_tbLogTable.GetFilterRemove().length() <= 0) {
            return true;
        }
        StringTokenizer stk = new StringTokenizer(this.m_tbLogTable.GetFilterRemove(), "|", false);
        while (stk.hasMoreElements()) {
            if (!logInfo.m_strMessage.toLowerCase().contains(stk.nextToken().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    boolean checkShowTagFilter(LogInfo logInfo) {
        if (this.m_tbLogTable.GetFilterShowTag().length() <= 0) {
            return true;
        }
        StringTokenizer stk = new StringTokenizer(this.m_tbLogTable.GetFilterShowTag(), "|", false);
        while (stk.hasMoreElements()) {
            if (!logInfo.m_strTag.toLowerCase().contains(stk.nextToken().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    boolean checkRemoveTagFilter(LogInfo logInfo) {
        if (this.m_tbLogTable.GetFilterRemoveTag().length() <= 0) {
            return true;
        }
        StringTokenizer stk = new StringTokenizer(this.m_tbLogTable.GetFilterRemoveTag(), "|", false);
        while (stk.hasMoreElements()) {
            if (!logInfo.m_strTag.toLowerCase().contains(stk.nextToken().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    boolean checkUseFilter() {
        this.m_bUserFilter = this.m_ipIndicator.m_chBookmark.isSelected() || this.m_ipIndicator.m_chError.isSelected() || !this.checkLogLVFilter(new LogInfo()) || this.m_tbLogTable.GetFilterShowPid().length() != 0 && this.m_chkEnableShowPid.isSelected() || this.m_tbLogTable.GetFilterShowTid().length() != 0 && this.m_chkEnableShowTid.isSelected() || this.m_tbLogTable.GetFilterShowTag().length() != 0 && this.m_chkEnableShowTag.isSelected() || this.m_tbLogTable.GetFilterRemoveTag().length() != 0 && this.m_chkEnableRemoveTag.isSelected() || this.m_tbLogTable.GetFilterFind().length() != 0 && this.m_chkEnableFind.isSelected() || this.m_tbLogTable.GetFilterRemove().length() != 0 && this.m_chkEnableRemove.isSelected();
        return this.m_bUserFilter;
    }

    @Override
    public void notiEvent(INotiEvent.EventParam param) {
        switch (param.nEventId) {
            case 0: 
            case 1: {
                this.m_nChangedFilter = 1;
                this.runFilter();
                break;
            }
            case 2: {
                this.m_tfShowTag.setText(this.m_tbLogTable.GetFilterShowTag());
                break;
            }
            case 3: {
                this.m_tfRemoveTag.setText(this.m_tbLogTable.GetFilterRemoveTag());
            }
        }
    }

    void updateTable(int nRow, boolean bMove) {
        this.m_tmLogTableModel.fireTableRowsUpdated(0, this.m_tmLogTableModel.getRowCount() - 1);
        this.m_scrollVBar.validate();
        this.m_tbLogTable.invalidate();
        this.m_tbLogTable.repaint();
        if (nRow >= 0) {
            this.m_tbLogTable.changeSelection(nRow, 0, false, false, bMove);
        }
    }

    public void openFileBrowser() {
        FileDialog fd = new FileDialog((Frame)this, "File open", 0);
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.parseFile(new File(String.valueOf(fd.getDirectory()) + fd.getFile()));
            m_recentMenu.addEntry(String.valueOf(fd.getDirectory()) + fd.getFile());
        }
    }
}

