/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.StringTokenizer;

public class LogCatParser
implements ILogParser {
    final String TOKEN_KERNEL = "<>[]";
    final String TOKEN_SPACE = " ";
    final String TOKEN_SLASH = "/";
    final String TOKEN = "/()";
    final String TOKEN_PID = "/() ";
    final String TOKEN_MESSAGE = "'";

    @Override
    public Color getColor(LogInfo logInfo) {
        if (logInfo.m_strLogLV == null) {
            return Color.BLACK;
        }
        if (logInfo.m_strLogLV.equals("FATAL") || logInfo.m_strLogLV.equals("F")) {
            return new Color(LogColor.COLOR_FATAL);
        }
        if (logInfo.m_strLogLV.equals("ERROR") || logInfo.m_strLogLV.equals("E") || logInfo.m_strLogLV.equals("3")) {
            return new Color(LogColor.COLOR_ERROR);
        }
        if (logInfo.m_strLogLV.equals("WARN") || logInfo.m_strLogLV.equals("W") || logInfo.m_strLogLV.equals("4")) {
            return new Color(LogColor.COLOR_WARN);
        }
        if (logInfo.m_strLogLV.equals("INFO") || logInfo.m_strLogLV.equals("I") || logInfo.m_strLogLV.equals("6")) {
            return new Color(LogColor.COLOR_INFO);
        }
        if (logInfo.m_strLogLV.equals("DEBUG") || logInfo.m_strLogLV.equals("D") || logInfo.m_strLogLV.equals("7")) {
            return new Color(LogColor.COLOR_DEBUG);
        }
        if (logInfo.m_strLogLV.equals("0")) {
            return new Color(LogColor.COLOR_0);
        }
        if (logInfo.m_strLogLV.equals("1")) {
            return new Color(LogColor.COLOR_1);
        }
        if (logInfo.m_strLogLV.equals("2")) {
            return new Color(LogColor.COLOR_2);
        }
        if (logInfo.m_strLogLV.equals("5")) {
            return new Color(LogColor.COLOR_5);
        }
        return Color.BLACK;
    }

    @Override
    public int getLogLV(LogInfo logInfo) {
        if (logInfo.m_strLogLV == null) {
            return 1;
        }
        if (logInfo.m_strLogLV.equals("FATAL") || logInfo.m_strLogLV.equals("F")) {
            return 32;
        }
        if (logInfo.m_strLogLV.equals("ERROR") || logInfo.m_strLogLV.equals("E")) {
            return 16;
        }
        if (logInfo.m_strLogLV.equals("WARN") || logInfo.m_strLogLV.equals("W")) {
            return 8;
        }
        if (logInfo.m_strLogLV.equals("INFO") || logInfo.m_strLogLV.equals("I")) {
            return 4;
        }
        if (logInfo.m_strLogLV.equals("DEBUG") || logInfo.m_strLogLV.equals("D")) {
            return 2;
        }
        return 1;
    }

    public boolean isNormal(String strText) {
        if (strText.length() < 22) {
            return false;
        }
        String strLevel = strText.substring(19, 21);
        return strLevel.equals("D/") || strLevel.equals("V/") || strLevel.equals("I/") || strLevel.equals("W/") || strLevel.equals("E/") || strLevel.equals("F/");
    }

    public boolean isThreadTime(String strText) {
        if (strText.length() < 34) {
            return false;
        }
        String strLevel = strText.substring(31, 33);
        return strLevel.equals("D ") || strLevel.equals("V ") || strLevel.equals("I ") || strLevel.equals("W ") || strLevel.equals("E ") || strLevel.equals("F ");
    }

    public boolean isKernel(String strText) {
        if (strText.length() < 18) {
            return false;
        }
        String strLevel = strText.substring(1, 2);
        return strLevel.equals("0") || strLevel.equals("1") || strLevel.equals("2") || strLevel.equals("3") || strLevel.equals("4") || strLevel.equals("5") || strLevel.equals("6") || strLevel.equals("7");
    }

    public LogInfo getNormal(String strText) {
        LogInfo logInfo = new LogInfo();
        StringTokenizer stk = new StringTokenizer(strText, "/() ", false);
        if (stk.hasMoreElements()) {
            logInfo.m_strDate = stk.nextToken();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strTime = stk.nextToken();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strLogLV = stk.nextToken().trim();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strTag = stk.nextToken();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strPid = stk.nextToken().trim();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strMessage = stk.nextToken("'");
            while (stk.hasMoreElements()) {
                logInfo.m_strMessage = String.valueOf(logInfo.m_strMessage) + stk.nextToken("'");
            }
            logInfo.m_strMessage = logInfo.m_strMessage.replaceFirst("\\): ", "");
        }
        logInfo.m_TextColor = this.getColor(logInfo);
        return logInfo;
    }

    public LogInfo getThreadTime(String strText) {
        LogInfo logInfo = new LogInfo();
        StringTokenizer stk = new StringTokenizer(strText, " ", false);
        if (stk.hasMoreElements()) {
            logInfo.m_strDate = stk.nextToken();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strTime = stk.nextToken();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strPid = stk.nextToken().trim();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strThread = stk.nextToken().trim();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strLogLV = stk.nextToken().trim();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strTag = stk.nextToken();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strMessage = stk.nextToken("'");
            while (stk.hasMoreElements()) {
                logInfo.m_strMessage = String.valueOf(logInfo.m_strMessage) + stk.nextToken("'");
            }
            logInfo.m_strMessage = logInfo.m_strMessage.replaceFirst("\\): ", "");
        }
        logInfo.m_TextColor = this.getColor(logInfo);
        return logInfo;
    }

    public LogInfo getKernel(String strText) {
        LogInfo logInfo = new LogInfo();
        StringTokenizer stk = new StringTokenizer(strText, "<>[]", false);
        if (stk.hasMoreElements()) {
            logInfo.m_strLogLV = stk.nextToken();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strTime = stk.nextToken();
        }
        if (stk.hasMoreElements()) {
            logInfo.m_strMessage = stk.nextToken("<>[]");
            while (stk.hasMoreElements()) {
                logInfo.m_strMessage = String.valueOf(logInfo.m_strMessage) + " " + stk.nextToken(" ");
            }
            logInfo.m_strMessage = logInfo.m_strMessage.replaceFirst("  ", "");
        }
        logInfo.m_TextColor = this.getColor(logInfo);
        return logInfo;
    }

    @Override
    public LogInfo parseLog(String strText) {
        if (this.isNormal(strText)) {
            return this.getNormal(strText);
        }
        if (this.isThreadTime(strText)) {
            return this.getThreadTime(strText);
        }
        if (this.isKernel(strText)) {
            return this.getKernel(strText);
        }
        LogInfo logInfo = new LogInfo();
        logInfo.m_strMessage = strText;
        return logInfo;
    }
}

