/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;

public class IndicatorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final int INDICATRO_BOOK_X_POS = 5;
    final int INDICATRO_WIDTH = 12;
    final int INDICATRO_ERROR_X_POS = 23;
    final int INDICATRO_Y_POS = 22;
    final int INDICATRO_Y_GAP = 5;
    Rectangle m_rcBookmark;
    Rectangle m_rcError;
    JCheckBox m_chBookmark;
    JCheckBox m_chError;
    ArrayList<LogInfo> m_arLogInfo;
    HashMap<Integer, Integer> m_hmBookmark;
    HashMap<Integer, Integer> m_hmError;
    Graphics m_g;
    LogFilterMain m_LogFilterMain;
    public boolean m_bDrawFull;
    int PAGE_INDICATOR_WIDTH = 3;
    int PAGE_INDICATOR_GAP = 2;
    ItemListener m_itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource().equals(IndicatorPanel.this.m_chBookmark)) {
                IndicatorPanel.this.m_LogFilterMain.notiEvent(new INotiEvent.EventParam(0));
            } else if (itemEvent.getSource().equals(IndicatorPanel.this.m_chError)) {
                IndicatorPanel.this.m_LogFilterMain.notiEvent(new INotiEvent.EventParam(1));
            }
        }
    };

    public IndicatorPanel(LogFilterMain logFilterMain) {
        this.m_LogFilterMain = logFilterMain;
        this.m_chBookmark = new JCheckBox();
        this.m_chBookmark.addItemListener(this.m_itemListener);
        this.m_chBookmark.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_chError = new JCheckBox();
        this.m_chError.addItemListener(this.m_itemListener);
        this.m_chError.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_rcBookmark = new Rectangle();
        this.m_rcError = new Rectangle();
        this.m_bDrawFull = true;
        this.add(this.m_chBookmark);
        this.add(this.m_chError);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (IndicatorPanel.this.m_arLogInfo != null) {
                    float fRate = (float)(e.getY() - IndicatorPanel.this.m_rcBookmark.y) / (float)IndicatorPanel.this.m_rcBookmark.height;
                    int nIndex = (int)((float)IndicatorPanel.this.m_arLogInfo.size() * fRate);
                    IndicatorPanel.this.m_LogFilterMain.m_tbLogTable.showRow(nIndex, false);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (IndicatorPanel.this.m_arLogInfo != null) {
                    float fRate = (float)(e.getY() - IndicatorPanel.this.m_rcBookmark.y) / (float)IndicatorPanel.this.m_rcBookmark.height;
                    int nIndex = (int)((float)IndicatorPanel.this.m_arLogInfo.size() * fRate);
                    IndicatorPanel.this.m_LogFilterMain.m_tbLogTable.showRow(nIndex, false);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                IndicatorPanel.this.m_LogFilterMain.m_scrollVBar.dispatchEvent(e);
            }
        });
    }

    public void testMsg(String strMsg) {
        JOptionPane.showMessageDialog(this, strMsg);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.m_g = g;
        this.m_rcBookmark.setBounds(5, 22, 12, this.getHeight() - 22 - 5);
        this.m_rcError.setBounds(23, 22, 12, this.getHeight() - 22 - 5);
        if (this.m_bDrawFull) {
            this.drawIndicator(this.m_g);
        }
        this.drawBookmark(this.m_g);
        this.drawError(this.m_g);
        this.drawPageIndicator(this.m_g);
        this.m_bDrawFull = true;
    }

    void drawIndicator(Graphics g) {
        if (this.m_arLogInfo == null) {
            return;
        }
        int TOTAL_COUNT = this.m_arLogInfo.size();
        if (TOTAL_COUNT > 0) {
            int nY2;
            int nY1;
            int HEIGHT = 1;
            int MIN_HEIGHT = 1;
            float fRate = (float)this.m_rcBookmark.height / (float)TOTAL_COUNT;
            if (this.m_rcBookmark.height > TOTAL_COUNT) {
                HEIGHT = this.m_rcBookmark.height / TOTAL_COUNT + 1;
            }
            for (Integer nIndex : this.m_hmBookmark.keySet()) {
                if (this.m_LogFilterMain.m_nChangedFilter == 1 || this.m_LogFilterMain.m_nChangedFilter == 2) break;
                nY1 = (int)(22.0f + (float)this.m_hmBookmark.get(nIndex).intValue() * fRate);
                nY2 = nY1 + HEIGHT;
                if (nY2 - nY1 <= 0) {
                    nY2 = nY1 + MIN_HEIGHT;
                }
                if (nY2 > this.m_rcBookmark.y + this.m_rcBookmark.height) {
                    nY2 = this.m_rcBookmark.y + this.m_rcBookmark.height;
                }
                g.setColor(Color.BLUE);
                g.fillRect(this.m_rcBookmark.x, nY1, this.m_rcBookmark.width, nY2 - nY1);
            }
            for (Integer nIndex : this.m_hmError.keySet()) {
                if (this.m_LogFilterMain.m_nChangedFilter == 1 || this.m_LogFilterMain.m_nChangedFilter == 2) break;
                nY1 = (int)(22.0f + (float)this.m_hmError.get(nIndex).intValue() * fRate);
                nY2 = nY1 + HEIGHT;
                if (nY2 - nY1 <= 0) {
                    nY2 = nY1 + MIN_HEIGHT;
                }
                if (nY2 > this.m_rcError.y + this.m_rcError.height) {
                    nY2 = this.m_rcError.y + this.m_rcError.height;
                }
                g.setColor(Color.RED);
                g.fillRect(this.m_rcError.x, nY1, this.m_rcError.width, nY2 - nY1);
            }
        }
    }

    void drawBookmark(Graphics g) {
        g.setColor(Color.BLUE);
        g.drawRect(this.m_rcBookmark.x, this.m_rcBookmark.y, this.m_rcBookmark.width, this.m_rcBookmark.height);
    }

    void drawError(Graphics g) {
        g.setColor(Color.RED);
        g.drawRect(this.m_rcError.x, this.m_rcError.y, this.m_rcError.width, this.m_rcError.height);
    }

    void drawPageIndicator(Graphics g) {
        if (this.m_arLogInfo == null) {
            return;
        }
        int TOTAL_COUNT = this.m_arLogInfo.size();
        if (TOTAL_COUNT > 0) {
            JViewport viewport = this.m_LogFilterMain.m_scrollVBar.getViewport();
            Rectangle viewRect = viewport.getViewRect();
            int nItemHeight = this.m_LogFilterMain.m_tbLogTable.getRowHeight();
            if (nItemHeight > 0) {
                float fRate = (float)this.m_rcBookmark.height / (float)TOTAL_COUNT;
                int nFirst = this.m_LogFilterMain.m_tbLogTable.rowAtPoint(new Point(0, viewRect.y));
                int nLast = this.m_LogFilterMain.m_tbLogTable.rowAtPoint(new Point(0, viewRect.height - 1));
                int nY1 = (int)((float)this.m_rcBookmark.y + (float)nFirst * fRate);
                int nH = (int)((float)(nLast + 1) * fRate);
                if (nH <= 0) {
                    nH = 1;
                }
                if (nY1 + nH > this.m_rcBookmark.y + this.m_rcBookmark.height) {
                    nH = this.m_rcBookmark.y + this.m_rcBookmark.height - nY1;
                }
                if (nLast == -1) {
                    nH = this.m_rcBookmark.height;
                }
                g.drawRect(this.m_rcBookmark.x - this.PAGE_INDICATOR_WIDTH - this.PAGE_INDICATOR_GAP, nY1, this.PAGE_INDICATOR_WIDTH, nH);
                g.drawRect(this.m_rcError.x + this.m_rcError.width + this.PAGE_INDICATOR_GAP, nY1, this.PAGE_INDICATOR_WIDTH, nH);
            }
        }
    }

    public void setData(ArrayList<LogInfo> arLogInfo, HashMap<Integer, Integer> hmBookmark, HashMap<Integer, Integer> hmError) {
        this.m_arLogInfo = arLogInfo;
        this.m_hmBookmark = hmBookmark;
        this.m_hmError = hmError;
    }
}

