/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.boxing.NotNullBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.NullabilityInterpreter;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

public class RedundantNullCheckMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantNullCheckMethodTransformer", "transform"));
        }
        if (methodNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantNullCheckMethodTransformer", "transform"));
        }
        while (RedundantNullCheckMethodTransformer.removeRedundantNullCheckPass(internalClassName, methodNode)) {
        }
    }

    private static boolean removeRedundantNullCheckPass(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantNullCheckMethodTransformer", "removeRedundantNullCheckPass"));
        }
        if (methodNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantNullCheckMethodTransformer", "removeRedundantNullCheckPass"));
        }
        InsnList insnList = methodNode.instructions;
        Frame<BasicValue>[] frames2 = RedundantNullCheckMethodTransformer.analyze(internalClassName, methodNode, new NullabilityInterpreter(insnList));
        ArrayList<AbstractInsnNode> insnsToOptimize = new ArrayList<AbstractInsnNode>();
        for (int i = 0; i < insnList.size(); ++i) {
            Frame<BasicValue> frame = frames2[i];
            AbstractInsnNode insn = insnList.get(i);
            if (insn.getOpcode() != 198 && insn.getOpcode() != 199 || frame == null || !(frame.getStack(frame.getStackSize() - 1) instanceof NotNullBasicValue)) continue;
            insnsToOptimize.add(insn);
        }
        for (AbstractInsnNode insn : insnsToOptimize) {
            if (insn.getPrevious() != null && insn.getPrevious().getOpcode() == 89) {
                insnList.remove(insn.getPrevious());
            } else {
                insnList.insertBefore(insn, new InsnNode(87));
            }
            assert (insn.getOpcode() == 198 || insn.getOpcode() == 199) : "only IFNULL/IFNONNULL are supported";
            if (insn.getOpcode() == 198) {
                insnList.remove(insn);
                continue;
            }
            insnList.set(insn, new JumpInsnNode(167, ((JumpInsnNode)insn).label));
        }
        return insnsToOptimize.size() > 0;
    }
}

