/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TLongHash;
import gnu.trove.TLongProcedure;

public class TLongHashSet
extends TLongHash {
    public TLongHashSet() {
    }

    public TLongHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public boolean add(long val) {
        int index2 = this.insertionIndex(val);
        if (index2 < 0) {
            return false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = val;
        this._states[index2] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        long[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new long[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            long o = oldSet[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._states[index2] = 1;
        }
    }

    @Override
    public void clear() {
        super.clear();
        long[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            set[i] = 0L;
            states[i] = 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongHashSet)) {
            return false;
        }
        final TLongHashSet that = (TLongHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TLongProcedure(){

            @Override
            public final boolean execute(long value) {
                return that.contains(value);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEach(new TLongProcedure(){

            @Override
            public boolean execute(long value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(value);
                return true;
            }
        });
        sb.append(']');
        sb.insert(0, '[');
        return sb.toString();
    }

    private final class HashProcedure
    implements TLongProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(long key) {
            this.h += TLongHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

