/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Computable<T> {
    public T compute();

    public static abstract class NotNullCachedComputable<T>
    implements Computable<T> {
        private T myValue;

        @NotNull
        protected abstract T internalCompute();

        @Override
        @NotNull
        public final T compute() {
            if (this.myValue == null) {
                this.myValue = this.internalCompute();
            }
            T t = this.myValue;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Computable$NotNullCachedComputable", "compute"));
            }
            return t;
        }
    }

    public static class PredefinedValueComputable<T>
    implements Computable<T> {
        private final T myValue;

        public PredefinedValueComputable(@Nullable T value) {
            this.myValue = value;
        }

        @Override
        public T compute() {
            return this.myValue;
        }
    }
}

