#! /bin/sh
#
# $Id: build-updates.sh 6767 2010-09-18 23:57:05Z NiLuJe $
#

HACKNAME="adqdevkeys"
PKGNAME="adqdevkeys"
PKGVER="0.1"

KINDLE_MODELS="k2 k2i dx dxi dxg k3g k3w k3gb"

for model in ${KINDLE_MODELS} ; do
	# Prepare our files for this specific kindle model...
	ARCH=${PKGNAME}_${PKGVER}_${model}

	# Build install update
	./kindle_update_tool.py m --${model} --sign ${ARCH}_install install.sh developer.keystore

	# Build uninstall update
	./kindle_update_tool.py m --${model} --sign ${ARCH}_uninstall uninstall.sh
done

# Remove custom directory archive
rm -f ${HACKNAME}.tar.gz

# Move our updates :)
mv -f *.bin ../
