-- ********************************************************************
--   
--   SQL file to grant permissions to Quest Central for DB2 users.
--
--   This file contains SQL statements to grant the privileges required
--   by Quest Central for DB2 for DB2 for OS/390 subsystems.
--
--   Before running this file through a SQL Processor, make the
--   following changes.
--
--   C ALL C'%USER%' C'USER' where USER is the authorization ID of
--                             Quest Central for DB2 user.
--
-- ********************************************************************

GRANT SELECT ON TABLE SYSIBM.SYSTABLES TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSCOLDIST TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSUSERAUTH TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSSCHEMAAUTH TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSROUTINEAUTH TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSRESAUTH TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSPLANAUTH TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSPACKAUTH TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSTABAUTH TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSDBAUTH TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSCOLAUTH TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSCONSTDEP TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSRELS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSFOREIGNKEYS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSKEYS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSCHECKS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSCHECKDEP TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSDATABASE TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSTABLESPACE TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSTABLEPART TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSINDEXES TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSINDEXPART TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSPACKAGE TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSPACKDEP TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSPLANDEP TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSDATATYPES TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSROUTINES TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSPARMS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSPLAN TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSTRIGGERS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSSEQUENCES TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSSTOGROUP TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSSYNONYMS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSVIEWS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSVIEWDEP TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSCOLUMNS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.LOCATIONS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSPACKLIST TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSAUXRELS TO %USER%;


-- ********************************************************************
--
--   Space Management
--
-- ********************************************************************

GRANT SELECT ON TABLE SYSIBM.SYSTABSTATS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSINDEXSTATS TO %USER%;

GRANT SELECT ON TABLE SYSIBM.SYSVOLUMES TO %USER%;


-- ***************************************************************************
--
--   Quest Central Repository 
--
-- ***************************************************************************

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCTEMPLATE_REPO200 TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCUTL200_OUTPUT TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCUTL200_TEMPLATES TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.SM_INDEXES TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.SM_INDEXPART TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.SM_TABLEPART TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.SM_TABLES TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCJFI300_INPUT TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCJFI300_OUTPUT TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCBLUEPT_REPO030 TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCBLUEPT_STMT030 TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCREPORT_DETAIL045 TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCREPORT_REPO045 TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCOBJLIST_REPO045 TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCOBJLIST_STMT045 TO %USER%;


-- ********************************************************************
--
--   Quest Central Procedures
--
-- ********************************************************************

GRANT EXECUTE ON PROCEDURE QUEST.QC200EXECUTE_UTIL TO %USER%;

GRANT EXECUTE ON PROCEDURE QUEST.QC200SQLMSG TO %USER%;

GRANT EXECUTE ON PROCEDURE QUEST.QC300JFI TO %USER%;

GRANT EXECUTE ON PROCEDURE QUEST.QC45_OBJLIST_390 TO %USER%;

GRANT EXECUTE ON PROCEDURE QUEST.QC450RETHLQ TO %USER%;


-- ********************************************************************
--
--   Quest Central Functions
--
-- ********************************************************************

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QCVER TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QC200CHECKPDS TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QC200COMMAND TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QC200DSVOLSTATS TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QC200GETVOLUMEINFO TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QC200LISTMEMBER TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QC200STOGROUPVOLS TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QC200SUBSYSINFO TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QC200ZPARM TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QP200DSNCOMMAND TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QP450LOGDATA TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QP450READSDIR TO %USER%;

GRANT EXECUTE ON SPECIFIC FUNCTION QUEST.QP450VOLUTIL TO %USER%;


-- ********************************************************************
--
--   Tables to support above functions/procedures 
--
-- ********************************************************************

GRANT ALL PRIVILEGES ON TABLE QUEST.QC_UTILOBJ TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCRECORD_LOG_0300 TO %USER%;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QCRECORDING_0300 TO %USER%; 

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QPLOGTB TO %USER%; 

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE QUEST.QPVOLTB TO %USER%; 


-- ********************************************************************
--
--   Non-Quest Plans/packages - may not have been bound yet  
--
-- ********************************************************************

GRANT EXECUTE ON PLAN DSNACLI TO %USER%;

