// General

KSFastSpringDisableClickDrag = function() {
	document.onmousedown = function(event) {
		if (event.target.tagName == 'DIV') {
			event.preventDefault();
		}
	}
}

// Form Filling
KSFastSpringSetTextInputValue_forId = function(textValue, identifier) {
	var inputElement = document.getElementById(identifier);
	if (inputElement != null) {
		inputElement.value = textValue;
	};
}


KSFastSpringSetRegion = function(region) {
	var countrySelectElement = document.getElementById('user:country');
	var countryCode = '';
	if (countrySelectElement != null) {
		countrySelectedIndex = countrySelectElement.selectedIndex;
		countryCode = countrySelectElement.options[countrySelectedIndex].value;
	}
	var regionSelectElement = document.getElementById('user:region');
	var regionInputElement = document.getElementById('user:region_custom');
	if (regionSelectElement != null && regionSelectElement.style.display != 'none') {
		var regionIndex = -1;
		var regionsCount = regionSelectElement.options.length;
		var likelyRegionValue = countryCode + '-' + region;
		for (var i = 0; i < regionsCount; i++) {
			var regionOption = regionSelectElement.options[i];
			if (regionOption.value == likelyRegionValue)
				regionIndex = i;
		}
		if (regionIndex != -1)
			regionSelectElement.selectedIndex = regionIndex;
		return regionIndex;
	}
	else if (regionInputElement != null && regionInputElement.style.display != 'none') {
		regionInputElement.value = region;
	}
}

KSFastSpringSetCouponCodePlaceholder = function(placeholderText) {
	// We use jQuery here as the id of the text field has changed on us, so we use something more loose.
	$(".store-order-action-coupon input.store-action-input").each(function(index, element){
																  element.placeholder = placeholderText;
																  });


}

KSFastSpringCreatePlaceholdersFromLabels = function() {
	// Find all labels, get their for attribute, get the element it points to, and
	// set the placeholder for it to the text inside of the label.
	var labels = document.getElementsByTagName("LABEL");
	for (var i = 0; i < labels.length; i++)
	{
		var label = labels[i];
		var id = label.getAttribute("for");
		if (id != null)
		{
			var element = document.getElementById(id);
			if (element != null && element.tagName == "INPUT")
			{
				var placeholderText = label.innerText;
				if (id == "user:company")
				{
					// Special case for company, add (optional)
					placeholderText = placeholderText + " (optional)";
				}
				else if (id == "confirm:card_security_code")
				{
					// Special case for card security code, make it blank.
					placeholderText = "";
				}
				element.placeholder = placeholderText;
			}
		}
	}
	
	// Sepcial case for Region, as the label doesn't point to it.
	var regionElement = document.getElementById("user:region_custom");
	if (regionElement != null && regionElement.placeholder == "")
	{
		regionElement.placeholder = "Region";
	}
}

KSFastSpringCreateAlertsFromCoreMessages = function() {
	var messages = document.getElementsByClassName("core-messages");
	for (var i = 0; i < messages.length; i++)
	{
		var messageElement = messages[i];
		var messageList = [];
		var errorMessages = messageElement.getElementsByClassName("core-message-error");
		for (var j = 0; j < errorMessages.length; j++)
		{
			var errorMessage = errorMessages[j].innerText;
			errorMessage = errorMessage.replace(/(^\s+|\s+$)/g, ''); // trim
			if (errorMessage.length > 0)
				messageList.push(errorMessage);
		}
		if (messageList.length > 0)
		{
			var message = messageList.join("\n");
			alert(message);
		}
	}
	return messages;
}

// Cancel button for backing out of purchase window

KSFastSpringCreateCancelButton = function () {
	$('.store-page-navigation').find('.store-action-list').append($('<li class="store-action-cancel-li"> <span class="store-action store-action-cancel core-js-enabled-inline"> <a class="store-action-command ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only" href="#" onclick="cancelHandler.setShouldCancel_(true); return false;" role="button" aria-disabled="false"><span class="ui-button-text"> <span class="store-action-title">Cancel</span> </span></a> </span> </li>'));
}
