def git_executable_path
  # See where the system thinks git is
  git_exec = `which git`.chomp
  if git_exec == '' || $?.exitstatus != 0
    git_exec = nil
    # if which doesn't know where git is, check the default git install location
    if File.exists? '/usr/local/git/bin/git'
      git_exec = '/usr/local/git/bin/git'
    else
      # see if xcrun exists
      xcrun = `which xcrun`.chomp
      if xcrun == '' || $?.exitstatus != 0 || !xcrun_is_valid()
        git_exec = nil
      else
        # see if xcrun can find git
        git_exec = `xcrun -find git`.chomp
        if git_exec == '' || $?.exitstatus != 0
          git_exec = nil
        end
      end
    end
  elsif `sysctl -n kern.osrelease`.to_i >= 13
    # we're on 10.9 or later
    # check the git binary to see if it's really xcrun git
    # Ideally we'd just use otool directly, but that also requires developer tools
    # So instead let's just check if it's an Apple-signed binary
    `codesign -d -vv "#{git_exec}" 2>&1 | fgrep Identifier=com.apple.git`
    if $?.exitstatus == 0
      # it's Apple-signed and therefore, presumably, xcrun. Is it valid?
      git_exec = nil unless xcrun_is_valid()
    end
  end
  # If git_exec is nil exit
  if git_exec == nil
    $stderr.puts "Could not locate git. Is it installed?"
    exit 201
  end
  git_exec
end

def xcrun_is_valid
  # ensure that xcode_select has a valid developer dir
  xcselect = `which xcode-select`
  if xcselect == '' || $?.exitstatus != 0
    return false
  end
  `xcode-select --print-path`
  return $?.exitstatus == 0
end
