/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import com.zeroturnaround.bundled.org.slf4j.Logger;
import com.zeroturnaround.bundled.org.slf4j.LoggerFactory;
import com.zeroturnaround.javarebel.dh;
import com.zeroturnaround.javarebel.dj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.FileUtil;
import org.zeroturnaround.zip.IdentityNameMapper;
import org.zeroturnaround.zip.NameMapper;
import org.zeroturnaround.zip.ZipBreakException;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipException;
import org.zeroturnaround.zip.ZipInfoCallback;
import org.zeroturnaround.zip.ZipUtil$1;
import org.zeroturnaround.zip.ZipUtil$2;
import org.zeroturnaround.zip.ZipUtil$3;
import org.zeroturnaround.zip.ZipUtil$4;
import org.zeroturnaround.zip.ZipUtil$ByteArrayUnpacker;
import org.zeroturnaround.zip.ZipUtil$FileUnpacker;
import org.zeroturnaround.zip.ZipUtil$RepackZipEntryCallback;
import org.zeroturnaround.zip.ZipUtil$SingleZipEntryCallback;
import org.zeroturnaround.zip.ZipUtil$TransformerZipEntryCallback;
import org.zeroturnaround.zip.ZipUtil$Unpacker;
import org.zeroturnaround.zip.transform.ZipEntryTransformer;
import org.zeroturnaround.zip.transform.ZipEntryTransformerEntry;

public final class ZipUtil {
    public static final int DEFAULT_COMPRESSION_LEVEL = -1;
    private static final Logger log = LoggerFactory.getLogger(class$org$zeroturnaround$zip$ZipUtil == null ? (class$org$zeroturnaround$zip$ZipUtil = ZipUtil.class$("org.zeroturnaround.zip.ZipUtil")) : class$org$zeroturnaround$zip$ZipUtil);
    static Class class$org$zeroturnaround$zip$ZipUtil;

    private ZipUtil() {
    }

    public static boolean containsEntry(File file, String string) {
        boolean bl2;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            bl2 = zipFile.getEntry(string) != null;
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zipFile);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zipFile);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsAnyEntry(File file, String[] stringArray) {
        boolean bl2;
        ZipFile zipFile;
        block6: {
            int n2;
            zipFile = null;
            try {
                zipFile = new ZipFile(file);
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (zipFile.getEntry(stringArray[n2]) == null) continue;
                    bl2 = true;
                    break block6;
                }
                n2 = 0;
            }
            catch (IOException iOException) {
                try {
                    throw ZipUtil.rethrow(iOException);
                }
                catch (Throwable throwable) {
                    ZipUtil.closeQuietly(zipFile);
                    throw throwable;
                }
            }
            ZipUtil.closeQuietly(zipFile);
            return n2 != 0;
        }
        ZipUtil.closeQuietly(zipFile);
        return bl2;
    }

    public static byte[] unpackEntry(File file, String string) {
        byte[] byArray;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            byArray = ZipUtil.doUnpackEntry(zipFile, string);
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zipFile);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zipFile);
        return byArray;
    }

    public static byte[] unpackEntry(ZipFile zipFile, String string) {
        try {
            return ZipUtil.doUnpackEntry(zipFile, string);
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doUnpackEntry(ZipFile zipFile, String string) throws IOException {
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        try {
            byte[] byArray = dj.a(inputStream);
            return byArray;
        }
        finally {
            dj.a(inputStream);
        }
    }

    public static byte[] unpackEntry(InputStream inputStream, String string) {
        ZipUtil$ByteArrayUnpacker zipUtil$ByteArrayUnpacker = new ZipUtil$ByteArrayUnpacker(null);
        if (!ZipUtil.handle(inputStream, string, (ZipEntryCallback)zipUtil$ByteArrayUnpacker)) {
            return null;
        }
        return zipUtil$ByteArrayUnpacker.getBytes();
    }

    public static boolean unpackEntry(File file, String string, File file2) {
        boolean bl2;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            bl2 = ZipUtil.doUnpackEntry(zipFile, string, file2);
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zipFile);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zipFile);
        return bl2;
    }

    public static boolean unpackEntry(ZipFile zipFile, String string, File file) {
        try {
            return ZipUtil.doUnpackEntry(zipFile, string, file);
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doUnpackEntry(ZipFile zipFile, String string, File file) throws IOException {
        ZipEntry zipEntry;
        if (log.isTraceEnabled()) {
            log.trace("Extracting '" + zipFile.getName() + "' entry '" + string + "' into '" + file + "'.");
        }
        if ((zipEntry = zipFile.getEntry(string)) == null) {
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
        try {
            FileUtil.copy(bufferedInputStream, file);
        }
        finally {
            dj.a(bufferedInputStream);
        }
        return true;
    }

    public static boolean unpackEntry(InputStream inputStream, String string, File file) throws IOException {
        return ZipUtil.handle(inputStream, string, (ZipEntryCallback)new ZipUtil$FileUnpacker(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterate(File file, ZipEntryCallback zipEntryCallback) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    zipEntryCallback.process(inputStream, zipEntry);
                }
                catch (ZipBreakException zipBreakException) {
                    break;
                }
                finally {
                    dj.a(inputStream);
                }
            }
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zipFile);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zipFile);
    }

    public static void iterate(File file, ZipInfoCallback zipInfoCallback) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                try {
                    zipInfoCallback.process(zipEntry);
                }
                catch (ZipBreakException zipBreakException) {
                }
            }
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zipFile);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zipFile);
    }

    public static void iterate(InputStream inputStream, ZipEntryCallback zipEntryCallback) {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                try {
                    zipEntryCallback.process(zipInputStream, zipEntry);
                }
                catch (ZipBreakException zipBreakException) {
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handle(File file, String string, ZipEntryCallback zipEntryCallback) {
        boolean bl2;
        ZipEntry zipEntry;
        ZipFile zipFile;
        block8: {
            zipFile = null;
            zipFile = new ZipFile(file);
            zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) break block8;
            boolean bl3 = false;
            ZipUtil.closeQuietly(zipFile);
            return bl3;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            try {
                zipEntryCallback.process(bufferedInputStream, zipEntry);
            }
            finally {
                dj.a(bufferedInputStream);
            }
            bl2 = true;
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zipFile);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zipFile);
        return bl2;
    }

    public static boolean handle(InputStream inputStream, String string, ZipEntryCallback zipEntryCallback) {
        ZipUtil$SingleZipEntryCallback zipUtil$SingleZipEntryCallback = new ZipUtil$SingleZipEntryCallback(string, zipEntryCallback);
        ZipUtil.iterate(inputStream, (ZipEntryCallback)zipUtil$SingleZipEntryCallback);
        return zipUtil$SingleZipEntryCallback.found();
    }

    public static void unpack(File file, File file2) {
        ZipUtil.unpack(file, file2, IdentityNameMapper.INSTANCE);
    }

    public static void unpack(File file, File file2, NameMapper nameMapper) {
        log.debug("Extracting '{}' into '{}'.", file, (Object)file2);
        ZipUtil.iterate(file, (ZipEntryCallback)new ZipUtil$Unpacker(file2, nameMapper));
    }

    public static void unpack(InputStream inputStream, File file) {
        ZipUtil.unpack(inputStream, file, IdentityNameMapper.INSTANCE);
    }

    public static void unpack(InputStream inputStream, File file, NameMapper nameMapper) {
        log.debug("Extracting {} into '{}'.", inputStream, (Object)file);
        ZipUtil.iterate(inputStream, (ZipEntryCallback)new ZipUtil$Unpacker(file, nameMapper));
    }

    public static void explode(File file) {
        try {
            File file2 = FileUtil.getTempFileFor(file);
            dh.b(file, file2);
            ZipUtil.unpack(file2, file);
            if (!file2.delete()) {
                throw new IOException("Unable to delete file: " + file2);
            }
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] packEntry(File file) {
        log.trace("Compressing '{}' into a ZIP file with single entry.", file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            ZipEntry zipEntry = new ZipEntry(file.getName());
            zipEntry.setTime(file.lastModified());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                ZipUtil.addEntry(zipEntry, bufferedInputStream, zipOutputStream);
            }
            finally {
                dj.a(bufferedInputStream);
            }
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void pack(File file, File file2) {
        ZipUtil.pack(file, file2, -1);
    }

    public static void pack(File file, File file2, int n2) {
        ZipUtil.pack(file, file2, IdentityNameMapper.INSTANCE, n2);
    }

    public static void pack(File file, File file2, boolean bl2) {
        if (bl2) {
            String string = file.getName();
            ZipUtil.pack(file, file2, new ZipUtil$1(string));
        } else {
            ZipUtil.pack(file, file2);
        }
    }

    public static void packEntry(File file, File file2) {
        ZipUtil.packEntries(new File[]{file}, file2);
    }

    public static void packEntries(File[] fileArray, File file) {
        log.debug("Compressing '{}' into '{}'.", fileArray, (Object)file);
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                File file2 = fileArray[i2];
                ZipEntry zipEntry = new ZipEntry(file2.getName());
                zipEntry.setSize(file2.length());
                zipEntry.setTime(file2.lastModified());
                zipOutputStream.putNextEntry(zipEntry);
                FileUtil.copy(file2, zipOutputStream);
                zipOutputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                dj.a(zipOutputStream);
                dj.a(fileOutputStream);
                throw throwable;
            }
        }
        dj.a(zipOutputStream);
        dj.a(fileOutputStream);
    }

    public static void pack(File file, File file2, NameMapper nameMapper) {
        ZipUtil.pack(file, file2, nameMapper, -1);
    }

    public static void pack(File file, File file2, NameMapper nameMapper, int n2) {
        log.debug("Compressing '{}' into '{}'.", file, (Object)file2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            if (!file.exists()) {
                throw new ZipException("Given file '" + file + "' doesn't exist!");
            }
            throw new ZipException("Given file '" + file + "' is not a directory!");
        }
        if (fileArray.length == 0) {
            throw new ZipException("Given directory '" + file + "' doesn't contain any files!");
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            zipOutputStream.setLevel(n2);
            ZipUtil.pack(file, zipOutputStream, nameMapper, "");
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                dj.a(zipOutputStream);
                throw throwable;
            }
        }
        dj.a(zipOutputStream);
    }

    private static void pack(File file, ZipOutputStream zipOutputStream, NameMapper nameMapper, String string) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Given file is not a directory '" + file + "'");
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String string2;
            File file2 = fileArray[i2];
            boolean bl2 = file2.isDirectory();
            String string3 = string + file2.getName();
            if (bl2) {
                string3 = string3 + "/";
            }
            if ((string2 = nameMapper.map(string3)) != null) {
                ZipEntry zipEntry = new ZipEntry(string2);
                if (!bl2) {
                    zipEntry.setSize(file2.length());
                    zipEntry.setTime(file2.lastModified());
                }
                zipOutputStream.putNextEntry(zipEntry);
                if (!bl2) {
                    FileUtil.copy(file2, zipOutputStream);
                }
                zipOutputStream.closeEntry();
            }
            if (!bl2) continue;
            ZipUtil.pack(file2, zipOutputStream, nameMapper, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repack(File file, File file2, int n2) {
        log.debug("Repacking '{}' into '{}'.", file, (Object)file2);
        ZipUtil$RepackZipEntryCallback zipUtil$RepackZipEntryCallback = new ZipUtil$RepackZipEntryCallback(file2, n2, null);
        try {
            ZipUtil.iterate(file, (ZipEntryCallback)zipUtil$RepackZipEntryCallback);
        }
        finally {
            ZipUtil$RepackZipEntryCallback.access$300(zipUtil$RepackZipEntryCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repack(InputStream inputStream, File file, int n2) {
        log.debug("Repacking from input stream into '{}'.", file);
        ZipUtil$RepackZipEntryCallback zipUtil$RepackZipEntryCallback = new ZipUtil$RepackZipEntryCallback(file, n2, null);
        try {
            ZipUtil.iterate(inputStream, (ZipEntryCallback)zipUtil$RepackZipEntryCallback);
        }
        finally {
            ZipUtil$RepackZipEntryCallback.access$300(zipUtil$RepackZipEntryCallback);
        }
    }

    public static void repack(File file, int n2) {
        try {
            File file2 = FileUtil.getTempFileFor(file);
            ZipUtil.repack(file, file2, n2);
            if (!file.delete()) {
                throw new IOException("Unable to delete the file: " + file);
            }
            dh.b(file2, file);
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
    }

    public static void unexplode(File file) {
        ZipUtil.unexplode(file, -1);
    }

    public static void unexplode(File file, int n2) {
        try {
            File file2 = FileUtil.getTempFileFor(file);
            ZipUtil.pack(file, file2, n2);
            dh.a(file);
            dh.b(file2, file);
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
    }

    public static void pack(ZipEntrySource[] zipEntrySourceArray, File file) {
        log.debug("Creating '{}' from {}.", file, Arrays.asList(zipEntrySourceArray));
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            for (int i2 = 0; i2 < zipEntrySourceArray.length; ++i2) {
                ZipUtil.addEntry(zipEntrySourceArray[i2], zipOutputStream);
            }
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                dj.a(zipOutputStream);
                throw throwable;
            }
        }
        dj.a(zipOutputStream);
    }

    public static void addEntry(File file, String string, File file2, File file3) {
        ZipUtil.addEntry(file, new FileSource(string, file2), file3);
    }

    public static void addEntry(File file, String string, byte[] byArray, File file2) {
        ZipUtil.addEntry(file, new ByteSource(string, byArray), file2);
    }

    public static void addEntry(File file, ZipEntrySource zipEntrySource, File file2) {
        ZipUtil.addEntries(file, new ZipEntrySource[]{zipEntrySource}, file2);
    }

    public static void addEntries(File file, ZipEntrySource[] zipEntrySourceArray, File file2) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + file + "' to '" + file2 + "' and adding " + Arrays.asList(zipEntrySourceArray) + ".");
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            ZipUtil.copyEntries(file, zipOutputStream);
            for (int i2 = 0; i2 < zipEntrySourceArray.length; ++i2) {
                ZipUtil.addEntry(zipEntrySourceArray[i2], zipOutputStream);
            }
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                dj.a(zipOutputStream);
                throw throwable;
            }
        }
        dj.a(zipOutputStream);
    }

    private static void copyEntries(File file, ZipOutputStream zipOutputStream) {
        HashSet hashSet = new HashSet();
        ZipUtil.iterate(file, (ZipEntryCallback)new ZipUtil$2(hashSet, zipOutputStream));
    }

    public static boolean replaceEntry(File file, String string, File file2, File file3) {
        return ZipUtil.replaceEntry(file, new FileSource(string, file2), file3);
    }

    public static boolean replaceEntry(File file, String string, byte[] byArray, File file2) {
        return ZipUtil.replaceEntry(file, new ByteSource(string, byArray), file2);
    }

    public static boolean replaceEntry(File file, ZipEntrySource zipEntrySource, File file2) {
        return ZipUtil.replaceEntries(file, new ZipEntrySource[]{zipEntrySource}, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceEntries(File file, ZipEntrySource[] zipEntrySourceArray, File file2) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + file + "' to '" + file2 + "' and replacing entries " + Arrays.asList(zipEntrySourceArray) + ".");
        }
        Map map = ZipUtil.byPath(zipEntrySourceArray);
        int n2 = map.size();
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            try {
                HashSet hashSet = new HashSet();
                ZipUtil.iterate(file, (ZipEntryCallback)new ZipUtil$3(hashSet, map, zipOutputStream));
            }
            finally {
                dj.a(zipOutputStream);
            }
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
        return map.size() < n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrReplaceEntries(File file, ZipEntrySource[] zipEntrySourceArray, File file2) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + file + "' to '" + file2 + "' and adding/replacing entries " + Arrays.asList(zipEntrySourceArray) + ".");
        }
        Map map = ZipUtil.byPath(zipEntrySourceArray);
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            try {
                HashSet hashSet = new HashSet();
                ZipUtil.iterate(file, (ZipEntryCallback)new ZipUtil$4(hashSet, map, zipOutputStream));
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    ZipUtil.addEntry((ZipEntrySource)iterator.next(), zipOutputStream);
                }
            }
            finally {
                dj.a(zipOutputStream);
            }
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
    }

    private static Map byPath(ZipEntrySource[] zipEntrySourceArray) {
        HashMap<String, ZipEntrySource> hashMap = new HashMap<String, ZipEntrySource>();
        for (int i2 = 0; i2 < zipEntrySourceArray.length; ++i2) {
            ZipEntrySource zipEntrySource = zipEntrySourceArray[i2];
            hashMap.put(zipEntrySource.getPath(), zipEntrySource);
        }
        return hashMap;
    }

    public static boolean transformEntry(File file, String string, ZipEntryTransformer zipEntryTransformer, File file2) {
        return ZipUtil.transformEntry(file, new ZipEntryTransformerEntry(string, zipEntryTransformer), file2);
    }

    public static boolean transformEntry(File file, ZipEntryTransformerEntry zipEntryTransformerEntry, File file2) {
        return ZipUtil.transformEntries(file, new ZipEntryTransformerEntry[]{zipEntryTransformerEntry}, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean transformEntries(File file, ZipEntryTransformerEntry[] zipEntryTransformerEntryArray, File file2) {
        boolean bl2;
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + file + "' to '" + file2 + "' and transforming entries " + Arrays.asList(zipEntryTransformerEntryArray) + ".");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        try {
            ZipUtil$TransformerZipEntryCallback zipUtil$TransformerZipEntryCallback = new ZipUtil$TransformerZipEntryCallback(zipEntryTransformerEntryArray, zipOutputStream);
            ZipUtil.iterate(file, (ZipEntryCallback)zipUtil$TransformerZipEntryCallback);
            bl2 = zipUtil$TransformerZipEntryCallback.found();
        }
        catch (Throwable throwable) {
            try {
                dj.a(zipOutputStream);
                throw throwable;
            }
            catch (IOException iOException) {
                throw ZipUtil.rethrow(iOException);
            }
        }
        dj.a(zipOutputStream);
        return bl2;
    }

    public static boolean transformEntry(InputStream inputStream, String string, ZipEntryTransformer zipEntryTransformer, OutputStream outputStream) {
        return ZipUtil.transformEntry(inputStream, new ZipEntryTransformerEntry(string, zipEntryTransformer), outputStream);
    }

    public static boolean transformEntry(InputStream inputStream, ZipEntryTransformerEntry zipEntryTransformerEntry, OutputStream outputStream) {
        return ZipUtil.transformEntries(inputStream, new ZipEntryTransformerEntry[]{zipEntryTransformerEntry}, outputStream);
    }

    public static boolean transformEntries(InputStream inputStream, ZipEntryTransformerEntry[] zipEntryTransformerEntryArray, OutputStream outputStream) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + inputStream + "' to '" + outputStream + "' and transforming entries " + Arrays.asList(zipEntryTransformerEntryArray) + ".");
        }
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            ZipUtil$TransformerZipEntryCallback zipUtil$TransformerZipEntryCallback = new ZipUtil$TransformerZipEntryCallback(zipEntryTransformerEntryArray, zipOutputStream);
            ZipUtil.iterate(inputStream, (ZipEntryCallback)zipUtil$TransformerZipEntryCallback);
            zipOutputStream.finish();
            return zipUtil$TransformerZipEntryCallback.found();
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
    }

    private static Map byPath(ZipEntryTransformerEntry[] zipEntryTransformerEntryArray) {
        HashMap<String, ZipEntryTransformer> hashMap = new HashMap<String, ZipEntryTransformer>();
        for (int i2 = 0; i2 < zipEntryTransformerEntryArray.length; ++i2) {
            ZipEntryTransformerEntry zipEntryTransformerEntry = zipEntryTransformerEntryArray[i2];
            hashMap.put(zipEntryTransformerEntry.getPath(), zipEntryTransformerEntry.getTransformer());
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(ZipEntrySource zipEntrySource, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(zipEntrySource.getEntry());
        InputStream inputStream = zipEntrySource.getInputStream();
        if (inputStream != null) {
            try {
                dj.a(inputStream, (OutputStream)zipOutputStream);
            }
            finally {
                dj.a(inputStream);
            }
        }
        zipOutputStream.closeEntry();
    }

    private static void addEntry(ZipEntry zipEntry, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(zipEntry);
        if (inputStream != null) {
            dj.a(inputStream, (OutputStream)zipOutputStream);
        }
        zipOutputStream.closeEntry();
    }

    private static void copyEntry(ZipEntry zipEntry, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setTime(zipEntry.getTime());
        ZipUtil.addEntry(zipEntry2, new BufferedInputStream(inputStream), zipOutputStream);
    }

    public static boolean archiveEquals(File file, File file2) {
        try {
            if (dh.a(file, file2)) {
                return true;
            }
            log.debug("Comparing archives '{}' and '{}'...", file, (Object)file2);
            long l2 = System.currentTimeMillis();
            boolean bl2 = ZipUtil.archiveEqualsInternal(file, file2);
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > 0L) {
                log.debug("Archives compared in " + l3 + " ms.");
            }
            return bl2;
        }
        catch (Exception exception) {
            log.debug("Could not compare '" + file + "' and '" + file2 + "':", exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean archiveEqualsInternal(File file, File file2) throws IOException {
        boolean bl2;
        ZipEntry zipEntry;
        String string;
        ZipEntry zipEntry2;
        ZipFile zipFile;
        ZipFile zipFile2;
        block8: {
            zipFile2 = null;
            zipFile = null;
            zipFile2 = new ZipFile(file);
            zipFile = new ZipFile(file2);
            if (zipFile2.size() == zipFile.size()) break block8;
            log.debug("Number of entries changed (" + zipFile2.size() + " vs " + zipFile.size() + ").");
            boolean bl3 = false;
            ZipUtil.closeQuietly(zipFile2);
            ZipUtil.closeQuietly(zipFile);
            return bl3;
        }
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile2.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry2 = enumeration.nextElement();
                string = zipEntry2.getName();
                if (ZipUtil.metaDataEquals(string, zipEntry2, zipEntry = zipFile.getEntry(string))) break block9;
                bl2 = false;
            }
        }
        catch (Throwable throwable) {
            ZipUtil.closeQuietly(zipFile2);
            ZipUtil.closeQuietly(zipFile);
            throw throwable;
        }
        {
            InputStream inputStream;
            InputStream inputStream2;
            block10: {
                block9: {
                    ZipUtil.closeQuietly(zipFile2);
                    ZipUtil.closeQuietly(zipFile);
                    return bl2;
                }
                inputStream2 = null;
                inputStream = null;
                inputStream2 = zipFile2.getInputStream(zipEntry2);
                inputStream = zipFile.getInputStream(zipEntry);
                if (dj.a(inputStream2, inputStream)) break block10;
                log.debug("Entry '{}' content changed.", (Object)string);
                boolean bl4 = false;
                dj.a(inputStream2);
                dj.a(inputStream);
                ZipUtil.closeQuietly(zipFile2);
                ZipUtil.closeQuietly(zipFile);
                return bl4;
            }
            dj.a(inputStream2);
            dj.a(inputStream);
            continue;
            {
                catch (Throwable throwable) {
                    dj.a(inputStream2);
                    dj.a(inputStream);
                    throw throwable;
                }
            }
        }
        ZipUtil.closeQuietly(zipFile2);
        ZipUtil.closeQuietly(zipFile);
        log.debug("Archives are the same.");
        return true;
    }

    private static boolean metaDataEquals(String string, ZipEntry zipEntry, ZipEntry zipEntry2) throws IOException {
        if (zipEntry2 == null) {
            log.debug("Entry '{}' removed.", (Object)string);
            return false;
        }
        if (zipEntry.isDirectory()) {
            if (zipEntry2.isDirectory()) {
                return true;
            }
            log.debug("Entry '{}' not a directory any more.", (Object)string);
            return false;
        }
        if (zipEntry2.isDirectory()) {
            log.debug("Entry '{}' now a directory.", (Object)string);
            return false;
        }
        long l2 = zipEntry.getSize();
        long l3 = zipEntry2.getSize();
        if (l2 != -1L && l3 != -1L && l2 != l3) {
            log.debug("Entry '" + string + "' size changed (" + l2 + " vs " + l3 + ").");
            return false;
        }
        long l4 = zipEntry.getCrc();
        long l5 = zipEntry2.getCrc();
        if (l4 != -1L && l5 != -1L && l4 != l5) {
            log.debug("Entry '" + string + "' CRC changed (" + l4 + " vs " + l5 + ").");
            return false;
        }
        if (log.isTraceEnabled()) {
            long l6 = zipEntry.getTime();
            long l7 = zipEntry2.getTime();
            if (l6 != -1L && l7 != -1L && l6 != l7) {
                log.trace("Entry '" + string + "' time changed (" + new Date(l6) + " vs " + new Date(l7) + ").");
            }
        }
        return true;
    }

    public static boolean entryEquals(File file, File file2, String string) {
        return ZipUtil.entryEquals(file, file2, string, string);
    }

    public static boolean entryEquals(File file, File file2, String string, String string2) {
        boolean bl2;
        ZipFile zipFile = null;
        ZipFile zipFile2 = null;
        try {
            zipFile = new ZipFile(file);
            zipFile2 = new ZipFile(file2);
            bl2 = ZipUtil.doEntryEquals(zipFile, zipFile2, string, string2);
        }
        catch (IOException iOException) {
            try {
                throw ZipUtil.rethrow(iOException);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zipFile);
                ZipUtil.closeQuietly(zipFile2);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zipFile);
        ZipUtil.closeQuietly(zipFile2);
        return bl2;
    }

    public static boolean entryEquals(ZipFile zipFile, ZipFile zipFile2, String string, String string2) {
        try {
            return ZipUtil.doEntryEquals(zipFile, zipFile2, string, string2);
        }
        catch (IOException iOException) {
            throw ZipUtil.rethrow(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doEntryEquals(ZipFile zipFile, ZipFile zipFile2, String string, String string2) throws IOException {
        InputStream inputStream;
        InputStream inputStream2;
        block9: {
            block8: {
                ZipEntry zipEntry;
                ZipEntry zipEntry2;
                block7: {
                    block6: {
                        boolean bl2;
                        inputStream2 = null;
                        inputStream = null;
                        try {
                            zipEntry2 = zipFile.getEntry(string);
                            zipEntry = zipFile2.getEntry(string2);
                            if (zipEntry2 != null || zipEntry != null) break block6;
                            bl2 = true;
                        }
                        catch (Throwable throwable) {
                            dj.a(inputStream2);
                            dj.a(inputStream);
                            throw throwable;
                        }
                        dj.a(inputStream2);
                        dj.a(inputStream);
                        return bl2;
                    }
                    if (zipEntry2 != null && zipEntry != null) break block7;
                    boolean bl3 = false;
                    dj.a(inputStream2);
                    dj.a(inputStream);
                    return bl3;
                }
                inputStream2 = zipFile.getInputStream(zipEntry2);
                inputStream = zipFile2.getInputStream(zipEntry);
                if (inputStream2 != null || inputStream != null) break block8;
                boolean bl4 = true;
                dj.a(inputStream2);
                dj.a(inputStream);
                return bl4;
            }
            if (inputStream2 != null && inputStream != null) break block9;
            boolean bl5 = false;
            dj.a(inputStream2);
            dj.a(inputStream);
            return bl5;
        }
        boolean bl6 = dj.a(inputStream2, inputStream);
        dj.a(inputStream2);
        dj.a(inputStream);
        return bl6;
    }

    public static void closeQuietly(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static ZipException rethrow(IOException iOException) {
        throw new ZipException(iOException);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static Logger access$100() {
        return log;
    }

    static ZipException access$400(IOException iOException) {
        return ZipUtil.rethrow(iOException);
    }

    static void access$500(ZipEntry zipEntry, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        ZipUtil.copyEntry(zipEntry, inputStream, zipOutputStream);
    }

    static void access$600(ZipEntrySource zipEntrySource, ZipOutputStream zipOutputStream) throws IOException {
        ZipUtil.addEntry(zipEntrySource, zipOutputStream);
    }

    static Map access$700(ZipEntryTransformerEntry[] zipEntryTransformerEntryArray) {
        return ZipUtil.byPath(zipEntryTransformerEntryArray);
    }
}

