/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.zeroturnaround.zip.ZipEntrySource;

public class FileSource
implements ZipEntrySource {
    private final String path;
    private final File file;

    public FileSource(String string, File file) {
        this.path = string;
        this.file = file;
    }

    public String getPath() {
        return this.path;
    }

    public ZipEntry getEntry() {
        ZipEntry zipEntry = new ZipEntry(this.path);
        if (!this.file.isDirectory()) {
            zipEntry.setSize(this.file.length());
        }
        zipEntry.setTime(this.file.lastModified());
        return zipEntry;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file.isDirectory()) {
            return null;
        }
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public String toString() {
        return "FileSource[" + this.path + ", " + this.file + "]";
    }
}

