/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.zeroturnaround.zip.ZipEntrySource;

public class ByteSource
implements ZipEntrySource {
    private final String path;
    private final byte[] bytes;
    private final long time;

    public ByteSource(String string, byte[] byArray) {
        this(string, byArray, System.currentTimeMillis());
    }

    public ByteSource(String string, byte[] byArray, long l2) {
        this.path = string;
        this.bytes = (byte[])byArray.clone();
        this.time = l2;
    }

    public String getPath() {
        return this.path;
    }

    public ZipEntry getEntry() {
        ZipEntry zipEntry = new ZipEntry(this.path);
        if (this.bytes != null) {
            zipEntry.setSize(this.bytes.length);
        }
        zipEntry.setTime(this.time);
        return zipEntry;
    }

    public InputStream getInputStream() throws IOException {
        if (this.bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.bytes);
    }

    public String toString() {
        return "ByteSource[" + this.path + "]";
    }
}

