/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class URLResource
implements Resource {
    private final URL url;
    private boolean initialized = false;
    private File file;
    private String entry;

    public URLResource(URL uRL) {
        this.url = uRL;
    }

    public URL toURL() {
        return this.url;
    }

    public String toString() {
        return this.url.toString();
    }

    private synchronized void checkInitialized() {
        if (!this.initialized) {
            try {
                URL uRL;
                if (ResourceUtils.isJarURL(this.url) && ResourceUtils.isFileURL(uRL = ResourceUtils.extractJarFileURL(this.url))) {
                    this.file = ResourceUtils.getFile(uRL);
                    this.entry = ResourceUtils.extractJarEntryPath(this.url);
                }
            }
            catch (Exception exception) {
                this.file = null;
                LoggerFactory.getInstance().error(exception);
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        this.checkInitialized();
        JarFile jarFile = null;
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        try {
            Object object;
            if (this.file != null) {
                jarFile = new JarFile(this.file);
                object = jarFile.getJarEntry(this.entry);
                if (object == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                inputStream = jarFile.getInputStream((ZipEntry)object);
            } else {
                uRLConnection = this.url.openConnection();
                uRLConnection.setUseCaches(false);
                uRLConnection.connect();
                inputStream = uRLConnection.getInputStream();
            }
            object = URLResource.getBytes(inputStream);
            return object;
        }
        catch (IOException iOException) {
            LoggerFactory.getInstance().error(iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                LoggerFactory.getInstance().error(iOException);
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                LoggerFactory.getInstance().error(iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastModified() {
        this.checkInitialized();
        URLConnection uRLConnection = null;
        try {
            if (this.file != null) {
                long l2 = this.file.lastModified();
                return l2;
            }
            uRLConnection = this.url.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.connect();
            long l3 = uRLConnection.getLastModified();
            return l3;
        }
        catch (IOException iOException) {
            LoggerFactory.getInstance().error(iOException);
        }
        finally {
            try {
                if (uRLConnection != null && uRLConnection.getInputStream() != null) {
                    uRLConnection.getInputStream().close();
                }
            }
            catch (IOException iOException) {
                LoggerFactory.getInstance().error(iOException);
            }
            catch (NullPointerException nullPointerException) {
                LoggerFactory.getInstance().log("NPE when closing " + this.url);
                LoggerFactory.getInstance().error(nullPointerException);
            }
        }
        return 0L;
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

