/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.weblogic;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.weblogic.GenericClassLoaderCBP$1;
import org.zeroturnaround.javarebel.integration.weblogic.GenericClassLoaderCBP$2;

public class GenericClassLoaderCBP
extends JavassistClassBytecodeProcessor {
    static Class class$org$zeroturnaround$javarebel$ClassResourceSource;
    static Class class$java$lang$String;
    static Class class$org$zeroturnaround$javarebel$ClassBytecodeProcessor;
    static Class class$org$zeroturnaround$javarebel$integration$util$WeakUtil;
    static Class class$org$zeroturnaround$javarebel$integration$util$MonitorUtil;

    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.util");
        ctClass.addInterface(classPool.get((class$org$zeroturnaround$javarebel$ClassResourceSource == null ? (class$org$zeroturnaround$javarebel$ClassResourceSource = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.ClassResourceSource")) : class$org$zeroturnaround$javarebel$ClassResourceSource).getName()));
        CtConstructor[] ctConstructorArray = ctClass.getConstructors();
        for (int i2 = 0; i2 < ctConstructorArray.length; ++i2) {
            if (!ctConstructorArray[i2].callsSuper()) continue;
            ctConstructorArray[i2].insertAfter("if (!getClass().getName().startsWith(\"weblogic.servlet.jsp\"))  IntegrationFactory.getInstance().registerClassLoader(this, this);");
        }
        this.processFinding(classPool, ctClass);
        this.processUpdating(ctClass);
        this.processInstrumentation(classPool, ctClass);
        this.processClasspath(classPool, ctClass);
    }

    private void processFinding(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        ctClass.getMethod("findClass", "(Ljava/lang/String;)Ljava/lang/Class;").insertBefore("{ synchronized ($0) {    Class result =      findLoadedClass($1);    if (result != null)      return result;    result =       IntegrationFactory.getInstance().findReloadableClass($0, $1);    if (result != null)      return result;}}");
        try {
            ctClass.getDeclaredMethod("findResource", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = GenericClassLoaderCBP.class$("java.lang.String")) : class$java$lang$String).getName()})).insertBefore("{  Integration integration = IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, $1)) {    return integration.findResource($0, $1);  }}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctClass.getDeclaredMethod("findResources", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = GenericClassLoaderCBP.class$("java.lang.String")) : class$java$lang$String).getName()})).insertBefore("{  Integration integration = IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, $1))    return integration.findResources($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        ctClass.addMethod(CtNewMethod.make("public Resource getClassResource(String className) {  Resource resource = ResourceUtil.getClassResource(this, className);  if (resource != null && \".class\".equals(resource.toURL().getFile())) {    return null;  }  return resource;}", ctClass));
        ctClass.addMethod(CtNewMethod.make("public Resource getLocalResource(String name) {  return ResourceUtil.asResource(findResource(name));}", ctClass));
        ctClass.addMethod(CtNewMethod.make("public Resource[] getLocalResources(String name) {  return ResourceUtil.asResources(findResources(name));}", ctClass));
    }

    private void processUpdating(CtClass ctClass) throws CannotCompileException {
        try {
            ctClass.getDeclaredMethod("addClassFinder").insertAfter("{   IntegrationFactory.getInstance().reinitializeClassLoader($0);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctClass.getDeclaredMethod("addClassFinderFirst").insertAfter("{   IntegrationFactory.getInstance().reinitializeClassLoader($0);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctClass.getDeclaredMethod("close").insertAfter("{   IntegrationFactory.getInstance().unregisterClassLoader($0);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void processInstrumentation(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        try {
            ctClass.getDeclaredMethod("doPreProcess");
            ctClass.addInterface(classPool.get((class$org$zeroturnaround$javarebel$ClassBytecodeProcessor == null ? (class$org$zeroturnaround$javarebel$ClassBytecodeProcessor = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.ClassBytecodeProcessor")) : class$org$zeroturnaround$javarebel$ClassBytecodeProcessor).getName()));
            CtConstructor[] ctConstructorArray = ctClass.getConstructors();
            for (int i2 = 0; i2 < ctConstructorArray.length; ++i2) {
                if (!ctConstructorArray[i2].callsSuper()) continue;
                ctConstructorArray[i2].insertAfter("IntegrationFactory.getInstance().addIntegrationProcessor(" + (class$org$zeroturnaround$javarebel$integration$util$WeakUtil == null ? GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.integration.util.WeakUtil") : class$org$zeroturnaround$javarebel$integration$util$WeakUtil).getName() + ".weakCBP($0), true);");
            }
            CtMethod ctMethod = ctClass.getDeclaredMethod("findClass");
            ctMethod.insertBefore("{" + (class$org$zeroturnaround$javarebel$integration$util$MonitorUtil == null ? (class$org$zeroturnaround$javarebel$integration$util$MonitorUtil = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.integration.util.MonitorUtil")) : class$org$zeroturnaround$javarebel$integration$util$MonitorUtil).getName() + ".exit($1 + System.identityHashCode($0));" + "}");
            ctMethod = ctClass.getDeclaredMethod("defineClass");
            ctMethod.instrument(new GenericClassLoaderCBP$1(this));
            ctMethod.insertAfter((class$org$zeroturnaround$javarebel$integration$util$MonitorUtil == null ? (class$org$zeroturnaround$javarebel$integration$util$MonitorUtil = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.integration.util.MonitorUtil")) : class$org$zeroturnaround$javarebel$integration$util$MonitorUtil).getName() + ".exit($1 + System.identityHashCode($0));", true);
            ctClass.addMethod(CtNewMethod.make("public byte[] process(ClassLoader cl, String classname, byte[] bytecode) {  if ($0 != cl || " + (class$org$zeroturnaround$javarebel$integration$util$MonitorUtil == null ? (class$org$zeroturnaround$javarebel$integration$util$MonitorUtil = GenericClassLoaderCBP.class$("org.zeroturnaround.javarebel.integration.util.MonitorUtil")) : class$org$zeroturnaround$javarebel$integration$util$MonitorUtil).getName() + ".isActive(classname + System.identityHashCode($0))) {" + "    return bytecode;" + "  }" + "  return doPreProcess(bytecode, classname.replace('/', '.'));" + "}", ctClass));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void processClasspath(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        CtMethod ctMethod;
        classPool.importPackage("java.net");
        try {
            ctMethod = ctClass.getDeclaredMethod("getFinderClassPath");
            this.processClasspathMethod(ctMethod);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctMethod = ctClass.getDeclaredMethod("getClassPath");
            if (!this.callsMethod(ctMethod, "getFinderClassPath")) {
                this.processClasspathMethod(ctMethod);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void processClasspathMethod(CtMethod ctMethod) throws CannotCompileException {
        ctMethod.insertAfter("{   try {    Integration integration = IntegrationFactory.getInstance();    URL[] urls = integration.getRebelURLs($0, false);    if (urls != null) {      $_ = ResourceUtil.concatClassPath(ResourceUtil.toClassPath(urls), $_);    }  } catch (Throwable t) {    LoggerFactory.getInstance().error(t);  }}");
    }

    private boolean callsMethod(CtMethod ctMethod, String string) throws CannotCompileException {
        boolean[] blArray = new boolean[]{false};
        ctMethod.instrument(new GenericClassLoaderCBP$2(this, string, blArray));
        return blArray[0];
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

