/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.ResourceSource;
import org.zeroturnaround.javarebel.support.FileResource;
import org.zeroturnaround.javarebel.support.ResourceUtils;
import org.zeroturnaround.javarebel.support.URLResource;

public class ResourceUtil {
    private static final Method FIND_RESOURCE_METHOD = ResourceUtil.getClassLoaderMethod("findResource", new Class[]{class$java$lang$String == null ? (class$java$lang$String = ResourceUtil.class$("java.lang.String")) : class$java$lang$String});
    private static final Method FIND_RESOURCES_METHOD = ResourceUtil.getClassLoaderMethod("findResources", new Class[]{class$java$lang$String == null ? (class$java$lang$String = ResourceUtil.class$("java.lang.String")) : class$java$lang$String});
    static Class class$java$lang$String;
    static Class class$java$lang$ClassLoader;

    private static Method getClassLoaderMethod(String string, Class[] classArray) {
        Method method = null;
        try {
            method = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ResourceUtil.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod(string, classArray);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LoggerFactory.getInstance().errorEcho(noSuchMethodException);
        }
        return method;
    }

    public static URL findResource(ClassLoader classLoader, String string) {
        URL uRL;
        if (classLoader instanceof URLClassLoader) {
            uRL = ((URLClassLoader)classLoader).findResource(string);
        } else {
            try {
                uRL = (URL)FIND_RESOURCE_METHOD.invoke((Object)classLoader, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getTargetException());
            }
        }
        return uRL;
    }

    public static URL[] findResources(ClassLoader classLoader, String string) {
        Enumeration enumeration;
        if (classLoader instanceof URLClassLoader) {
            try {
                enumeration = ((URLClassLoader)classLoader).findResources(string);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        try {
            enumeration = (Enumeration)FIND_RESOURCES_METHOD.invoke((Object)classLoader, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(enumeration);
    }

    public static URL[] findResources(URLClassLoader uRLClassLoader, String string) {
        Enumeration<URL> enumeration;
        try {
            enumeration = uRLClassLoader.findResources(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(enumeration);
    }

    public static URL[] toURLs(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (enumeration.hasMoreElements()) {
            arrayList.add((URL)enumeration.nextElement());
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public static Enumeration toEnumeration(URL[] uRLArray) {
        return new Vector<URL>(Arrays.asList(uRLArray)).elements();
    }

    public static URL[] concat(URL[] uRLArray, URL[] uRLArray2) {
        if (uRLArray == null) {
            return uRLArray2;
        }
        if (uRLArray2 == null) {
            return uRLArray;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.addAll(Arrays.asList(uRLArray));
        arrayList.addAll(Arrays.asList(uRLArray2));
        URL[] uRLArray3 = arrayList.toArray(new URL[arrayList.size()]);
        return uRLArray3;
    }

    public static String concatClassPath(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        String string3 = string + File.pathSeparator + string2;
        return string3;
    }

    public static String toClassPath(URL[] uRLArray) {
        if (uRLArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            URL uRL = uRLArray[i2];
            File file = ResourceUtils.getFile(uRL);
            stringBuffer.append(file.getPath());
            if (i2 >= uRLArray.length - 1) continue;
            stringBuffer.append(File.pathSeparator);
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static Resource getClassResource(ResourceSource resourceSource, String string) {
        return resourceSource.getLocalResource(string.replace('.', '/') + ".class");
    }

    public static Resource[] asArray(Resource resource) {
        if (resource == null) {
            return null;
        }
        return new Resource[]{resource};
    }

    public static Resource asResource(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (ResourceUtils.isFileURL(uRL)) {
            return new FileResource(uRL);
        }
        return new URLResource(uRL);
    }

    public static Resource[] asResources(URL[] uRLArray) {
        if (uRLArray == null) {
            return null;
        }
        Resource[] resourceArray = new Resource[uRLArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            resourceArray[i2] = ResourceUtil.asResource(uRLArray[i2]);
        }
        return resourceArray;
    }

    public static Resource[] asResources(Enumeration enumeration) {
        return ResourceUtil.asResources(ResourceUtil.toURLs(enumeration));
    }

    public static Resource[] asResources(List list) {
        if (list == null) {
            return null;
        }
        Resource[] resourceArray = new Resource[list.size()];
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            resourceArray[n2++] = ResourceUtil.asResource((URL)iterator.next());
        }
        return resourceArray;
    }

    public static InputStream asRawInputStream(URL uRL) {
        try {
            if (uRL != null) {
                return uRL.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream asInputStream(URL uRL) {
        if (uRL == null) {
            return null;
        }
        byte[] byArray = ResourceUtil.asResource(uRL).getBytes();
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public static URL makeURL(File file) throws MalformedURLException {
        if (file == null) {
            return null;
        }
        return file.toURI().toURL();
    }

    public static URL makeURL(File file, String string) throws MalformedURLException {
        if (file == null) {
            return null;
        }
        if (string == null) {
            return ResourceUtil.makeURL(file);
        }
        return new URL("jar:file:" + file.getAbsolutePath() + "!/" + string);
    }

    public static File getFileFromPathOrURL(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        return ResourceUtils.getFile(new URL(string));
    }

    public static File getFileFromURL(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        return ResourceUtils.getFile(new URL(string));
    }

    public static File getFileFromURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return ResourceUtils.getFile(uRL);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

