/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.zeroturnaround.javarebel.Reloader;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.integration.util.ClassReflectionUtil;

public class ReloaderUtil {
    private static final Reloader reloader = ReloaderFactory.getInstance();

    public static void checkAndReload(Collection collection) {
        if (collection == null) {
            return;
        }
        Iterator<Object> iterator = Arrays.asList(collection.toArray()).iterator();
        while (iterator.hasNext()) {
            reloader.checkAndReload((Class)iterator.next());
        }
    }

    public static boolean isReloadingAnyClass(Collection collection) {
        return ReloaderUtil.isReloadingAnyClass(collection, null);
    }

    public static boolean isReloadingAnyClass(Collection collection, Class clazz) {
        if (collection == null) {
            return false;
        }
        Iterator<Object> iterator = Arrays.asList(collection.toArray()).iterator();
        while (iterator.hasNext()) {
            Class clazz2 = (Class)iterator.next();
            if (clazz != null && clazz.equals(clazz2) || !reloader.isReloadingClass(clazz2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsReloadableClass(Collection collection) {
        if (collection == null) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!ReloaderUtil.isRelodableClass(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Collection getReloadableClasses(Collection collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!ReloaderUtil.isRelodableClass(clazz)) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    private static Set retainReloadableClasses(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (ReloaderUtil.isRelodableClass(clazz)) continue;
            iterator.remove();
        }
        return set;
    }

    private static boolean isRelodableClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        String string = clazz.getName();
        if (string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("net.sf.cglib.")) {
            return false;
        }
        return reloader.isReloadableClass(clazz);
    }

    public static boolean isReloadableClassHierarchy(Class clazz) {
        return ReloaderUtil.containsReloadableClass(ClassReflectionUtil.getClassHierarchy(clazz));
    }

    public static boolean existsReloadableClassHierarchy(Class[] classArray) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class clazz = classArray[i2];
            if (!ReloaderUtil.isReloadableClassHierarchy(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Set getReloadableClassHierarchy(Class clazz) {
        return ReloaderUtil.retainReloadableClasses(ClassReflectionUtil.getClassHierarchy(clazz));
    }

    public static Set getReloadableClassHierarchies(Class[] classArray) {
        return ReloaderUtil.retainReloadableClasses(ClassReflectionUtil.getClassHierarchies(classArray));
    }

    public static Set getReloadableClassHierarchies(Collection collection) {
        return ReloaderUtil.retainReloadableClasses(ClassReflectionUtil.getClassHierarchies(collection));
    }

    public static Set withParents(Class clazz) {
        return ReloaderUtil.getReloadableClassHierarchy(clazz);
    }

    public static Set getParents(Class clazz) {
        Set set = ReloaderUtil.getReloadableClassHierarchy(clazz);
        set.remove(clazz);
        return set;
    }

    public static Set withParentInterfaces(Class clazz) {
        Set set = ClassReflectionUtil.getClassHierarchies(clazz.getInterfaces());
        set.add(clazz);
        ReloaderUtil.retainReloadableClasses(set);
        return set;
    }

    public static Set withParentInterfaces(Collection collection) {
        Set set = ClassReflectionUtil.getClassHierarchies(ClassReflectionUtil.getInterfaces(collection));
        set.addAll(collection);
        ReloaderUtil.retainReloadableClasses(set);
        return set;
    }

    public static Set getInterfaces(Class clazz) {
        return ReloaderUtil.getReloadableClassHierarchies(clazz.getInterfaces());
    }
}

