/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.security.AccessController;
import java.util.Collection;
import java.util.Locale;
import org.zeroturnaround.javarebel.integration.util.MiscUtil$1;
import org.zeroturnaround.javarebel.integration.util.MiscUtil$2;
import org.zeroturnaround.javarebel.integration.util.MiscUtil$3;

public abstract class MiscUtil {
    private static final boolean isJava5 = System.getProperty("java.specification.version").compareTo("1.5") >= 0;
    private static final boolean isWindows = System.getProperty("os.name").toUpperCase(Locale.ENGLISH).indexOf("NDOWS") != -1;
    private static final boolean isWindows9x = System.getProperty("os.name").toUpperCase(Locale.ENGLISH).indexOf("NDOWS 9") != -1 || System.getProperty("os.name").toUpperCase(Locale.ENGLISH).indexOf("NDOWS ME") != -1;
    private static final boolean is32bit = System.getProperty("sun.arch.data.model") == null || System.getProperty("sun.arch.data.model").equals("32");
    private static final boolean isMac = System.getProperty("os.name").toUpperCase(Locale.ENGLISH).indexOf("MAC") != -1;
    private static final boolean isLinux = System.getProperty("os.name").toUpperCase(Locale.ENGLISH).indexOf("LINUX") != -1;
    private static final boolean isAmd64 = "amd64".equals(System.getProperty("os.arch"));

    public static boolean isJava5() {
        return isJava5;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isWindows9x() {
        return isWindows9x;
    }

    public static boolean is32bit() {
        return is32bit;
    }

    public static boolean is64bit() {
        return !is32bit;
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isAmd64() {
        return isAmd64;
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static String identityToString(Class clazz) {
        if (clazz == null) {
            return "null";
        }
        return clazz.getName() + "@" + MiscUtil.identityToString(clazz.getClassLoader());
    }

    public static String identityToString(Class[] classArray) {
        if (classArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class clazz = classArray[i2];
            stringBuffer.append(MiscUtil.identityToString(clazz));
            if (i2 >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String dumpToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().getName().startsWith("org.zeroturnaround.javarebel")) {
            return object.toString();
        }
        return MiscUtil.identityToString(object);
    }

    public static String toString(Collection collection) {
        return collection == null ? "null" : MiscUtil.toString(collection.toArray());
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        int n2 = objectArray.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n3 = 0;
        while (true) {
            stringBuffer.append(String.valueOf(objectArray[n3]));
            if (n3 == n2) {
                return stringBuffer.append(']').toString();
            }
            stringBuffer.append(", ");
            ++n3;
        }
    }

    public static Class[] add(Class[] classArray, Class clazz) {
        if (clazz == null) {
            return classArray;
        }
        if (classArray == null || classArray.length == 0) {
            return new Class[]{clazz};
        }
        Class[] classArray2 = new Class[classArray.length + 1];
        System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
        classArray2[classArray.length] = clazz;
        return classArray2;
    }

    public static ClassLoader getSystemClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new MiscUtil$1());
    }

    public static final ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new MiscUtil$2());
    }

    public static final ClassLoader setContextClassLoader(ClassLoader classLoader) {
        return (ClassLoader)AccessController.doPrivileged(new MiscUtil$3(classLoader));
    }
}

