/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.FileUtil$1;

public class FileUtil {
    private static final Logger log = LoggerFactory.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (log.isEnabled()) {
            log.log("Copying " + file + " to " + file2);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            FileUtil.copy(fileInputStream, fileOutputStream);
        }
        finally {
            FileUtil.closeQuietly(fileInputStream);
            FileUtil.closeQuietly(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndClose(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            FileUtil.copy(inputStream, fileOutputStream);
        }
        finally {
            FileUtil.closeQuietly(inputStream);
            FileUtil.closeQuietly(fileOutputStream);
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (log.isEnabled()) {
            log.log("Deleting " + file);
        }
        FileUtil.doForceDelete(file);
        if (log.isEnabled()) {
            log.log("Deleted " + file);
        }
    }

    private static void doForceDelete(File file) throws IOException {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                FileUtil.doForceDelete(fileArray[i2]);
            }
        }
        FileUtil.delete(file);
    }

    private static void delete(File file) throws IOException {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new FileUtil$1(file));
        if (!bl2.booleanValue()) {
            throw new IOException("Could not delete " + file);
        }
    }

    public static String getExtension(File file) {
        String string = file.getPath();
        int n2 = string.lastIndexOf(46);
        return n2 == -1 ? null : string.substring(n2 + 1);
    }

    private static void closeQuietly(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeQuietly(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

