/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.DeployDirUtil$DeployDirListener;
import org.zeroturnaround.javarebel.integration.util.FileUtil;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class DeployDirUtil {
    private static final Logger log = LoggerFactory.getInstance();
    private static final Collection paths = new ArrayList();
    private static final Collection listeners = Collections.synchronizedCollection(new ArrayList());
    static Class class$org$zeroturnaround$javarebel$integration$util$DeployDirUtil;

    public static void register(URI[] uRIArray) throws MalformedURLException {
        if (uRIArray == null || uRIArray.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < uRIArray.length; ++i2) {
            DeployDirUtil.register(uRIArray[i2]);
        }
    }

    public static void register(URI uRI) throws MalformedURLException {
        if (uRI == null) {
            return;
        }
        DeployDirUtil.register(uRI.toURL());
    }

    public static void register(URL uRL) {
        if (uRL == null) {
            return;
        }
        try {
            DeployDirUtil.register(ResourceUtils.getFile(uRL).getPath());
        }
        catch (Exception exception) {
            LoggerFactory.getInstance().error(exception);
        }
    }

    public static void register(File file) {
        if (file == null) {
            return;
        }
        try {
            if (!file.isDirectory()) {
                throw new IOException("Not a directory: " + file);
            }
            DeployDirUtil.register(file.getPath());
        }
        catch (Exception exception) {
            log.error(exception);
        }
    }

    private static void register(String string) {
        try {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            DeployDirUtil.doRegister(string);
            log.log("Registered deployment dir: " + string);
        }
        catch (Exception exception) {
            log.error(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRegister(String string) {
        File file = null;
        Class clazz = class$org$zeroturnaround$javarebel$integration$util$DeployDirUtil == null ? (class$org$zeroturnaround$javarebel$integration$util$DeployDirUtil = DeployDirUtil.class$("org.zeroturnaround.javarebel.integration.util.DeployDirUtil")) : class$org$zeroturnaround$javarebel$integration$util$DeployDirUtil;
        synchronized (clazz) {
            if (paths.isEmpty()) {
                file = new File(string);
            }
            paths.add(string);
        }
        if (file != null) {
            DeployDirUtil.fireDefaultDirUpdate(file);
        }
    }

    public static boolean contains(File file) {
        return DeployDirUtil.contains(file.getPath());
    }

    private static synchronized boolean contains(String string) {
        Iterator iterator = paths.iterator();
        while (iterator.hasNext()) {
            if (!string.startsWith((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean delete(File file) throws Exception {
        return DeployDirUtil.deleteWithRetry(file, 1, 0);
    }

    public static boolean deleteWithRetry(File file, int n2, int n3) throws Exception {
        if (!DeployDirUtil.contains(file)) {
            log.log("Skipping deleting of '" + file + "' - not under a deployment dir.");
            return false;
        }
        if (!file.exists()) {
            log.log("Skipping deleting of '" + file + "' - file not found.");
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                FileUtil.forceDelete(file);
                if (i2 <= 0) break;
                log.echo("Successfully deleted " + file + " after " + i2 + " failed attempts");
                break;
            }
            catch (IOException iOException) {
                if (i2 == n2 - 1) {
                    log.error(iOException);
                    throw iOException;
                }
                log.echo("Failed to delete " + file + " on attempt #" + (i2 + 1) + ": " + iOException);
                Thread.sleep(n3);
                continue;
            }
        }
        return true;
    }

    public static synchronized File getDefaultDir() {
        Iterator iterator = paths.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return new File((String)iterator.next());
    }

    public static void addListener(DeployDirUtil$DeployDirListener deployDirUtil$DeployDirListener) {
        listeners.add(deployDirUtil$DeployDirListener);
    }

    private static void fireDefaultDirUpdate(File file) {
        Object[] objectArray = listeners.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                ((DeployDirUtil$DeployDirListener)objectArray[i2]).onDefaultDirUpdate(file);
                continue;
            }
            catch (Throwable throwable) {
                log.log("An error occured in an deploy dir listener while handling default dir update event:");
                log.error(throwable);
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

