/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.tcat;

import java.net.URLClassLoader;
import org.zeroturnaround.javarebel.ClassLoaderFilter;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;

public class TcatClassLoaderFilter
implements ClassLoaderFilter {
    private static final Logger log = LoggerFactory.getInstance();
    private static final String TOMCAT_WEB_CLASS_LOADER = "org.apache.catalina.loader.WebappClassLoader";
    private static final String[] TCAT_CLASSES = new String[]{"com.mulesoft.tcat.monitoring.tomcat.TcatServlet", "org.mule.galaxy.web.ConfigurableDispatcherServlet"};

    public synchronized boolean matches(ClassLoader classLoader) {
        if (!TOMCAT_WEB_CLASS_LOADER.equals(classLoader.getClass().getName())) {
            return false;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        for (int i2 = 0; i2 < TCAT_CLASSES.length; ++i2) {
            String string = TCAT_CLASSES[i2];
            String string2 = string.replace('.', '/') + ".class";
            try {
                if (uRLClassLoader.findResource(string2) == null) continue;
                if (log.isEnabled()) {
                    log.log("TCat class loader detected due to class '" + string + "@" + MiscUtil.identityToString(classLoader));
                }
                return true;
            }
            catch (Throwable throwable) {
                log.log("JRebel failed to check existance of class '" + string + "' in " + MiscUtil.identityToString(classLoader));
                log.error(throwable);
            }
        }
        return false;
    }
}

