/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import org.zeroturnaround.bundled.javassist.ByteArrayClassPath;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.javarebel.AgentIntegration;
import org.zeroturnaround.javarebel.AgentIntegrationFactory;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$1;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$2;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$ClassFilter;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$FilterClassPathWrapper;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$RebelClassPath;
import org.zeroturnaround.javarebel.integration.support.PublicAgentClassPath;
import org.zeroturnaround.javarebel.integration.support.RestrictedClassClassPath;
import org.zeroturnaround.javarebel.integration.support.RestrictedLoaderClassPath;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;

public abstract class JavassistClassBytecodeProcessor
implements ClassBytecodeProcessor {
    private static final AgentIntegration agent = AgentIntegrationFactory.getInstance();
    static final Logger log = LoggerFactory.getLogger("SDK-CBP");
    private static final JavassistClassBytecodeProcessor$ClassFilter ignoreDefault = new JavassistClassBytecodeProcessor$1();
    private static final JavassistClassBytecodeProcessor$ClassFilter ignoreJava = new JavassistClassBytecodeProcessor$2();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] process(ClassLoader classLoader, String string, byte[] byArray) {
        StopWatch stopWatch = LoggerFactory.getInstance().createStopWatch("JavassistClassBytecodeProcessor");
        try {
            string = string.replace('/', '.');
            ClassPool classPool = new ClassPool();
            if (log.isTraceEnabled()) {
                classPool.appendClassPath(new JavassistClassBytecodeProcessor$RebelClassPath(null));
            }
            classPool.appendClassPath(new ByteArrayClassPath(string, byArray));
            if (agent.arePublicClassBytesCached()) {
                classPool.appendClassPath(PublicAgentClassPath.getInstance());
            }
            if (classLoader != null) {
                classPool.appendClassPath(JavassistClassBytecodeProcessor.ignoreJava(JavassistClassBytecodeProcessor.ignoreDefaultPackage(new RestrictedLoaderClassPath(classLoader))));
            }
            classPool.appendClassPath(JavassistClassBytecodeProcessor.ignoreDefaultPackage(new RestrictedClassClassPath()));
            CtClass ctClass = classPool.get(string);
            ctClass.defrost();
            this.process(classPool, classLoader, ctClass);
            byte[] byArray2 = ctClass.toBytecode();
            return byArray2;
        }
        catch (Throwable throwable) {
            log.echoPrefix("Class '" + string + "' could not be processed by " + MiscUtil.identityToString(this.getClass()));
            log.errorEcho(throwable);
            byte[] byArray3 = byArray;
            return byArray3;
        }
        finally {
            if (stopWatch != null) {
                stopWatch.stop();
            }
        }
    }

    public abstract void process(ClassPool var1, ClassLoader var2, CtClass var3) throws Exception;

    private static ClassPath ignoreDefaultPackage(ClassPath classPath) {
        return new JavassistClassBytecodeProcessor$FilterClassPathWrapper(classPath, ignoreDefault);
    }

    private static ClassPath ignoreJava(ClassPath classPath) {
        return new JavassistClassBytecodeProcessor$FilterClassPathWrapper(classPath, ignoreJava);
    }
}

