/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.monitor;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.FileEventListener;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.ResourceIntegrationFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.monitor.FileMonitorAdapter$DirtyListener;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;

public class FileMonitorAdapter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CHECK_INTERVAL = ConfigurationFactory.getInstance().getCheckInterval();
    private Map files = Collections.synchronizedMap(new HashMap());
    private final FileEventListener innerListener = new FileMonitorAdapter$DirtyListener(this, false);
    private final FileEventListener listener = WeakUtil.weak(this.innerListener);
    private final FileEventListener innerRecursiveListener = new FileMonitorAdapter$DirtyListener(this, true);
    private final FileEventListener listenerRecursive = WeakUtil.weak(this.innerRecursiveListener);
    private final boolean onlyAdd;
    private long lastScan = System.currentTimeMillis();
    private boolean dirty = false;
    private boolean directories = false;

    public FileMonitorAdapter() {
        this.onlyAdd = false;
    }

    public FileMonitorAdapter(boolean bl2) {
        this.onlyAdd = bl2;
    }

    public void addFile(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        if (!file.isDirectory()) {
            this.files.put(file, new Long(file.lastModified()));
            ResourceIntegrationFactory.getInstance().addFileListener(file.getParentFile(), this.listener);
        } else {
            this.directories = true;
            ResourceIntegrationFactory.getInstance().addFileListener(file, this.listener);
        }
    }

    public void addRecursiveDir(File file) {
        this.directories = true;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        if (file.isDirectory()) {
            ResourceIntegrationFactory.getInstance().addFileListener(file, this.listenerRecursive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Map map = this.files;
        synchronized (map) {
            if (this.lastScan + (long)CHECK_INTERVAL < System.currentTimeMillis() && (this.dirty || !ResourceIntegrationFactory.getInstance().isEnabled())) {
                boolean bl2 = false;
                if (this.directories || this.files.size() == 0) {
                    bl2 = true;
                } else {
                    StopWatch stopWatch = LoggerFactory.getLogger("Util").createStopWatch("DirtyCheck");
                    try {
                        bl2 = false;
                        Iterator iterator = this.files.keySet().iterator();
                        while (iterator.hasNext()) {
                            File file = (File)iterator.next();
                            long l2 = file.lastModified();
                            if (l2 == (Long)this.files.get(file)) continue;
                            this.files.put(file, new Long(l2));
                            bl2 = true;
                        }
                    }
                    finally {
                        if (stopWatch != null) {
                            stopWatch.stop();
                        }
                    }
                }
                this.dirty = false;
                this.lastScan = System.currentTimeMillis();
                return bl2;
            }
        }
        return false;
    }

    public void reset() {
        this.dirty = false;
        this.lastScan = System.currentTimeMillis();
    }

    public void destroy() {
        ResourceIntegrationFactory.getInstance().removeFileListener(this.listener);
        this.files.clear();
    }

    static boolean access$002(FileMonitorAdapter fileMonitorAdapter, boolean bl2) {
        fileMonitorAdapter.dirty = bl2;
        return fileMonitorAdapter.dirty;
    }

    static boolean access$100(FileMonitorAdapter fileMonitorAdapter) {
        return fileMonitorAdapter.onlyAdd;
    }
}

