/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.generic;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.ReloaderUtil;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;

public class DependencyClassEventListener
implements ClassEventListener {
    private final Reference klass;
    private final Collection dependencies;
    private final ClassEventListener target;

    public DependencyClassEventListener(Class clazz, Collection collection, ClassEventListener classEventListener) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must be provided");
        }
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Dependencies must be provided");
        }
        if (classEventListener == null) {
            throw new IllegalArgumentException("target listener must be provided");
        }
        this.klass = new WeakReference<Class>(clazz);
        this.dependencies = WeakUtil.createWeakHashSet(collection);
        this.target = classEventListener;
    }

    public void onClassEvent(int n2, Class clazz) {
        if (ReloaderUtil.isReloadingAnyClass(this.dependencies, clazz)) {
            return;
        }
        Class clazz2 = (Class)this.klass.get();
        if (clazz2 == null) {
            return;
        }
        this.target.onClassEvent(2, clazz2);
    }

    public int priority() {
        return this.target.priority();
    }

    public Object getTarget() {
        return this.target;
    }

    public String toString() {
        return "DependencyClassEventListener[" + MiscUtil.dumpToString(this.target) + "]";
    }
}

