/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.util.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.DuplicateMemberException;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.FieldInfo;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$Writer;
import org.zeroturnaround.bundled.javassist.util.proxy.FactoryHelper;
import org.zeroturnaround.bundled.javassist.util.proxy.MethodFilter;
import org.zeroturnaround.bundled.javassist.util.proxy.MethodHandler;
import org.zeroturnaround.bundled.javassist.util.proxy.Proxy;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyFactory$1;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyFactory$2;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyFactory$3;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyFactory$ClassLoaderProvider;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyFactory$Find2MethodsArgs;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyFactory$ProxyDetails;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyFactory$UniqueName;
import org.zeroturnaround.bundled.javassist.util.proxy.RuntimeSupport;
import org.zeroturnaround.bundled.javassist.util.proxy.SecurityActions;

public class ProxyFactory {
    private Class superClass = null;
    private Class[] interfaces = null;
    private MethodFilter methodFilter = null;
    private MethodHandler handler = null;
    private List signatureMethods = null;
    private boolean hasGetHandler = false;
    private byte[] signature = null;
    private String classname;
    private String basename;
    private String superName;
    private Class thisClass = null;
    private boolean factoryUseCache = useCache;
    private boolean factoryWriteReplace = useWriteReplace;
    public String writeDirectory = null;
    private static final Class OBJECT_TYPE = class$java$lang$Object == null ? (class$java$lang$Object = ProxyFactory.class$("java.lang.Object")) : class$java$lang$Object;
    private static final String HOLDER = "_methods_";
    private static final String HOLDER_TYPE = "[Ljava/lang/reflect/Method;";
    private static final String FILTER_SIGNATURE_FIELD = "_filter_signature";
    private static final String FILTER_SIGNATURE_TYPE = "[B";
    private static final String HANDLER = "handler";
    private static final String NULL_INTERCEPTOR_HOLDER = "org.zeroturnaround.bundled.javassist.util.proxy.RuntimeSupport";
    private static final String DEFAULT_INTERCEPTOR = "default_interceptor";
    private static final String HANDLER_TYPE = 'L' + (class$javassist$util$proxy$MethodHandler == null ? (class$javassist$util$proxy$MethodHandler = ProxyFactory.class$("org.zeroturnaround.bundled.javassist.util.proxy.MethodHandler")) : class$javassist$util$proxy$MethodHandler).getName().replace('.', '/') + ';';
    private static final String HANDLER_SETTER = "setHandler";
    private static final String HANDLER_SETTER_TYPE = "(" + HANDLER_TYPE + ")V";
    private static final String HANDLER_GETTER = "getHandler";
    private static final String HANDLER_GETTER_TYPE = "()" + HANDLER_TYPE;
    private static final String SERIAL_VERSION_UID_FIELD = "serialVersionUID";
    private static final String SERIAL_VERSION_UID_TYPE = "J";
    private static final long SERIAL_VERSION_UID_VALUE = -1L;
    public static volatile boolean useCache = true;
    public static volatile boolean useWriteReplace = true;
    private static WeakHashMap proxyCache = new WeakHashMap();
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static ProxyFactory$ClassLoaderProvider classLoaderProvider = new ProxyFactory$1();
    public static ProxyFactory$UniqueName nameGenerator = new ProxyFactory$2();
    private static Comparator sorter = new ProxyFactory$3();
    private static final String HANDLER_GETTER_KEY = "getHandler:()";
    static Class class$java$lang$Object;
    static Class class$javassist$util$proxy$MethodHandler;
    static Class class$javassist$util$proxy$Proxy;
    static Class class$javassist$util$proxy$ProxyObject;
    static Class class$java$lang$ClassNotFoundException;
    static Class class$javassist$util$proxy$RuntimeSupport;

    public boolean isUseCache() {
        return this.factoryUseCache;
    }

    public void setUseCache(boolean bl2) {
        if (this.handler != null && bl2) {
            throw new RuntimeException("caching cannot be enabled if the factory default interceptor has been set");
        }
        this.factoryUseCache = bl2;
    }

    public boolean isUseWriteReplace() {
        return this.factoryWriteReplace;
    }

    public void setUseWriteReplace(boolean bl2) {
        this.factoryWriteReplace = bl2;
    }

    public static boolean isProxyClass(Class clazz) {
        return (class$javassist$util$proxy$Proxy == null ? (class$javassist$util$proxy$Proxy = ProxyFactory.class$("org.zeroturnaround.bundled.javassist.util.proxy.Proxy")) : class$javassist$util$proxy$Proxy).isAssignableFrom(clazz);
    }

    public void setSuperclass(Class clazz) {
        this.superClass = clazz;
        this.signature = null;
    }

    public Class getSuperclass() {
        return this.superClass;
    }

    public void setInterfaces(Class[] classArray) {
        this.interfaces = classArray;
        this.signature = null;
    }

    public Class[] getInterfaces() {
        return this.interfaces;
    }

    public void setFilter(MethodFilter methodFilter) {
        this.methodFilter = methodFilter;
        this.signature = null;
    }

    public Class createClass() {
        if (this.signature == null) {
            this.computeSignature(this.methodFilter);
        }
        return this.createClass1();
    }

    public Class createClass(MethodFilter methodFilter) {
        this.computeSignature(methodFilter);
        return this.createClass1();
    }

    Class createClass(byte[] byArray) {
        this.installSignature(byArray);
        return this.createClass1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class createClass1() {
        Object object;
        if (this.thisClass == null) {
            object = this.getClassLoader();
            WeakHashMap weakHashMap = proxyCache;
            synchronized (weakHashMap) {
                if (this.factoryUseCache) {
                    this.createClass2((ClassLoader)object);
                } else {
                    this.createClass3((ClassLoader)object);
                }
            }
        }
        object = this.thisClass;
        this.thisClass = null;
        return object;
    }

    public String getKey(Class clazz, Class[] classArray, byte[] byArray, boolean bl2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (clazz != null) {
            stringBuffer.append(clazz.getName());
        }
        stringBuffer.append(":");
        for (n2 = 0; n2 < classArray.length; ++n2) {
            stringBuffer.append(classArray[n2].getName());
            stringBuffer.append(":");
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byte by2 = byArray[n2];
            int n3 = by2 & 0xF;
            int n4 = by2 >> 4 & 0xF;
            stringBuffer.append(hexDigits[n3]);
            stringBuffer.append(hexDigits[n4]);
        }
        if (bl2) {
            stringBuffer.append(":w");
        }
        return stringBuffer.toString();
    }

    private void createClass2(ClassLoader classLoader) {
        ProxyFactory$ProxyDetails proxyFactory$ProxyDetails;
        String string = this.getKey(this.superClass, this.interfaces, this.signature, this.factoryWriteReplace);
        HashMap<String, ProxyFactory$ProxyDetails> hashMap = (HashMap<String, ProxyFactory$ProxyDetails>)proxyCache.get(classLoader);
        if (hashMap == null) {
            hashMap = new HashMap<String, ProxyFactory$ProxyDetails>();
            proxyCache.put(classLoader, hashMap);
        }
        if ((proxyFactory$ProxyDetails = (ProxyFactory$ProxyDetails)hashMap.get(string)) != null) {
            WeakReference weakReference = proxyFactory$ProxyDetails.proxyClass;
            this.thisClass = (Class)weakReference.get();
            if (this.thisClass != null) {
                return;
            }
        }
        this.createClass3(classLoader);
        proxyFactory$ProxyDetails = new ProxyFactory$ProxyDetails(this.signature, this.thisClass, this.factoryWriteReplace);
        hashMap.put(string, proxyFactory$ProxyDetails);
    }

    private void createClass3(ClassLoader classLoader) {
        this.allocateClassName();
        try {
            ClassFile classFile = this.make();
            if (this.writeDirectory != null) {
                FactoryHelper.writeFile(classFile, this.writeDirectory);
            }
            this.thisClass = FactoryHelper.toClass(classFile, classLoader, this.getDomain());
            this.setField(FILTER_SIGNATURE_FIELD, this.signature);
            if (!this.factoryUseCache) {
                this.setField(DEFAULT_INTERCEPTOR, this.handler);
            }
        }
        catch (CannotCompileException cannotCompileException) {
            throw new RuntimeException(cannotCompileException.getMessage(), cannotCompileException);
        }
    }

    private void setField(String string, Object object) {
        if (this.thisClass != null && object != null) {
            try {
                Field field = this.thisClass.getField(string);
                SecurityActions.setAccessible(field, true);
                field.set(null, object);
                SecurityActions.setAccessible(field, false);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    static byte[] getFilterSignature(Class clazz) {
        return (byte[])ProxyFactory.getField(clazz, FILTER_SIGNATURE_FIELD);
    }

    private static Object getField(Class clazz, String string) {
        try {
            Field field = clazz.getField(string);
            field.setAccessible(true);
            Object object = field.get(null);
            field.setAccessible(false);
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static MethodHandler getHandler(Proxy proxy) {
        try {
            Field field = proxy.getClass().getDeclaredField(HANDLER);
            field.setAccessible(true);
            Object object = field.get(proxy);
            field.setAccessible(false);
            return (MethodHandler)object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected ClassLoader getClassLoader() {
        return classLoaderProvider.get(this);
    }

    protected ClassLoader getClassLoader0() {
        ClassLoader classLoader = null;
        if (this.superClass != null && !this.superClass.getName().equals("java.lang.Object")) {
            classLoader = this.superClass.getClassLoader();
        } else if (this.interfaces != null && this.interfaces.length > 0) {
            classLoader = this.interfaces[0].getClassLoader();
        }
        if (classLoader == null && (classLoader = this.getClass().getClassLoader()) == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    protected ProtectionDomain getDomain() {
        Class clazz = this.superClass != null && !this.superClass.getName().equals("java.lang.Object") ? this.superClass : (this.interfaces != null && this.interfaces.length > 0 ? this.interfaces[0] : this.getClass());
        return clazz.getProtectionDomain();
    }

    public Object create(Class[] classArray, Object[] objectArray, MethodHandler methodHandler) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object object = this.create(classArray, objectArray);
        ((Proxy)object).setHandler(methodHandler);
        return object;
    }

    public Object create(Class[] classArray, Object[] objectArray) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = this.createClass();
        Constructor constructor = clazz.getConstructor(classArray);
        return constructor.newInstance(objectArray);
    }

    public void setHandler(MethodHandler methodHandler) {
        if (this.factoryUseCache && methodHandler != null) {
            this.factoryUseCache = false;
            this.thisClass = null;
        }
        this.handler = methodHandler;
        this.setField(DEFAULT_INTERCEPTOR, this.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeProxyName(String string) {
        ProxyFactory$UniqueName proxyFactory$UniqueName = nameGenerator;
        synchronized (proxyFactory$UniqueName) {
            return nameGenerator.get(string);
        }
    }

    private ClassFile make() throws CannotCompileException {
        FieldInfo fieldInfo;
        ClassFile classFile = new ClassFile(false, this.classname, this.superName);
        classFile.setAccessFlags(1);
        Class clazz = this.hasGetHandler ? (class$javassist$util$proxy$Proxy == null ? (class$javassist$util$proxy$Proxy = ProxyFactory.class$("org.zeroturnaround.bundled.javassist.util.proxy.Proxy")) : class$javassist$util$proxy$Proxy) : (class$javassist$util$proxy$ProxyObject == null ? (class$javassist$util$proxy$ProxyObject = ProxyFactory.class$("org.zeroturnaround.bundled.javassist.util.proxy.ProxyObject")) : class$javassist$util$proxy$ProxyObject);
        ProxyFactory.setInterfaces(classFile, this.interfaces, clazz);
        ConstPool constPool = classFile.getConstPool();
        if (!this.factoryUseCache) {
            fieldInfo = new FieldInfo(constPool, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
            fieldInfo.setAccessFlags(9);
            classFile.addField(fieldInfo);
        }
        fieldInfo = new FieldInfo(constPool, HANDLER, HANDLER_TYPE);
        fieldInfo.setAccessFlags(2);
        classFile.addField(fieldInfo);
        FieldInfo fieldInfo2 = new FieldInfo(constPool, FILTER_SIGNATURE_FIELD, FILTER_SIGNATURE_TYPE);
        fieldInfo2.setAccessFlags(9);
        classFile.addField(fieldInfo2);
        FieldInfo fieldInfo3 = new FieldInfo(constPool, SERIAL_VERSION_UID_FIELD, SERIAL_VERSION_UID_TYPE);
        fieldInfo3.setAccessFlags(25);
        classFile.addField(fieldInfo3);
        this.makeConstructors(this.classname, classFile, constPool, this.classname);
        ArrayList arrayList = new ArrayList();
        int n2 = this.overrideMethods(classFile, constPool, this.classname, arrayList);
        ProxyFactory.addClassInitializer(classFile, constPool, this.classname, n2, arrayList);
        ProxyFactory.addSetter(this.classname, classFile, constPool);
        if (!this.hasGetHandler) {
            ProxyFactory.addGetter(this.classname, classFile, constPool);
        }
        if (this.factoryWriteReplace) {
            try {
                classFile.addMethod(ProxyFactory.makeWriteReplace(constPool));
            }
            catch (DuplicateMemberException duplicateMemberException) {
                // empty catch block
            }
        }
        this.thisClass = null;
        return classFile;
    }

    private void checkClassAndSuperName() {
        if (this.interfaces == null) {
            this.interfaces = new Class[0];
        }
        if (this.superClass == null) {
            this.superClass = OBJECT_TYPE;
            this.superName = this.superClass.getName();
            this.basename = this.interfaces.length == 0 ? this.superName : this.interfaces[0].getName();
        } else {
            this.basename = this.superName = this.superClass.getName();
        }
        if (Modifier.isFinal(this.superClass.getModifiers())) {
            throw new RuntimeException(this.superName + " is final");
        }
        if (this.basename.startsWith("java.")) {
            this.basename = "org.javassist.tmp." + this.basename;
        }
    }

    private void allocateClassName() {
        this.classname = ProxyFactory.makeProxyName(this.basename);
    }

    private void makeSortedMethodList() {
        this.checkClassAndSuperName();
        this.hasGetHandler = false;
        HashMap hashMap = this.getMethods(this.superClass, this.interfaces);
        this.signatureMethods = new ArrayList(hashMap.entrySet());
        Collections.sort(this.signatureMethods, sorter);
    }

    private void computeSignature(MethodFilter methodFilter) {
        this.makeSortedMethodList();
        int n2 = this.signatureMethods.size();
        int n3 = n2 + 7 >> 3;
        this.signature = new byte[n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            Map.Entry entry = (Map.Entry)this.signatureMethods.get(i2);
            Method method = (Method)entry.getValue();
            int n4 = method.getModifiers();
            if (Modifier.isFinal(n4) || Modifier.isStatic(n4) || !ProxyFactory.isVisible(n4, this.basename, method) || methodFilter != null && !methodFilter.isHandled(method)) continue;
            this.setBit(this.signature, i2);
        }
    }

    private void installSignature(byte[] byArray) {
        this.makeSortedMethodList();
        int n2 = this.signatureMethods.size();
        int n3 = n2 + 7 >> 3;
        if (byArray.length != n3) {
            throw new RuntimeException("invalid filter signature length for deserialized proxy class");
        }
        this.signature = byArray;
    }

    private boolean testBit(byte[] byArray, int n2) {
        int n3 = n2 >> 3;
        if (n3 > byArray.length) {
            return false;
        }
        byte by2 = byArray[n3];
        int n4 = n2 & 7;
        int n5 = 1 << n4;
        return (by2 & n5) != 0;
    }

    private void setBit(byte[] byArray, int n2) {
        int n3 = n2 >> 3;
        if (n3 < byArray.length) {
            int n4 = n2 & 7;
            int n5 = 1 << n4;
            byte by2 = byArray[n3];
            byArray[n3] = (byte)(by2 | n5);
        }
    }

    private static void setInterfaces(ClassFile classFile, Class[] classArray, Class clazz) {
        String[] stringArray;
        String string = clazz.getName();
        if (classArray == null || classArray.length == 0) {
            stringArray = new String[]{string};
        } else {
            stringArray = new String[classArray.length + 1];
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                stringArray[i2] = classArray[i2].getName();
            }
            stringArray[classArray.length] = string;
        }
        classFile.setInterfaces(stringArray);
    }

    private static void addClassInitializer(ClassFile classFile, ConstPool constPool, String string, int n2, ArrayList arrayList) throws CannotCompileException {
        FieldInfo fieldInfo = new FieldInfo(constPool, HOLDER, HOLDER_TYPE);
        fieldInfo.setAccessFlags(10);
        classFile.addField(fieldInfo);
        MethodInfo methodInfo = new MethodInfo(constPool, "<clinit>", "()V");
        methodInfo.setAccessFlags(8);
        ProxyFactory.setThrows(methodInfo, constPool, new Class[]{class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = ProxyFactory.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException});
        Bytecode bytecode = new Bytecode(constPool, 0, 2);
        bytecode.addIconst(n2 * 2);
        bytecode.addAnewarray("java.lang.reflect.Method");
        boolean bl2 = false;
        bytecode.addAstore(0);
        bytecode.addLdc(string);
        bytecode.addInvokestatic("java.lang.Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        boolean bl3 = true;
        bytecode.addAstore(1);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ProxyFactory$Find2MethodsArgs proxyFactory$Find2MethodsArgs = (ProxyFactory$Find2MethodsArgs)iterator.next();
            ProxyFactory.callFind2Methods(bytecode, proxyFactory$Find2MethodsArgs.methodName, proxyFactory$Find2MethodsArgs.delegatorName, proxyFactory$Find2MethodsArgs.origIndex, proxyFactory$Find2MethodsArgs.descriptor, 1, 0);
        }
        bytecode.addAload(0);
        bytecode.addPutstatic(string, HOLDER, HOLDER_TYPE);
        bytecode.addLconst(-1L);
        bytecode.addPutstatic(string, SERIAL_VERSION_UID_FIELD, SERIAL_VERSION_UID_TYPE);
        bytecode.addOpcode(177);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        classFile.addMethod(methodInfo);
    }

    private static void callFind2Methods(Bytecode bytecode, String string, String string2, int n2, String string3, int n3, int n4) {
        String string4 = (class$javassist$util$proxy$RuntimeSupport == null ? (class$javassist$util$proxy$RuntimeSupport = ProxyFactory.class$(NULL_INTERCEPTOR_HOLDER)) : class$javassist$util$proxy$RuntimeSupport).getName();
        String string5 = "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;[Ljava/lang/reflect/Method;)V";
        bytecode.addAload(n3);
        bytecode.addLdc(string);
        if (string2 == null) {
            bytecode.addOpcode(1);
        } else {
            bytecode.addLdc(string2);
        }
        bytecode.addIconst(n2);
        bytecode.addLdc(string3);
        bytecode.addAload(n4);
        bytecode.addInvokestatic(string4, "find2Methods", string5);
    }

    private static void addSetter(String string, ClassFile classFile, ConstPool constPool) throws CannotCompileException {
        MethodInfo methodInfo = new MethodInfo(constPool, HANDLER_SETTER, HANDLER_SETTER_TYPE);
        methodInfo.setAccessFlags(1);
        Bytecode bytecode = new Bytecode(constPool, 2, 2);
        bytecode.addAload(0);
        bytecode.addAload(1);
        bytecode.addPutfield(string, HANDLER, HANDLER_TYPE);
        bytecode.addOpcode(177);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        classFile.addMethod(methodInfo);
    }

    private static void addGetter(String string, ClassFile classFile, ConstPool constPool) throws CannotCompileException {
        MethodInfo methodInfo = new MethodInfo(constPool, HANDLER_GETTER, HANDLER_GETTER_TYPE);
        methodInfo.setAccessFlags(1);
        Bytecode bytecode = new Bytecode(constPool, 1, 1);
        bytecode.addAload(0);
        bytecode.addGetfield(string, HANDLER, HANDLER_TYPE);
        bytecode.addOpcode(176);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        classFile.addMethod(methodInfo);
    }

    private int overrideMethods(ClassFile classFile, ConstPool constPool, String string, ArrayList arrayList) throws CannotCompileException {
        String string2 = ProxyFactory.makeUniqueName("_d", this.signatureMethods);
        Iterator iterator = this.signatureMethods.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string3 = (String)entry.getKey();
            Method method = (Method)entry.getValue();
            if ((ClassFile.MAJOR_VERSION < 49 || !ProxyFactory.isBridge(method)) && this.testBit(this.signature, n2)) {
                this.override(string, method, string2, n2, ProxyFactory.keyToDesc(string3, method), classFile, constPool, arrayList);
            }
            ++n2;
        }
        return n2;
    }

    private static boolean isBridge(Method method) {
        return method.isBridge();
    }

    private void override(String string, Method method, String string2, int n2, String string3, ClassFile classFile, ConstPool constPool, ArrayList arrayList) throws CannotCompileException {
        MethodInfo methodInfo;
        Class<?> clazz = method.getDeclaringClass();
        String string4 = string2 + n2 + method.getName();
        if (Modifier.isAbstract(method.getModifiers())) {
            string4 = null;
        } else {
            methodInfo = ProxyFactory.makeDelegator(method, string3, constPool, clazz, string4);
            methodInfo.setAccessFlags(methodInfo.getAccessFlags() & 0xFFFFFFBF);
            classFile.addMethod(methodInfo);
        }
        methodInfo = ProxyFactory.makeForwarder(string, method, string3, constPool, clazz, string4, n2, arrayList);
        classFile.addMethod(methodInfo);
    }

    private void makeConstructors(String string, ClassFile classFile, ConstPool constPool, String string2) throws CannotCompileException {
        Constructor[] constructorArray = SecurityActions.getDeclaredConstructors(this.superClass);
        boolean bl2 = !this.factoryUseCache;
        for (int i2 = 0; i2 < constructorArray.length; ++i2) {
            Constructor constructor = constructorArray[i2];
            int n2 = constructor.getModifiers();
            if (Modifier.isFinal(n2) || Modifier.isPrivate(n2) || !ProxyFactory.isVisible(n2, this.basename, constructor)) continue;
            MethodInfo methodInfo = ProxyFactory.makeConstructor(string, constructor, constPool, this.superClass, bl2);
            classFile.addMethod(methodInfo);
        }
    }

    private static String makeUniqueName(String string, List list) {
        if (ProxyFactory.makeUniqueName0(string, list.iterator())) {
            return string;
        }
        for (int i2 = 100; i2 < 999; ++i2) {
            String string2 = string + i2;
            if (!ProxyFactory.makeUniqueName0(string2, list.iterator())) continue;
            return string2;
        }
        throw new RuntimeException("cannot make a unique method name");
    }

    private static boolean makeUniqueName0(String string, Iterator iterator) {
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = (String)entry.getKey();
            if (!string2.startsWith(string)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVisible(int n2, String string, Member member) {
        if ((n2 & 2) != 0) {
            return false;
        }
        if ((n2 & 5) != 0) {
            return true;
        }
        String string2 = ProxyFactory.getPackageName(string);
        String string3 = ProxyFactory.getPackageName(member.getDeclaringClass().getName());
        if (string2 == null) {
            return string3 == null;
        }
        return string2.equals(string3);
    }

    private static String getPackageName(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return null;
        }
        return string.substring(0, n2);
    }

    private HashMap getMethods(Class clazz, Class[] classArray) {
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            this.getMethods(hashMap, classArray[i2], hashSet);
        }
        this.getMethods(hashMap, clazz, hashSet);
        return hashMap;
    }

    private void getMethods(HashMap hashMap, Class clazz, Set set) {
        if (!set.add(clazz)) {
            return;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            this.getMethods(hashMap, classArray[i2], set);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.getMethods(hashMap, clazz2, set);
        }
        Method[] methodArray = SecurityActions.getDeclaredMethods(clazz);
        for (int i3 = 0; i3 < methodArray.length; ++i3) {
            Method method;
            if (Modifier.isPrivate(methodArray[i3].getModifiers())) continue;
            Method method2 = methodArray[i3];
            String string = method2.getName() + ':' + RuntimeSupport.makeDescriptor(method2);
            if (string.startsWith(HANDLER_GETTER_KEY)) {
                this.hasGetHandler = true;
            }
            if (null == (method = hashMap.put(string, methodArray[i3])) || !Modifier.isPublic(method.getModifiers()) || Modifier.isPublic(methodArray[i3].getModifiers())) continue;
            hashMap.put(string, method);
        }
    }

    private static String keyToDesc(String string, Method method) {
        return string.substring(string.indexOf(58) + 1);
    }

    private static MethodInfo makeConstructor(String string, Constructor constructor, ConstPool constPool, Class clazz, boolean bl2) {
        String string2 = RuntimeSupport.makeDescriptor(constructor.getParameterTypes(), Void.TYPE);
        MethodInfo methodInfo = new MethodInfo(constPool, "<init>", string2);
        methodInfo.setAccessFlags(1);
        ProxyFactory.setThrows(methodInfo, constPool, constructor.getExceptionTypes());
        Bytecode bytecode = new Bytecode(constPool, 0, 0);
        if (bl2) {
            bytecode.addAload(0);
            bytecode.addGetstatic(string, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
            bytecode.addPutfield(string, HANDLER, HANDLER_TYPE);
            bytecode.addGetstatic(string, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
            bytecode.addOpcode(199);
            bytecode.addIndex(10);
        }
        bytecode.addAload(0);
        bytecode.addGetstatic(NULL_INTERCEPTOR_HOLDER, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
        bytecode.addPutfield(string, HANDLER, HANDLER_TYPE);
        int n2 = bytecode.currentPc();
        bytecode.addAload(0);
        int n3 = ProxyFactory.addLoadParameters(bytecode, constructor.getParameterTypes(), 1);
        bytecode.addInvokespecial(clazz.getName(), "<init>", string2);
        bytecode.addOpcode(177);
        bytecode.setMaxLocals(n3 + 1);
        CodeAttribute codeAttribute = bytecode.toCodeAttribute();
        methodInfo.setCodeAttribute(codeAttribute);
        StackMapTable$Writer stackMapTable$Writer = new StackMapTable$Writer(32);
        stackMapTable$Writer.sameFrame(n2);
        codeAttribute.setAttribute(stackMapTable$Writer.toStackMapTable(constPool));
        return methodInfo;
    }

    private static MethodInfo makeDelegator(Method method, String string, ConstPool constPool, Class clazz, String string2) {
        MethodInfo methodInfo = new MethodInfo(constPool, string2, string);
        methodInfo.setAccessFlags(0x11 | method.getModifiers() & 0xFFFFFAD9);
        ProxyFactory.setThrows(methodInfo, constPool, method);
        Bytecode bytecode = new Bytecode(constPool, 0, 0);
        bytecode.addAload(0);
        int n2 = ProxyFactory.addLoadParameters(bytecode, method.getParameterTypes(), 1);
        bytecode.addInvokespecial(clazz.getName(), method.getName(), string);
        ProxyFactory.addReturn(bytecode, method.getReturnType());
        bytecode.setMaxLocals(++n2);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        return methodInfo;
    }

    private static MethodInfo makeForwarder(String string, Method method, String string2, ConstPool constPool, Class clazz, String string3, int n2, ArrayList arrayList) {
        MethodInfo methodInfo = new MethodInfo(constPool, method.getName(), string2);
        methodInfo.setAccessFlags(0x10 | method.getModifiers() & 0xFFFFFADF);
        ProxyFactory.setThrows(methodInfo, constPool, method);
        int n3 = Descriptor.paramSize(string2);
        Bytecode bytecode = new Bytecode(constPool, 0, n3 + 2);
        int n4 = n2 * 2;
        int n5 = n2 * 2 + 1;
        int n6 = n3 + 1;
        bytecode.addGetstatic(string, HOLDER, HOLDER_TYPE);
        bytecode.addAstore(n6);
        arrayList.add(new ProxyFactory$Find2MethodsArgs(method.getName(), string3, string2, n4));
        bytecode.addAload(0);
        bytecode.addGetfield(string, HANDLER, HANDLER_TYPE);
        bytecode.addAload(0);
        bytecode.addAload(n6);
        bytecode.addIconst(n4);
        bytecode.addOpcode(50);
        bytecode.addAload(n6);
        bytecode.addIconst(n5);
        bytecode.addOpcode(50);
        ProxyFactory.makeParameterList(bytecode, method.getParameterTypes());
        bytecode.addInvokeinterface((class$javassist$util$proxy$MethodHandler == null ? (class$javassist$util$proxy$MethodHandler = ProxyFactory.class$("org.zeroturnaround.bundled.javassist.util.proxy.MethodHandler")) : class$javassist$util$proxy$MethodHandler).getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", 5);
        Class<?> clazz2 = method.getReturnType();
        ProxyFactory.addUnwrapper(bytecode, clazz2);
        ProxyFactory.addReturn(bytecode, clazz2);
        CodeAttribute codeAttribute = bytecode.toCodeAttribute();
        methodInfo.setCodeAttribute(codeAttribute);
        return methodInfo;
    }

    private static void setThrows(MethodInfo methodInfo, ConstPool constPool, Method method) {
        Class[] classArray = method.getExceptionTypes();
        ProxyFactory.setThrows(methodInfo, constPool, classArray);
    }

    private static void setThrows(MethodInfo methodInfo, ConstPool constPool, Class[] classArray) {
        if (classArray.length == 0) {
            return;
        }
        String[] stringArray = new String[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringArray[i2] = classArray[i2].getName();
        }
        ExceptionsAttribute exceptionsAttribute = new ExceptionsAttribute(constPool);
        exceptionsAttribute.setExceptions(stringArray);
        methodInfo.setExceptionsAttribute(exceptionsAttribute);
    }

    private static int addLoadParameters(Bytecode bytecode, Class[] classArray, int n2) {
        int n3 = 0;
        int n4 = classArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 += ProxyFactory.addLoad(bytecode, n3 + n2, classArray[i2]);
        }
        return n3;
    }

    private static int addLoad(Bytecode bytecode, int n2, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Long.TYPE) {
                bytecode.addLload(n2);
                return 2;
            }
            if (clazz == Float.TYPE) {
                bytecode.addFload(n2);
            } else {
                if (clazz == Double.TYPE) {
                    bytecode.addDload(n2);
                    return 2;
                }
                bytecode.addIload(n2);
            }
        } else {
            bytecode.addAload(n2);
        }
        return 1;
    }

    private static int addReturn(Bytecode bytecode, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Long.TYPE) {
                bytecode.addOpcode(173);
                return 2;
            }
            if (clazz == Float.TYPE) {
                bytecode.addOpcode(174);
            } else {
                if (clazz == Double.TYPE) {
                    bytecode.addOpcode(175);
                    return 2;
                }
                if (clazz == Void.TYPE) {
                    bytecode.addOpcode(177);
                    return 0;
                }
                bytecode.addOpcode(172);
            }
        } else {
            bytecode.addOpcode(176);
        }
        return 1;
    }

    private static void makeParameterList(Bytecode bytecode, Class[] classArray) {
        int n2 = 1;
        int n3 = classArray.length;
        bytecode.addIconst(n3);
        bytecode.addAnewarray("java/lang/Object");
        for (int i2 = 0; i2 < n3; ++i2) {
            bytecode.addOpcode(89);
            bytecode.addIconst(i2);
            Class clazz = classArray[i2];
            if (clazz.isPrimitive()) {
                n2 = ProxyFactory.makeWrapper(bytecode, clazz, n2);
            } else {
                bytecode.addAload(n2);
                ++n2;
            }
            bytecode.addOpcode(83);
        }
    }

    private static int makeWrapper(Bytecode bytecode, Class clazz, int n2) {
        int n3 = FactoryHelper.typeIndex(clazz);
        String string = FactoryHelper.wrapperTypes[n3];
        bytecode.addNew(string);
        bytecode.addOpcode(89);
        ProxyFactory.addLoad(bytecode, n2, clazz);
        bytecode.addInvokespecial(string, "<init>", FactoryHelper.wrapperDesc[n3]);
        return n2 + FactoryHelper.dataSize[n3];
    }

    private static void addUnwrapper(Bytecode bytecode, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                bytecode.addOpcode(87);
            } else {
                int n2 = FactoryHelper.typeIndex(clazz);
                String string = FactoryHelper.wrapperTypes[n2];
                bytecode.addCheckcast(string);
                bytecode.addInvokevirtual(string, FactoryHelper.unwarpMethods[n2], FactoryHelper.unwrapDesc[n2]);
            }
        } else {
            bytecode.addCheckcast(clazz.getName());
        }
    }

    private static MethodInfo makeWriteReplace(ConstPool constPool) {
        MethodInfo methodInfo = new MethodInfo(constPool, "writeReplace", "()Ljava/lang/Object;");
        String[] stringArray = new String[]{"java.io.ObjectStreamException"};
        ExceptionsAttribute exceptionsAttribute = new ExceptionsAttribute(constPool);
        exceptionsAttribute.setExceptions(stringArray);
        methodInfo.setExceptionsAttribute(exceptionsAttribute);
        Bytecode bytecode = new Bytecode(constPool, 0, 1);
        bytecode.addAload(0);
        bytecode.addInvokestatic(NULL_INTERCEPTOR_HOLDER, "makeSerializedProxy", "(Ljava/lang/Object;)Ljavassist/util/proxy/SerializedProxy;");
        bytecode.addOpcode(176);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        return methodInfo;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

