/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.expr;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.Javac;
import org.zeroturnaround.bundled.javassist.expr.Expr;

public class Handler
extends Expr {
    private static String EXCEPTION_NAME = "$1";
    private ExceptionTable etable;
    private int index;

    protected Handler(ExceptionTable exceptionTable, int n2, CodeIterator codeIterator, CtClass ctClass, MethodInfo methodInfo) {
        super(exceptionTable.handlerPc(n2), codeIterator, ctClass, methodInfo);
        this.etable = exceptionTable;
        this.index = n2;
    }

    public CtBehavior where() {
        return super.where();
    }

    public int getLineNumber() {
        return super.getLineNumber();
    }

    public String getFileName() {
        return super.getFileName();
    }

    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    public CtClass getType() throws NotFoundException {
        int n2 = this.etable.catchType(this.index);
        if (n2 == 0) {
            return null;
        }
        ConstPool constPool = this.getConstPool();
        String string = constPool.getClassInfo(n2);
        return this.thisClass.getClassPool().getCtClass(string);
    }

    public boolean isFinally() {
        return this.etable.catchType(this.index) == 0;
    }

    public void replace(String string) throws CannotCompileException {
        throw new RuntimeException("not implemented yet");
    }

    public void insertBefore(String string) throws CannotCompileException {
        this.edited = true;
        ConstPool constPool = this.getConstPool();
        CodeAttribute codeAttribute = this.iterator.get();
        Javac javac = new Javac(this.thisClass);
        Bytecode bytecode = javac.getBytecode();
        bytecode.setStackDepth(1);
        bytecode.setMaxLocals(codeAttribute.getMaxLocals());
        try {
            CtClass ctClass = this.getType();
            int n2 = javac.recordVariable(ctClass, EXCEPTION_NAME);
            javac.recordReturnType(ctClass, false);
            bytecode.addAstore(n2);
            javac.compileStmnt(string);
            bytecode.addAload(n2);
            int n3 = this.etable.handlerPc(this.index);
            bytecode.addOpcode(167);
            bytecode.addIndex(n3 - this.iterator.getCodeLength() - bytecode.currentPc() + 1);
            this.maxStack = bytecode.getMaxStack();
            this.maxLocals = bytecode.getMaxLocals();
            int n4 = this.iterator.append(bytecode.get());
            this.iterator.append(bytecode.getExceptionTable(), n4);
            this.etable.setHandlerPc(this.index, n4);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
    }
}

