/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.compiler.ast;

import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;
import org.zeroturnaround.bundled.javassist.compiler.ast.DoubleConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Visitor;

public class IntConst
extends ASTree {
    protected long value;
    protected int type;

    public IntConst(long l2, int n2) {
        this.value = l2;
        this.type = n2;
    }

    public long get() {
        return this.value;
    }

    public void set(long l2) {
        this.value = l2;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public void accept(Visitor visitor) throws CompileError {
        visitor.atIntConst(this);
    }

    public ASTree compute(int n2, ASTree aSTree) {
        if (aSTree instanceof IntConst) {
            return this.compute0(n2, (IntConst)aSTree);
        }
        if (aSTree instanceof DoubleConst) {
            return this.compute0(n2, (DoubleConst)aSTree);
        }
        return null;
    }

    private IntConst compute0(int n2, IntConst intConst) {
        long l2;
        int n3 = this.type;
        int n4 = intConst.type;
        int n5 = n3 == 403 || n4 == 403 ? 403 : (n3 == 401 && n4 == 401 ? 401 : 402);
        long l3 = this.value;
        long l4 = intConst.value;
        switch (n2) {
            case 43: {
                l2 = l3 + l4;
                break;
            }
            case 45: {
                l2 = l3 - l4;
                break;
            }
            case 42: {
                l2 = l3 * l4;
                break;
            }
            case 47: {
                l2 = l3 / l4;
                break;
            }
            case 37: {
                l2 = l3 % l4;
                break;
            }
            case 124: {
                l2 = l3 | l4;
                break;
            }
            case 94: {
                l2 = l3 ^ l4;
                break;
            }
            case 38: {
                l2 = l3 & l4;
                break;
            }
            case 364: {
                l2 = this.value << (int)l4;
                n5 = n3;
                break;
            }
            case 366: {
                l2 = this.value >> (int)l4;
                n5 = n3;
                break;
            }
            case 370: {
                l2 = this.value >>> (int)l4;
                n5 = n3;
                break;
            }
            default: {
                return null;
            }
        }
        return new IntConst(l2, n5);
    }

    private DoubleConst compute0(int n2, DoubleConst doubleConst) {
        double d2;
        double d3 = this.value;
        double d4 = doubleConst.value;
        switch (n2) {
            case 43: {
                d2 = d3 + d4;
                break;
            }
            case 45: {
                d2 = d3 - d4;
                break;
            }
            case 42: {
                d2 = d3 * d4;
                break;
            }
            case 47: {
                d2 = d3 / d4;
                break;
            }
            case 37: {
                d2 = d3 % d4;
                break;
            }
            default: {
                return null;
            }
        }
        return new DoubleConst(d2, doubleConst.type);
    }
}

