/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.stackmap;

import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.BasicBlock;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$ClassName;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$UninitThis;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeTag;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypedBlock$Maker;

public class TypedBlock
extends BasicBlock {
    public int stackTop;
    public int numLocals;
    public TypeData[] localsTypes = null;
    public TypeData[] stackTypes;

    public static TypedBlock[] makeBlocks(MethodInfo methodInfo, CodeAttribute codeAttribute, boolean bl2) throws BadBytecode {
        TypedBlock[] typedBlockArray = (TypedBlock[])new TypedBlock$Maker().make(methodInfo);
        if (bl2 && typedBlockArray.length < 2 && (typedBlockArray.length == 0 || typedBlockArray[0].incoming == 0)) {
            return null;
        }
        ConstPool constPool = methodInfo.getConstPool();
        boolean bl3 = (methodInfo.getAccessFlags() & 8) != 0;
        typedBlockArray[0].initFirstBlock(codeAttribute.getMaxStack(), codeAttribute.getMaxLocals(), constPool.getClassName(), methodInfo.getDescriptor(), bl3, methodInfo.isConstructor());
        return typedBlockArray;
    }

    protected TypedBlock(int n2) {
        super(n2);
    }

    protected void toString2(StringBuffer stringBuffer) {
        super.toString2(stringBuffer);
        stringBuffer.append(",\n stack={");
        this.printTypes(stringBuffer, this.stackTop, this.stackTypes);
        stringBuffer.append("}, locals={");
        this.printTypes(stringBuffer, this.numLocals, this.localsTypes);
        stringBuffer.append('}');
    }

    private void printTypes(StringBuffer stringBuffer, int n2, TypeData[] typeDataArray) {
        if (typeDataArray == null) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData typeData;
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((typeData = typeDataArray[i2]) == null ? "<>" : typeData.toString());
        }
    }

    public boolean alreadySet() {
        return this.localsTypes != null;
    }

    public void setStackMap(int n2, TypeData[] typeDataArray, int n3, TypeData[] typeDataArray2) throws BadBytecode {
        this.stackTop = n2;
        this.stackTypes = typeDataArray;
        this.numLocals = n3;
        this.localsTypes = typeDataArray2;
    }

    public void resetNumLocals() {
        if (this.localsTypes != null) {
            int n2;
            for (n2 = this.localsTypes.length; !(n2 <= 0 || this.localsTypes[n2 - 1].isBasicType() != TypeTag.TOP || n2 > 1 && this.localsTypes[n2 - 2].is2WordType()); --n2) {
            }
            this.numLocals = n2;
        }
    }

    void initFirstBlock(int n2, int n3, String string, String string2, boolean bl2, boolean bl3) throws BadBytecode {
        if (string2.charAt(0) != '(') {
            throw new BadBytecode("no method descriptor: " + string2);
        }
        this.stackTop = 0;
        this.stackTypes = TypeData.make(n2);
        TypeData[] typeDataArray = TypeData.make(n3);
        if (bl3) {
            typeDataArray[0] = new TypeData$UninitThis(string);
        } else if (!bl2) {
            typeDataArray[0] = new TypeData$ClassName(string);
        }
        int n4 = bl2 ? -1 : 0;
        int n5 = 1;
        try {
            while ((n5 = TypedBlock.descToTag(string2, n5, ++n4, typeDataArray)) > 0) {
                if (!typeDataArray[n4].is2WordType()) continue;
                typeDataArray[++n4] = TypeTag.TOP;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new BadBytecode("bad method descriptor: " + string2);
        }
        this.numLocals = n4;
        this.localsTypes = typeDataArray;
    }

    private static int descToTag(String string, int n2, int n3, TypeData[] typeDataArray) throws BadBytecode {
        int n4 = n2;
        int n5 = 0;
        char c2 = string.charAt(n2);
        if (c2 == ')') {
            return 0;
        }
        while (c2 == '[') {
            ++n5;
            c2 = string.charAt(++n2);
        }
        if (c2 == 'L') {
            int n6 = string.indexOf(59, ++n2);
            typeDataArray[n3] = n5 > 0 ? new TypeData$ClassName(string.substring(n4, ++n6)) : new TypeData$ClassName(string.substring(n4 + 1, ++n6 - 1).replace('/', '.'));
            return n6;
        }
        if (n5 > 0) {
            typeDataArray[n3] = new TypeData$ClassName(string.substring(n4, ++n2));
            return n2;
        }
        TypeData typeData = TypedBlock.toPrimitiveTag(c2);
        if (typeData == null) {
            throw new BadBytecode("bad method descriptor: " + string);
        }
        typeDataArray[n3] = typeData;
        return n2 + 1;
    }

    private static TypeData toPrimitiveTag(char c2) {
        switch (c2) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return TypeTag.INTEGER;
            }
            case 'J': {
                return TypeTag.LONG;
            }
            case 'F': {
                return TypeTag.FLOAT;
            }
            case 'D': {
                return TypeTag.DOUBLE;
            }
        }
        return null;
    }

    public static String getRetType(String string) {
        int n2 = string.indexOf(41);
        if (n2 < 0) {
            return "java.lang.Object";
        }
        char c2 = string.charAt(n2 + 1);
        if (c2 == '[') {
            return string.substring(n2 + 1);
        }
        if (c2 == 'L') {
            return string.substring(n2 + 2, string.length() - 1).replace('/', '.');
        }
        return "java.lang.Object";
    }
}

