/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.stackmap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$AbsTypeVar;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$BasicType;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeTag;

public class TypeData$TypeVar
extends TypeData$AbsTypeVar {
    protected ArrayList lowers = new ArrayList(2);
    protected ArrayList usedBy = new ArrayList(2);
    protected ArrayList uppers = null;
    protected String fixedType;
    private int visited = 0;
    private int smallest = 0;
    private boolean inList = false;

    public TypeData$TypeVar(TypeData typeData) {
        this.merge(typeData);
        this.fixedType = null;
    }

    public String getName() {
        if (this.fixedType == null) {
            return ((TypeData)this.lowers.get(0)).getName();
        }
        return this.fixedType;
    }

    public TypeData$BasicType isBasicType() {
        if (this.fixedType == null) {
            return ((TypeData)this.lowers.get(0)).isBasicType();
        }
        return null;
    }

    public boolean is2WordType() {
        if (this.fixedType == null) {
            return ((TypeData)this.lowers.get(0)).is2WordType();
        }
        return false;
    }

    public boolean isNullType() {
        if (this.fixedType == null) {
            return ((TypeData)this.lowers.get(0)).isNullType();
        }
        return false;
    }

    public boolean isUninit() {
        if (this.fixedType == null) {
            return ((TypeData)this.lowers.get(0)).isUninit();
        }
        return false;
    }

    public void merge(TypeData typeData) {
        this.lowers.add(typeData);
        if (typeData instanceof TypeData$TypeVar) {
            ((TypeData$TypeVar)typeData).usedBy.add(this);
        }
    }

    public int getTypeTag() {
        if (this.fixedType == null) {
            return ((TypeData)this.lowers.get(0)).getTypeTag();
        }
        return super.getTypeTag();
    }

    public int getTypeData(ConstPool constPool) {
        if (this.fixedType == null) {
            return ((TypeData)this.lowers.get(0)).getTypeData(constPool);
        }
        return super.getTypeData(constPool);
    }

    public void setType(String string, ClassPool classPool) throws BadBytecode {
        if (this.uppers == null) {
            this.uppers = new ArrayList();
        }
        this.uppers.add(string);
    }

    protected TypeData$TypeVar toTypeVar() {
        return this;
    }

    public int dfs(ArrayList arrayList, int n2, ClassPool classPool) throws NotFoundException {
        TypeData$TypeVar typeData$TypeVar;
        if (this.visited > 0) {
            return n2;
        }
        this.visited = this.smallest = ++n2;
        arrayList.add(this);
        this.inList = true;
        int n3 = this.lowers.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            typeData$TypeVar = ((TypeData)this.lowers.get(i2)).toTypeVar();
            if (typeData$TypeVar == null) continue;
            if (typeData$TypeVar.visited == 0) {
                n2 = typeData$TypeVar.dfs(arrayList, n2, classPool);
                if (typeData$TypeVar.smallest >= this.smallest) continue;
                this.smallest = typeData$TypeVar.smallest;
                continue;
            }
            if (!typeData$TypeVar.inList || typeData$TypeVar.visited >= this.smallest) continue;
            this.smallest = typeData$TypeVar.visited;
        }
        if (this.visited == this.smallest) {
            ArrayList<TypeData$TypeVar> arrayList2 = new ArrayList<TypeData$TypeVar>();
            do {
                typeData$TypeVar = (TypeData$TypeVar)arrayList.remove(arrayList.size() - 1);
                typeData$TypeVar.inList = false;
                arrayList2.add(typeData$TypeVar);
            } while (typeData$TypeVar != this);
            this.fixTypes(arrayList2, classPool);
        }
        return n2;
    }

    private void fixTypes(ArrayList arrayList, ClassPool classPool) throws NotFoundException {
        Object object;
        int n2;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = false;
        TypeData typeData = null;
        int n3 = arrayList.size();
        block0: for (n2 = 0; n2 < n3; ++n2) {
            object = ((TypeData$TypeVar)arrayList.get((int)n2)).lowers;
            int n4 = ((ArrayList)object).size();
            for (int i2 = 0; i2 < n4; ++i2) {
                TypeData typeData2 = (TypeData)((ArrayList)object).get(i2);
                TypeData$BasicType typeData$BasicType = typeData2.isBasicType();
                if (typeData == null) {
                    if (typeData$BasicType == null) {
                        bl2 = false;
                        typeData = typeData2;
                        if (typeData2.isUninit()) {
                            continue block0;
                        }
                    } else {
                        bl2 = true;
                        typeData = typeData$BasicType;
                    }
                } else if (typeData$BasicType == null && bl2 || typeData$BasicType != null && typeData != typeData$BasicType) {
                    bl2 = true;
                    typeData = TypeTag.TOP;
                    continue block0;
                }
                if (typeData$BasicType != null || typeData2.isNullType()) continue;
                hashSet.add(typeData2.getName());
            }
        }
        if (bl2) {
            for (n2 = 0; n2 < n3; ++n2) {
                object = (TypeData$TypeVar)arrayList.get(n2);
                ((TypeData$TypeVar)object).lowers.clear();
                ((TypeData$TypeVar)object).lowers.add(typeData);
            }
        } else {
            String string = this.fixTypes2(arrayList, hashSet, classPool);
            for (int i3 = 0; i3 < n3; ++i3) {
                TypeData$TypeVar typeData$TypeVar = (TypeData$TypeVar)arrayList.get(i3);
                typeData$TypeVar.fixedType = string;
            }
        }
    }

    private String fixTypes2(ArrayList arrayList, HashSet hashSet, ClassPool classPool) throws NotFoundException {
        Iterator iterator = hashSet.iterator();
        if (hashSet.size() == 0) {
            return null;
        }
        if (hashSet.size() == 1) {
            return (String)iterator.next();
        }
        CtClass ctClass = classPool.get((String)iterator.next());
        while (iterator.hasNext()) {
            ctClass = TypeData$TypeVar.commonSuperClassEx(ctClass, classPool.get((String)iterator.next()));
        }
        if (ctClass.getSuperclass() == null || TypeData$TypeVar.isObjectArray(ctClass)) {
            ctClass = this.fixByUppers(arrayList, classPool, new HashSet(), ctClass);
        }
        if (ctClass.isArray()) {
            return Descriptor.toJvmName(ctClass);
        }
        return ctClass.getName();
    }

    private static boolean isObjectArray(CtClass ctClass) throws NotFoundException {
        return ctClass.isArray() && ctClass.getComponentType().getSuperclass() == null;
    }

    private CtClass fixByUppers(ArrayList arrayList, ClassPool classPool, HashSet hashSet, CtClass ctClass) throws NotFoundException {
        if (arrayList == null) {
            return ctClass;
        }
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData$TypeVar typeData$TypeVar = (TypeData$TypeVar)arrayList.get(i2);
            if (!hashSet.add(typeData$TypeVar)) {
                return ctClass;
            }
            if (typeData$TypeVar.uppers != null) {
                int n3 = typeData$TypeVar.uppers.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    CtClass ctClass2 = classPool.get((String)typeData$TypeVar.uppers.get(i3));
                    if (!ctClass2.subtypeOf(ctClass)) continue;
                    ctClass = ctClass2;
                }
            }
            ctClass = this.fixByUppers(typeData$TypeVar.usedBy, classPool, hashSet, ctClass);
        }
        return ctClass;
    }
}

