/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class ShortMemberValue
extends MemberValue {
    int valueIndex;

    public ShortMemberValue(int n2, ConstPool constPool) {
        super('S', constPool);
        this.valueIndex = n2;
    }

    public ShortMemberValue(short s2, ConstPool constPool) {
        super('S', constPool);
        this.setValue(s2);
    }

    public ShortMemberValue(ConstPool constPool) {
        super('S', constPool);
        this.setValue((short)0);
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Short(this.getValue());
    }

    Class getType(ClassLoader classLoader) {
        return Short.TYPE;
    }

    public short getValue() {
        return (short)this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(short s2) {
        this.valueIndex = this.cp.addIntegerInfo(s2);
    }

    public String toString() {
        return Short.toString(this.getValue());
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitShortMemberValue(this);
    }
}

