/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class LongMemberValue
extends MemberValue {
    int valueIndex;

    public LongMemberValue(int n2, ConstPool constPool) {
        super('J', constPool);
        this.valueIndex = n2;
    }

    public LongMemberValue(long l2, ConstPool constPool) {
        super('J', constPool);
        this.setValue(l2);
    }

    public LongMemberValue(ConstPool constPool) {
        super('J', constPool);
        this.setValue(0L);
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Long(this.getValue());
    }

    Class getType(ClassLoader classLoader) {
        return Long.TYPE;
    }

    public long getValue() {
        return this.cp.getLongInfo(this.valueIndex);
    }

    public void setValue(long l2) {
        this.valueIndex = this.cp.addLongInfo(l2);
    }

    public String toString() {
        return Long.toString(this.getValue());
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitLongMemberValue(this);
    }
}

