/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class IntegerMemberValue
extends MemberValue {
    int valueIndex;

    public IntegerMemberValue(int n2, ConstPool constPool) {
        super('I', constPool);
        this.valueIndex = n2;
    }

    public IntegerMemberValue(ConstPool constPool, int n2) {
        super('I', constPool);
        this.setValue(n2);
    }

    public IntegerMemberValue(ConstPool constPool) {
        super('I', constPool);
        this.setValue(0);
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Integer(this.getValue());
    }

    Class getType(ClassLoader classLoader) {
        return Integer.TYPE;
    }

    public int getValue() {
        return this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(int n2) {
        this.valueIndex = this.cp.addIntegerInfo(n2);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitIntegerMemberValue(this);
    }
}

