/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class ClassMemberValue
extends MemberValue {
    int valueIndex;

    public ClassMemberValue(int n2, ConstPool constPool) {
        super('c', constPool);
        this.valueIndex = n2;
    }

    public ClassMemberValue(String string, ConstPool constPool) {
        super('c', constPool);
        this.setValue(string);
    }

    public ClassMemberValue(ConstPool constPool) {
        super('c', constPool);
        this.setValue("java.lang.Class");
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) throws ClassNotFoundException {
        String string = this.getValue();
        if (string.equals("void")) {
            return Void.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        return ClassMemberValue.loadClass(classLoader, string);
    }

    Class getType(ClassLoader classLoader) throws ClassNotFoundException {
        return ClassMemberValue.loadClass(classLoader, "java.lang.Class");
    }

    public String getValue() {
        String string = this.cp.getUtf8Info(this.valueIndex);
        try {
            return SignatureAttribute.toTypeSignature(string).toString();
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    public void setValue(String string) {
        String string2 = Descriptor.of(string);
        this.valueIndex = this.cp.addUtf8Info(string2);
    }

    public String toString() {
        return this.getValue() + ".class";
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.classInfoIndex(this.cp.getUtf8Info(this.valueIndex));
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitClassMemberValue(this);
    }
}

