/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.analysis;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.MultiType;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Type;

public class MultiArrayType
extends Type {
    private MultiType component;
    private int dims;

    public MultiArrayType(MultiType multiType, int n2) {
        super(null);
        this.component = multiType;
        this.dims = n2;
    }

    public CtClass getCtClass() {
        CtClass ctClass = this.component.getCtClass();
        if (ctClass == null) {
            return null;
        }
        ClassPool classPool = ctClass.getClassPool();
        if (classPool == null) {
            classPool = ClassPool.getDefault();
        }
        String string = this.arrayName(ctClass.getName(), this.dims);
        try {
            return classPool.get(string);
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    boolean popChanged() {
        return this.component.popChanged();
    }

    public int getDimensions() {
        return this.dims;
    }

    public Type getComponent() {
        return this.dims == 1 ? this.component : new MultiArrayType(this.component, this.dims - 1);
    }

    public int getSize() {
        return 1;
    }

    public boolean isArray() {
        return true;
    }

    public boolean isAssignableFrom(Type type) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isReference() {
        return true;
    }

    public boolean isAssignableTo(Type type) {
        if (MultiArrayType.eq(type.getCtClass(), Type.OBJECT.getCtClass())) {
            return true;
        }
        if (MultiArrayType.eq(type.getCtClass(), Type.CLONEABLE.getCtClass())) {
            return true;
        }
        if (MultiArrayType.eq(type.getCtClass(), Type.SERIALIZABLE.getCtClass())) {
            return true;
        }
        if (!type.isArray()) {
            return false;
        }
        Type type2 = this.getRootComponent(type);
        int n2 = type.getDimensions();
        if (n2 > this.dims) {
            return false;
        }
        if (n2 < this.dims) {
            if (MultiArrayType.eq(type2.getCtClass(), Type.OBJECT.getCtClass())) {
                return true;
            }
            if (MultiArrayType.eq(type2.getCtClass(), Type.CLONEABLE.getCtClass())) {
                return true;
            }
            return MultiArrayType.eq(type2.getCtClass(), Type.SERIALIZABLE.getCtClass());
        }
        return this.component.isAssignableTo(type2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MultiArrayType)) {
            return false;
        }
        MultiArrayType multiArrayType = (MultiArrayType)object;
        return this.component.equals(multiArrayType.component) && this.dims == multiArrayType.dims;
    }

    public String toString() {
        return this.arrayName(this.component.toString(), this.dims);
    }
}

