/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.analysis;

import org.zeroturnaround.bundled.javassist.bytecode.analysis.Type;

public class Frame {
    private Type[] locals;
    private Type[] stack;
    private int top;
    private boolean jsrMerged;
    private boolean retMerged;

    public Frame(int n2, int n3) {
        this.locals = new Type[n2];
        this.stack = new Type[n3];
    }

    public Type getLocal(int n2) {
        return this.locals[n2];
    }

    public void setLocal(int n2, Type type) {
        this.locals[n2] = type;
    }

    public Type getStack(int n2) {
        return this.stack[n2];
    }

    public void setStack(int n2, Type type) {
        this.stack[n2] = type;
    }

    public void clearStack() {
        this.top = 0;
    }

    public int getTopIndex() {
        return this.top - 1;
    }

    public int localsLength() {
        return this.locals.length;
    }

    public Type peek() {
        if (this.top < 1) {
            throw new IndexOutOfBoundsException("Stack is empty");
        }
        return this.stack[this.top - 1];
    }

    public Type pop() {
        if (this.top < 1) {
            throw new IndexOutOfBoundsException("Stack is empty");
        }
        return this.stack[--this.top];
    }

    public void push(Type type) {
        this.stack[this.top++] = type;
    }

    public Frame copy() {
        Frame frame = new Frame(this.locals.length, this.stack.length);
        System.arraycopy(this.locals, 0, frame.locals, 0, this.locals.length);
        System.arraycopy(this.stack, 0, frame.stack, 0, this.stack.length);
        frame.top = this.top;
        return frame;
    }

    public Frame copyStack() {
        Frame frame = new Frame(this.locals.length, this.stack.length);
        System.arraycopy(this.stack, 0, frame.stack, 0, this.stack.length);
        frame.top = this.top;
        return frame;
    }

    public boolean mergeStack(Frame frame) {
        boolean bl2 = false;
        if (this.top != frame.top) {
            throw new RuntimeException("Operand stacks could not be merged, they are different sizes!");
        }
        for (int i2 = 0; i2 < this.top; ++i2) {
            if (this.stack[i2] == null) continue;
            Type type = this.stack[i2];
            Type type2 = type.merge(frame.stack[i2]);
            if (type2 == Type.BOGUS) {
                throw new RuntimeException("Operand stacks could not be merged due to differing primitive types: pos = " + i2);
            }
            this.stack[i2] = type2;
            if (type2.equals(type) && !type2.popChanged()) continue;
            bl2 = true;
        }
        return bl2;
    }

    public boolean merge(Frame frame) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2] != null) {
                Type type;
                Type type2 = this.locals[i2];
                this.locals[i2] = type = type2.merge(frame.locals[i2]);
                if (type.equals(type2) && !type.popChanged()) continue;
                bl2 = true;
                continue;
            }
            if (frame.locals[i2] == null) continue;
            this.locals[i2] = frame.locals[i2];
            bl2 = true;
        }
        return bl2 |= this.mergeStack(frame);
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("locals = [");
        for (n2 = 0; n2 < this.locals.length; ++n2) {
            stringBuffer.append(this.locals[n2] == null ? "empty" : this.locals[n2].toString());
            if (n2 >= this.locals.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("] stack = [");
        for (n2 = 0; n2 < this.top; ++n2) {
            stringBuffer.append(this.stack[n2]);
            if (n2 >= this.top - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    boolean isJsrMerged() {
        return this.jsrMerged;
    }

    void setJsrMerged(boolean bl2) {
        this.jsrMerged = bl2;
    }

    boolean isRetMerged() {
        return this.retMerged;
    }

    void setRetMerged(boolean bl2) {
        this.retMerged = bl2;
    }
}

