/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.ConstInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;

class InvokeDynamicInfo
extends ConstInfo {
    static final int tag = 18;
    int bootstrap;
    int nameAndType;

    public InvokeDynamicInfo(int n2, int n3, int n4) {
        super(n4);
        this.bootstrap = n2;
        this.nameAndType = n3;
    }

    public InvokeDynamicInfo(DataInputStream dataInputStream, int n2) throws IOException {
        super(n2);
        this.bootstrap = dataInputStream.readUnsignedShort();
        this.nameAndType = dataInputStream.readUnsignedShort();
    }

    public int hashCode() {
        return this.bootstrap << 16 ^ this.nameAndType;
    }

    public boolean equals(Object object) {
        if (object instanceof InvokeDynamicInfo) {
            InvokeDynamicInfo invokeDynamicInfo = (InvokeDynamicInfo)object;
            return invokeDynamicInfo.bootstrap == this.bootstrap && invokeDynamicInfo.nameAndType == this.nameAndType;
        }
        return false;
    }

    public int getTag() {
        return 18;
    }

    public int copy(ConstPool constPool, ConstPool constPool2, Map map) {
        return constPool2.addInvokeDynamicInfo(this.bootstrap, constPool.getItem(this.nameAndType).copy(constPool, constPool2, map));
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(18);
        dataOutputStream.writeShort(this.bootstrap);
        dataOutputStream.writeShort(this.nameAndType);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("InvokeDynamic #");
        printWriter.print(this.bootstrap);
        printWriter.print(", name&type #");
        printWriter.println(this.nameAndType);
    }
}

