/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;

public class InnerClassesAttribute
extends AttributeInfo {
    public static final String tag = "InnerClasses";

    InnerClassesAttribute(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        super(constPool, n2, dataInputStream);
    }

    private InnerClassesAttribute(ConstPool constPool, byte[] byArray) {
        super(constPool, tag, byArray);
    }

    public InnerClassesAttribute(ConstPool constPool) {
        super(constPool, tag, new byte[2]);
        ByteArray.write16bit(0, this.get(), 0);
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.get(), 0);
    }

    public int innerClassIndex(int n2) {
        return ByteArray.readU16bit(this.get(), n2 * 8 + 2);
    }

    public String innerClass(int n2) {
        int n3 = this.innerClassIndex(n2);
        if (n3 == 0) {
            return null;
        }
        return this.constPool.getClassInfo(n3);
    }

    public void setInnerClassIndex(int n2, int n3) {
        ByteArray.write16bit(n3, this.get(), n2 * 8 + 2);
    }

    public int outerClassIndex(int n2) {
        return ByteArray.readU16bit(this.get(), n2 * 8 + 4);
    }

    public String outerClass(int n2) {
        int n3 = this.outerClassIndex(n2);
        if (n3 == 0) {
            return null;
        }
        return this.constPool.getClassInfo(n3);
    }

    public void setOuterClassIndex(int n2, int n3) {
        ByteArray.write16bit(n3, this.get(), n2 * 8 + 4);
    }

    public int innerNameIndex(int n2) {
        return ByteArray.readU16bit(this.get(), n2 * 8 + 6);
    }

    public String innerName(int n2) {
        int n3 = this.innerNameIndex(n2);
        if (n3 == 0) {
            return null;
        }
        return this.constPool.getUtf8Info(n3);
    }

    public void setInnerNameIndex(int n2, int n3) {
        ByteArray.write16bit(n3, this.get(), n2 * 8 + 6);
    }

    public int accessFlags(int n2) {
        return ByteArray.readU16bit(this.get(), n2 * 8 + 8);
    }

    public void setAccessFlags(int n2, int n3) {
        ByteArray.write16bit(n3, this.get(), n2 * 8 + 8);
    }

    public void append(String string, String string2, String string3, int n2) {
        int n3 = this.constPool.addClassInfo(string);
        int n4 = this.constPool.addClassInfo(string2);
        int n5 = this.constPool.addUtf8Info(string3);
        this.append(n3, n4, n5, n2);
    }

    public void append(int n2, int n3, int n4, int n5) {
        int n6;
        byte[] byArray = this.get();
        int n7 = byArray.length;
        byte[] byArray2 = new byte[n7 + 8];
        for (n6 = 2; n6 < n7; ++n6) {
            byArray2[n6] = byArray[n6];
        }
        n6 = ByteArray.readU16bit(byArray, 0);
        ByteArray.write16bit(n6 + 1, byArray2, 0);
        ByteArray.write16bit(n2, byArray2, n7);
        ByteArray.write16bit(n3, byArray2, n7 + 2);
        ByteArray.write16bit(n4, byArray2, n7 + 4);
        ByteArray.write16bit(n5, byArray2, n7 + 6);
        this.set(byArray2);
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        byte[] byArray = this.get();
        byte[] byArray2 = new byte[byArray.length];
        ConstPool constPool2 = this.getConstPool();
        InnerClassesAttribute innerClassesAttribute = new InnerClassesAttribute(constPool, byArray2);
        int n2 = ByteArray.readU16bit(byArray, 0);
        ByteArray.write16bit(n2, byArray2, 0);
        int n3 = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = ByteArray.readU16bit(byArray, n3);
            int n5 = ByteArray.readU16bit(byArray, n3 + 2);
            int n6 = ByteArray.readU16bit(byArray, n3 + 4);
            int n7 = ByteArray.readU16bit(byArray, n3 + 6);
            if (n4 != 0) {
                n4 = constPool2.copy(n4, constPool, map);
            }
            ByteArray.write16bit(n4, byArray2, n3);
            if (n5 != 0) {
                n5 = constPool2.copy(n5, constPool, map);
            }
            ByteArray.write16bit(n5, byArray2, n3 + 2);
            if (n6 != 0) {
                n6 = constPool2.copy(n6, constPool, map);
            }
            ByteArray.write16bit(n6, byArray2, n3 + 4);
            ByteArray.write16bit(n7, byArray2, n3 + 6);
            n3 += 8;
        }
        return innerClassesAttribute;
    }
}

