/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.ConstInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;

class FloatInfo
extends ConstInfo {
    static final int tag = 4;
    float value;

    public FloatInfo(float f2, int n2) {
        super(n2);
        this.value = f2;
    }

    public FloatInfo(DataInputStream dataInputStream, int n2) throws IOException {
        super(n2);
        this.value = dataInputStream.readFloat();
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        return object instanceof FloatInfo && ((FloatInfo)object).value == this.value;
    }

    public int getTag() {
        return 4;
    }

    public int copy(ConstPool constPool, ConstPool constPool2, Map map) {
        return constPool2.addFloatInfo(this.value);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(4);
        dataOutputStream.writeFloat(this.value);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("Float ");
        printWriter.println(this.value);
    }
}

